package com.biz.crm.kms.business.audit.match.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.kms.business.audit.match.local.entity.AuditMatchInvoice;
import com.biz.crm.kms.business.audit.match.local.entity.MatchInvoiceManuEntity;
import com.biz.crm.kms.business.audit.match.local.mapper.MatchInvoiceManuMapper;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Set;

/**
 * @author cyj
 * @version 1.0
 * @date 2022/12/19 17:57
 * @description MatchInvoiceManuRepository
 */
@Component
public class MatchInvoiceManuRepository extends ServiceImpl<MatchInvoiceManuMapper, MatchInvoiceManuEntity> {

    /**
     * 根据稽核单号删除数据
     * @param auditCode
     */
    public void deleteByAuditCode(Set<String> auditCode){
        if (!CollectionUtils.isEmpty(auditCode)){
            this.lambdaUpdate().in(MatchInvoiceManuEntity::getAuditCode,auditCode)
                    .remove();
        }
    }

    /**
     * 根据稽核编码查询数据
     *
     * @param auditCode 稽核编码
     * @return
     */
    public List<MatchInvoiceManuEntity> findByAuditCode(String auditCode) {
        return this.lambdaQuery().eq(MatchInvoiceManuEntity::getAuditCode, auditCode).list();
    }

    /**
     * 根据主键集合和单据类型查询数据
     *
     * @param ids
     * @return
     */
    public List<MatchInvoiceManuEntity> findByInvoiceByIds(List<String> ids) {
        return this.lambdaQuery().in(MatchInvoiceManuEntity::getId, ids)
                .list();
    }
    /**
     * 根据稽核的单号查询已匹配验收单
     * @param auditCodes
     * @return
     */
    public List<MatchInvoiceManuEntity> findByAuditCodes(List<String> auditCodes){
        if (CollectionUtils.isEmpty(auditCodes)){
            return Lists.newArrayList();
        }else {
            return this.lambdaQuery().in(MatchInvoiceManuEntity::getAuditCode,auditCodes).list();
        }
    }
}
