package com.biz.crm.kms.business.audit.match.local.service;


import com.biz.crm.kms.business.audit.match.local.entity.AuditMatchConsequence;
import java.util.List;

/**
 * 稽查匹配结果表(AuditMatchConsequence)表服务接口
 *
 * @author songjingen
 * @since 2022-10-26 11:18:44
 */
public interface AuditMatchConsequenceService {

  /**
   * 根据稽核单号集合批量确认，然后调用事件通知
   *
   * @param auditCodes 稽核单号集合
   * @return 修改结果
   */
  void updateConfirmStatusByAuditCodes(List<String> auditCodes);

  /**
   * 新增数据
   *
   * @param auditMatchConsequences 入参集合
   * @return 新增结果
   */
  void createOrUpdateBatch(List<AuditMatchConsequence> auditMatchConsequences);

  /**
   * 自动稽核核定定时任务
   */
  void autoAuditMatchConfirmStatus();
}

