package com.biz.crm.kms.business.audit.match.local.service;


import com.biz.crm.kms.business.audit.match.local.entity.AuditMatchInvoice;
import com.biz.crm.kms.business.audit.match.sdk.vo.InvoiceVo;

import java.util.List;

/**
 * 稽查匹配关联单据表(AuditMatchInvoice)表服务接口
 *
 * @author songjingen
 * @since 2022-11-10 10:06:40
 */
public interface AuditMatchInvoiceService {

  /**
   * 保存数据
   *
   * @param auditMatchInvoices
   */
  void createBatch(List<AuditMatchInvoice> auditMatchInvoices);

  /**
   * 手动匹配保存数据
   * @param ids
   */
  void createBatchManu(List<String> ids,String auditCode);

  /**
   * 删除匹配单据
   *
   * @param ids
   */
  void deleteByInvoiceTypeAndIds(List<String> ids);

  /**
   * 手动匹配单据接口
   * @param auditMatchInvoice
   */
  void addMatching(List<AuditMatchInvoice> auditMatchInvoice,String auditCode);

  /**
   * 查已匹配单据
   * @param auditCode
   * @return
   */
  InvoiceVo findInvoiceByAuditCode(String auditCode);
}

