package com.biz.crm.kms.business.audit.match.local.service;


import com.biz.crm.kms.business.audit.match.local.entity.AuditMatch;
import com.biz.crm.kms.business.audit.match.local.entity.AuditMatchInvoice;
import com.biz.crm.kms.business.audit.match.local.entity.AuditTemplate;
import com.biz.crm.kms.business.audit.match.local.entity.AuditTemplateSupermarket;
import com.biz.crm.kms.business.audit.match.sdk.dto.AuditMatchNotReasonDto;
import com.biz.crm.kms.business.audit.match.sdk.dto.AuditMatchQueryDto;

import java.util.List;

/**
 * 稽查匹配表(AuditMatch)表服务接口
 *
 * @author songjingen
 * @since 2022-10-26 11:18:44
 */
public interface AuditMatchService {

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  AuditMatch findById(String id);

  /**
   * 手动稽核匹配
   *
   * @param dto 条件
   */
  void updateAuditStatusByAuditMatchQueryDto(AuditMatchQueryDto dto);


  /**
   * 手动稽核匹配(新)
   * @param auditMatchInvoices
   */
  void auditMatch(List<AuditMatchInvoice> auditMatchInvoices,String auditCode);


  /**
   * 自动稽核匹配
   */
  void autoAuditMatch();

  /**
   * 自动稽核TEST
   * @param auditCodes
   */
  void autoAuditMatchTest(List<String> auditCodes);

  /**
   * MQ接收消息，处理转换
   */
  void handleMatchDate(List<AuditTemplate> auditTemplateList,List<String> auditCodes);

  /**
   * 抽取SAP数据
   * @param sapDateStart
   * @param sapDateEnd
   * @param directCode
   * @param deliveryCode
   * @return
   */
  String extractSapData(String sapDateStart,String sapDateEnd,String directCode,String deliveryCode);

  /**
   * 更新未匹配原因
   * @param dtoList
   */
  void updateNotMatchReason(List<AuditMatchNotReasonDto> dtoList);

  /**
   * 更新虚出库
   * @param auditCodes
   */
  void updateVirtualStockOut(List<String> auditCodes);

  /**
   * 根据校验字段更新采购单号
   * @param auditMatchs
   */
  void updateRelationOrderCode(List<AuditMatch> auditMatchs);

  /**
   * 根据ids删除稽核单，并且修改105数据转换状态
   * @param ids
   */
  void deleteAuditMatchByIds(List<String> ids);
}

