package com.biz.crm.kms.business.audit.match.local.service;


import com.biz.crm.kms.business.audit.match.sdk.vo.AuditSapVo;

import java.text.ParseException;
import java.util.List;

/**
 * 稽核Sap数据表服务接口
 *
 * @author cyj
 * @since 2022-12-19 14:40:30
 */
public interface AuditSapService {

  /**
   * 根据sap单号查询sap数据
   * @param SapCode
   * @param materialCode
   * @return
   */
  List<AuditSapVo> findBySapCode(String SapCode, String materialCode);


  /**
   * 根据校验字段查询Sap数据
   * @param VerifyCode
   * @return
   */
  List<AuditSapVo> findByVerifyCode(String VerifyCode);
  /**
   * 自动转换稽核数据定时任务
   */
  void autoExtractSapData();

  /**
   * 每天晚上11点同步分子公司垂直出库单
   * @param ds 预留时间分区参数期初视情况调用
   */
  void syncZmfi105();

  void zmfi105(String date);

  void zmfi105ByPage(String ds, int startPageNum,int endPageNum, int pageSize);

  /**
   * 自动转换稽核数据
   * @param sapCodes
   */
  void transSapDate(List<String> sapCodes) throws ParseException;

  /**
   * 手动抓取105数据(MQ)
   * @param ds
   */
  void extractZmfi105(String ds);
}

