package com.biz.crm.kms.business.audit.match.local.service;


import com.biz.crm.kms.business.audit.match.local.entity.AuditTemplateSupermarket;
import java.util.List;

/**
 * 稽查模板商超数据表(AuditTemplateSupermarket)表服务接口
 *
 * @author songjingen
 * @since 2022-10-13 14:40:30
 */
public interface AuditTemplateSupermarketService {

  /**
   * 批量保存数据
   *
   * @param templateSupermarkets 模板商超数据集合
   */
  void createBatch(List<AuditTemplateSupermarket> templateSupermarkets);

  /**
   * 根据模板编码集合删除数据
   *
   * @param templateCodes 模板编码集合
   */
  void deleteByTemplateCodes(List<String> templateCodes);

  /**
   * 根据模板编码集合查询数据集合
   *
   * @param templateCodes 模板编码集合
   * @return 模板商超数据集合
   */
  List<AuditTemplateSupermarket> findByTemplateCodes(List<String> templateCodes);
}

