package com.biz.crm.kms.business.audit.match.local.service;


import com.biz.crm.kms.business.audit.match.local.entity.KmsAuditSummary;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 稽核汇总表(KmsAuditSummary)表服务接口
 *
 * @author cyj
 * @since 2023-01-04 14:44:49
 */
public interface KmsAuditSummaryService {

    /**
     * 分页查询数据
     *
     * @param pageable        分页对象
     * @param kmsAuditSummary 实体对象
     * @return
     */
    Page<KmsAuditSummary> findByConditions(Pageable pageable, KmsAuditSummary kmsAuditSummary);

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    KmsAuditSummary findById(String id);

    /**
     * 新增数据
     *
     * @param kmsAuditSummary 实体对象
     * @return 新增结果
     */
    KmsAuditSummary create(KmsAuditSummary kmsAuditSummary);

    /**
     * 修改新据
     *
     * @param kmsAuditSummary 实体对象
     * @return 修改结果
     */
    KmsAuditSummary update(KmsAuditSummary kmsAuditSummary);

    /**
     * 删除数据
     *
     * @param idList 主键结合
     * @return 删除结果
     */
    void delete(List<String> idList);

    /**
     * 稽核汇总
     * @param auditTemplateCode
     * @param beginDate
     * @param endDate
     */
    void summaryAudit(String auditTemplateCode,String beginDate,String endDate);

    /**
     * 稽核汇总删除
     * @param ids
     */
    void deleteAuditSummary(List<String> ids);
}

