package com.biz.crm.kms.business.audit.match.local.service.internal;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.kms.business.audit.match.local.entity.AuditMatch;
import com.biz.crm.kms.business.audit.match.local.entity.AuditMatchConsequence;
import com.biz.crm.kms.business.audit.match.local.entity.AuditTemplateSupermarket;
import com.biz.crm.kms.business.audit.match.local.repository.AuditMatchConsequenceRepository;
import com.biz.crm.kms.business.audit.match.local.repository.AuditMatchRepository;
import com.biz.crm.kms.business.audit.match.local.repository.AuditSapRepository;
import com.biz.crm.kms.business.audit.match.local.service.AuditMatchConsequenceService;
import com.biz.crm.kms.business.audit.match.local.service.AuditSapService;
import com.biz.crm.kms.business.audit.match.sdk.constant.AuditMatchConstant;
import com.biz.crm.kms.business.audit.match.sdk.dto.*;
import com.biz.crm.kms.business.audit.match.sdk.enums.MatchResultEnum;
import com.biz.crm.kms.business.audit.match.sdk.enums.MatchStatusEnum;
import com.biz.crm.kms.business.audit.match.sdk.enums.SapOrderTypeEnum;
import com.biz.crm.kms.business.audit.match.sdk.listener.AuditMatchConsequenceListener;
import com.biz.crm.kms.business.audit.match.sdk.listener.AuditMatchLogEventListener;
import com.biz.crm.kms.business.audit.match.sdk.listener.KmsAuditTemplateLogEventListener;
import com.biz.crm.kms.business.audit.match.sdk.vo.AuditMatchConsequenceVo;
import com.biz.crm.kms.business.audit.match.sdk.vo.AuditMatchVo;
import com.biz.crm.kms.business.audit.match.sdk.vo.AuditSapVo;
import com.biz.crm.kms.business.financial.auditing.sdk.enums.AuditIsPullEnum;
import com.biz.crm.kms.business.financial.auditing.sdk.service.AuditService;
import com.biz.crm.kms.business.financial.auditing.sdk.vo.AuditVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import static com.biz.crm.kms.business.audit.match.sdk.constant.AuditMatchConstant.KMS_AUDIT_SAP_LOOP_MAX;
import static com.biz.crm.kms.business.audit.match.sdk.constant.AuditMatchConstant.KMS_AUDIT_SAP_PAGE_SIZE;

/**
 * 稽查匹配结果表(AuditMatchConsequence)表服务实现类
 *
 * @author songjingen
 * @since 2022-10-26 11:18:44
 */
@Service("auditMatchConsequenceService")
public class AuditMatchConsequenceServiceImpl implements AuditMatchConsequenceService {

  @Autowired
  private AuditMatchConsequenceRepository auditMatchConsequenceRepository;

  @Autowired(required = false)
  private List<AuditMatchConsequenceListener> auditMatchConsequenceListeners;

  @Autowired
  private AuditMatchRepository auditMatchRepository;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Autowired(required = false)
  private AuditService auditService;

  @Autowired(required = false)
  private AuditSapRepository auditSapRepository;

  @Autowired(required = false)
  private LoginUserService loginUserService;

  @Autowired(required = false)
  private NebulaNetEventClient nebulaNetEventClient;

  @Override
  @Transactional(rollbackFor = Exception.class)
  public void updateConfirmStatusByAuditCodes(List<String> auditCodes) {
    Validate.isTrue(!CollectionUtils.isEmpty(auditCodes), "批量确认时，稽核单号为空！");
    List<AuditMatch> auditMatches = this.auditMatchRepository.findByAuditCodes(auditCodes);
    if (CollectionUtils.isEmpty(auditMatches)){
      return;
    }
    //更新状态和完成人
    FacturerUserDetails loginDetails = this.loginUserService.getLoginDetails(FacturerUserDetails.class);
    for (AuditMatch auditMatch : auditMatches) {
      Validate.isTrue(StringUtils.equals(MatchStatusEnum.M200.getDictCode(),auditMatch.getMatchStatus()),"未匹配或已确认数据的不能确认!");
      auditMatch.setMatchStatus(MatchStatusEnum.M300.getDictCode());
      auditMatch.setFinishName(loginDetails.getRealName());
      auditMatch.setFinishTime(DateUtil.getDate("yyyy-MM-dd HH:mm:ss"));
    }
    List<AuditMatchConsequence> auditMatchConsequences = this.auditMatchConsequenceRepository.findByAuditCodes(auditCodes);
    Map<String, AuditMatchConsequence> consequenceMap = auditMatchConsequences.stream().collect(Collectors.toMap(AuditMatchConsequence::getAuditCode, Function.identity(), (a, b) -> a));
    Validate.isTrue(!CollectionUtils.isEmpty(auditMatchConsequences), "批量确认时，未查询到数据！");
    auditMatchConsequences.forEach(auditMatchConsequence -> auditMatchConsequence.setConfirmStatus(true));
    //更新稽核单
    for (AuditMatch auditMatch : auditMatches) {
      //日志
      AuditMatchDto oldDto = this.nebulaToolkitService.copyObjectByWhiteList(auditMatch, AuditMatchDto.class, HashSet.class, ArrayList.class);
      AuditMatchDto dto = this.nebulaToolkitService.copyObjectByWhiteList(auditMatch, AuditMatchDto.class, HashSet.class, ArrayList.class);
      AuditMatchConsequence auditMatchConsequence = consequenceMap.get(dto.getAuditCode());
      AuditMatchConsequenceDto auditMatchConsequenceDto = this.nebulaToolkitService.copyObjectByWhiteList(auditMatchConsequence, AuditMatchConsequenceDto.class, HashSet.class, ArrayList.class);
      dto.setMatchConsequences(auditMatchConsequenceDto);
      dto.setMatchStatus(MatchStatusEnum.M300.getDictCode());
      AuditMatchLogEventDto logEventDto = new AuditMatchLogEventDto();
      logEventDto.setOriginal(oldDto);
      logEventDto.setNewest(dto);
      SerializableBiConsumer<AuditMatchLogEventListener, AuditMatchLogEventDto> onUpdate =
              AuditMatchLogEventListener::onUpdate;
      this.nebulaNetEventClient.publish(logEventDto, AuditMatchLogEventListener.class, onUpdate);
    }
    this.auditMatchRepository.saveOrUpdateBatch(auditMatches);
    this.auditMatchConsequenceRepository.saveOrUpdateBatch(auditMatchConsequences);
    //进入稽核核定
    this.saveBatchAudit(auditMatchConsequences,auditMatches);
//    //调用监听事件
//    if (!CollectionUtils.isEmpty(this.auditMatchConsequenceListeners)) {
//      List<AuditMatchConsequenceVo> consequenceVos = (List<AuditMatchConsequenceVo>) this.nebulaToolkitService.copyCollectionByWhiteList(auditMatchConsequences, AuditMatchConsequence.class,
//          AuditMatchConsequenceVo.class, HashSet.class, ArrayList.class);
//      Map<String, List<AuditMatchConsequenceVo>> consequenceListMap = consequenceVos.stream().collect(Collectors.groupingBy(AuditMatchConsequenceVo::getAuditCode));
//      List<AuditMatchVo> auditMatchVos = new ArrayList<>();
//      for (AuditMatch auditMatch : auditMatches) {
//        AuditMatchVo auditMatchVo = this.nebulaToolkitService.copyObjectByWhiteList(auditMatch, AuditMatchVo.class, HashSet.class, ArrayList.class);
//        auditMatchVo.setMatchConsequences(consequenceListMap.get(auditMatchVo.getAuditCode()));
//        auditMatchVos.add(auditMatchVo);
//      }
//      this.auditMatchConsequenceListeners.forEach(auditMatchConsequenceListener -> auditMatchConsequenceListener.onConfirm(auditMatchVos));
//    }
  }

  @Override
  @Transactional(rollbackFor = Exception.class)
  public void createOrUpdateBatch(List<AuditMatchConsequence> auditMatchConsequences) {
    Validate.isTrue(!CollectionUtils.isEmpty(auditMatchConsequences), "批量新增时，入参数据为空！");
    auditMatchConsequences.forEach(this::createValidate);
    this.auditMatchConsequenceRepository.saveBatch(auditMatchConsequences);
    Map<String, AuditMatchConsequence> consequenceMap = auditMatchConsequences.stream().collect(Collectors.toMap(AuditMatchConsequence::getAuditCode, Function.identity(), (a, b) -> a));
    //日志
    List<String> auditCodes = auditMatchConsequences.stream().map(AuditMatchConsequence::getAuditCode).collect(Collectors.toList());
//    List<AuditMatch> auditMatchList = this.auditMatchRepository.findByAuditCodes(auditCodes);
//    for (AuditMatch auditMatch : auditMatchList) {
//      //日志
//      AuditMatchDto oldDto = this.nebulaToolkitService.copyObjectByWhiteList(auditMatch, AuditMatchDto.class, HashSet.class, ArrayList.class);
//      AuditMatchDto dto = this.nebulaToolkitService.copyObjectByWhiteList(auditMatch, AuditMatchDto.class, HashSet.class, ArrayList.class);
//      AuditMatchConsequence auditMatchConsequence = consequenceMap.get(dto.getAuditCode());
//      AuditMatchConsequenceDto auditMatchConsequenceDto = this.nebulaToolkitService.copyObjectByWhiteList(auditMatchConsequence, AuditMatchConsequenceDto.class, HashSet.class, ArrayList.class);
//      dto.setMatchConsequences(auditMatchConsequenceDto);
//      dto.setMatchStatus(MatchStatusEnum.M200.getDictCode());
//      AuditMatchLogEventDto logEventDto = new AuditMatchLogEventDto();
//      logEventDto.setOriginal(oldDto);
//      logEventDto.setNewest(dto);
//      SerializableBiConsumer<AuditMatchLogEventListener, AuditMatchLogEventDto> onUpdate =
//              AuditMatchLogEventListener::onUpdate;
//      this.nebulaNetEventClient.publish(logEventDto, AuditMatchLogEventListener.class, onUpdate);
//    }
    List<String> verifyCodes = auditMatchConsequences.stream().map(AuditMatchConsequence::getVerifyCode).distinct().collect(Collectors.toList());
    this.auditSapRepository.updateIsMatchedByVerifyCodes(verifyCodes, BooleanEnum.TRUE.getCapital());
    this.auditMatchRepository.updateAuditMatchStatus(auditCodes,MatchStatusEnum.M200.getDictCode());
  }

  @Override
  public void autoAuditMatchConfirmStatus() {
    Pageable auditMatchPageable = PageRequest.of(1,KMS_AUDIT_SAP_PAGE_SIZE);
    //获取稽核单数据
    List<AuditMatch> auditMatchList = new ArrayList<>();
    AuditMatchDto dto = new AuditMatchDto();
    dto.setMatchStatus(MatchStatusEnum.M200.getDictCode());
    dto.setTenantCode(TenantUtils.getTenantCode());
    dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    dto.setEnableStatus(DelFlagStatusEnum.NORMAL.getCode());
    dto.setMatchConsequence(MatchResultEnum.NO.getDictCode());
    Page<AuditMatch> auditMatchPage = this.auditMatchRepository.findPageByConditions(auditMatchPageable,dto);
    auditMatchList.addAll(auditMatchPage.getRecords());
    while (auditMatchPage.hasNext()
            && KMS_AUDIT_SAP_LOOP_MAX >= auditMatchPageable.getPageNumber()) {
      auditMatchPageable = auditMatchPageable.next();
      auditMatchPage = this.auditMatchRepository.findPageByConditions(auditMatchPageable, dto);
      auditMatchList.addAll(auditMatchPage.getRecords());
    }
    List<String> salesDeliveryCodes = auditMatchList.stream().map(AuditMatch::getSapOrderCode).distinct().collect(Collectors.toList());
    Map<String, List<AuditMatch>> auditMatchMap = auditMatchList.stream().collect(Collectors.groupingBy(AuditMatch::getSapOrderCode));
    //查询105数据
    Pageable auditSapVoPageable = PageRequest.of(1,KMS_AUDIT_SAP_PAGE_SIZE);
    List<AuditSapVo> auditSapVoList = new ArrayList<>();
    AuditSapDto sapDto = new AuditSapDto();
    sapDto.setTenantCode(TenantUtils.getTenantCode());
    sapDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    sapDto.setEnableStatus(DelFlagStatusEnum.NORMAL.getCode());
    sapDto.setSaleVouType(SapOrderTypeEnum.ZOR2.getValue());
    sapDto.setSalesDeliveryCodes(salesDeliveryCodes);
    Page<AuditSapVo> pageByConditions = this.auditSapRepository.findPageByConditions(auditSapVoPageable, sapDto);
    auditSapVoList.addAll(pageByConditions.getRecords());
    while (pageByConditions.hasNext()
            && KMS_AUDIT_SAP_LOOP_MAX >= auditSapVoPageable.getPageNumber()) {
      auditSapVoPageable = auditSapVoPageable.next();
      pageByConditions = this.auditSapRepository.findPageByConditions(auditSapVoPageable, sapDto);
      auditSapVoList.addAll(pageByConditions.getRecords());
    }
    List<AuditMatch> confirmAuditMatch = new ArrayList<>();
    Map<String, List<AuditSapVo>> auditSapVoMap = auditSapVoList.stream().collect(Collectors.groupingBy(AuditSapVo::getSalesDeliveryNo));
    for (Map.Entry<String, List<AuditMatch>> stringListEntry : auditMatchMap.entrySet()) {
      String key = stringListEntry.getKey();
      List<AuditMatch> value = stringListEntry.getValue();
      List<AuditSapVo> auditSapVos = auditSapVoMap.get(key);
      if (value.size() == auditSapVos.size()){
        confirmAuditMatch.addAll(value);
      }
    }
    if (!CollectionUtils.isEmpty(confirmAuditMatch)){
      List<String> auditCodes = confirmAuditMatch.stream().map(AuditMatch::getAuditCode).distinct().collect(Collectors.toList());
      this.updateConfirmStatusByAuditCodes(auditCodes);
    }
  }

  /**
   * 创建验证
   *
   * @param auditMatchConsequence
   */
  private void createValidate(AuditMatchConsequence auditMatchConsequence) {
    Validate.notNull(auditMatchConsequence, "新增时，对象信息不能为空！");
    auditMatchConsequence.setTenantCode(TenantUtils.getTenantCode());
    Validate.notBlank(auditMatchConsequence.getTenantCode(), "新增数据时，租户编号不能为空！");
    Validate.notBlank(auditMatchConsequence.getAuditCode(), "新增数据时，稽核单号不能为空！");
    Validate.notNull(auditMatchConsequence.getConfirmStatus(), "新增数据时，确认状态,0-未确认，1-已确认不能为空！");
    Validate.notNull(auditMatchConsequence.getMatchConsequence(), "新增数据时，匹配结果，0-无差异，1-有差异不能为空！");
  }

  /**
   * 批量保存稽核核定
   * @param auditMatchConsequences
   */
  private void saveBatchAudit(List<AuditMatchConsequence> auditMatchConsequences, List<AuditMatch> auditMatches){
    Map<String, AuditMatchConsequence> consequenceMap = auditMatchConsequences.stream().collect(Collectors.toMap(AuditMatchConsequence::getAuditCode, Function.identity(), (a, b) -> a.getCreateTime().compareTo(b.getCreateTime()) > 0 ? a : b));
    if (CollectionUtils.isEmpty(auditMatches)){
      return;
    }
    Map<String, AuditMatch> auditMatchMap = auditMatches.stream().collect(Collectors.toMap(AuditMatch::getAuditCode, Function.identity(), (a, b) -> a.getCreateTime().compareTo(b.getCreateTime()) > 0 ? a : b));
    for (AuditMatch value : auditMatchMap.values()) {
      AuditMatchConsequence auditMatchConsequence = consequenceMap.get(value.getAuditCode());
      if (Objects.nonNull(auditMatchConsequence)){
        value.setMatchConsequences(auditMatchConsequence);
      }
    }
    //转换数据
    List<AuditVo> auditVoList = this.transAuditVoByConsequence(auditMatchMap);
    //保存数据
    this.auditService.createBatch(auditVoList);
  }

  /**
   * 转换稽核匹配结果为核定数据
   * @param auditMatchMap
   * @return
   */
  private List<AuditVo> transAuditVoByConsequence(Map<String, AuditMatch> auditMatchMap){
    FacturerUserDetails loginDetails = this.loginUserService.getLoginDetails(FacturerUserDetails.class);
    List<AuditVo> auditVoList = new ArrayList<>();
    for (AuditMatch value : auditMatchMap.values()) {
      AuditVo auditVo = new AuditVo();
      auditVo.setBusinessFormatCode(value.getBusinessFormatCode());
      auditVo.setBusinessUnitCode(value.getBusinessUnitCode());
      auditVo.setAuditCode(value.getAuditCode());
      auditVo.setMatchConsequence(value.getMatchConsequences().getMatchConsequence());
      auditVo.setSapPostingDate(value.getSapPostingDate());
      auditVo.setSapDeliveryDate(value.getSapPostingDate());
      auditVo.setDeliveryPartyCode(value.getDeliveryCode());
      auditVo.setDeliveryPartyName(value.getDeliveryName());
      auditVo.setSapMaterialCode(value.getSapMaterialCode());
      auditVo.setSapMaterialName(value.getSapMaterialName());
      auditVo.setKaCode(value.getKaCode());
      auditVo.setKaName(value.getKaName());
      auditVo.setSoldToPartyCode(value.getSoldToPartyCode());
      auditVo.setSoldToPartyName(value.getSoldToPartyName());
      auditVo.setDirectCode(value.getDirectCode());
      auditVo.setDirectName(value.getDirectName());
      auditVo.setIsPull(AuditIsPullEnum.NO.getDictCode());
      auditVo.setBusinessFormatCode(value.getBusinessFormatCode());
      auditVo.setBusinessUnitCode(value.getBusinessUnitCode());
      auditVo.setSapCount(value.getSapEaCount());
      auditVo.setQuantityVariance(value.getMatchConsequences().getQuantityVariance());
      auditVo.setCurUnitAcceptanceQuantity(value.getSapEaCount().subtract(auditVo.getQuantityVariance()));
      auditVo.setSapTotalAmount(value.getSapTotalAmount());
      auditVo.setSapTotalAmountTaxExclusive(value.getSapTotalAmountTaxExclusive());
      auditVo.setAmountVariance(value.getMatchConsequences().getAmountVariance());
      auditVo.setAmountVarianceTaxExclusive(value.getMatchConsequences().getAmountVarianceTaxExclusive());
      auditVo.setAcceptanceAmount(value.getSapTotalAmount().subtract(auditVo.getAmountVariance()));
      auditVo.setAcceptanceAmountNot(value.getSapTotalAmountTaxExclusive().subtract(auditVo.getAmountVarianceTaxExclusive()));
      auditVo.setApprovalDate(DateUtil.getDate("yyyy-MM-dd HH:mm:ss"));
      auditVo.setApprovalPerson(loginDetails.getRealName());
      auditVo.setTemplateCode(value.getTemplateCode());
      auditVo.setDifferType(value.getMatchConsequences().getDifferType());
      auditVoList.add(auditVo);
      auditVo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
      auditVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    }
    return auditVoList;
  }
}

