package com.biz.crm.kms.business.audit.match.local.service.internal;


import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.kms.business.audit.match.local.entity.AuditMatch;
import com.biz.crm.kms.business.audit.match.local.entity.AuditMatchConsequence;
import com.biz.crm.kms.business.audit.match.local.entity.AuditMatchInvoice;
import com.biz.crm.kms.business.audit.match.local.entity.MatchInvoiceManuEntity;
import com.biz.crm.kms.business.audit.match.local.repository.AuditMatchConsequenceRepository;
import com.biz.crm.kms.business.audit.match.local.repository.AuditMatchInvoiceRepository;
import com.biz.crm.kms.business.audit.match.local.repository.AuditMatchRepository;
import com.biz.crm.kms.business.audit.match.local.repository.MatchInvoiceManuRepository;
import com.biz.crm.kms.business.audit.match.local.service.AuditMatchInvoiceService;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import com.biz.crm.kms.business.audit.match.local.service.AuditMatchService;
import com.biz.crm.kms.business.audit.match.sdk.dto.AuditMatchConsequenceDto;
import com.biz.crm.kms.business.audit.match.sdk.dto.AuditMatchDto;
import com.biz.crm.kms.business.audit.match.sdk.dto.AuditMatchLogEventDto;
import com.biz.crm.kms.business.audit.match.sdk.dto.AuditMatchQueryDto;
import com.biz.crm.kms.business.audit.match.sdk.enums.MatchStatusEnum;
import com.biz.crm.kms.business.audit.match.sdk.enums.OrderTypeEnum;
import com.biz.crm.kms.business.audit.match.sdk.enums.PriceTypeEnum;
import com.biz.crm.kms.business.audit.match.sdk.listener.AuditMatchLogEventListener;
import com.biz.crm.kms.business.audit.match.sdk.listener.KmsAuditTemplateLogEventListener;
import com.biz.crm.kms.business.audit.match.sdk.vo.InvoiceReturnOrderVo;
import com.biz.crm.kms.business.audit.match.sdk.vo.InvoiceVo;
import com.biz.crm.kms.business.audit.match.sdk.vo.MatchInvoiceAcceptance;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

/**
 * 稽查匹配关联单据表(AuditMatchInvoice)表服务实现类
 *
 * @author songjingen
 * @since 2022-11-10 10:06:40
 */
@Service("auditMatchInvoiceService")
public class AuditMatchInvoiceServiceImpl implements AuditMatchInvoiceService {

  @Autowired
  private AuditMatchInvoiceRepository auditMatchInvoiceRepository;

  @Autowired(required = false)
  private AuditMatchService auditMatchService;

  @Autowired(required = false)
  private AuditMatchRepository auditMatchRepository;

  @Autowired(required = false)
  private AuditMatchConsequenceRepository auditMatchConsequenceRepository;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Autowired(required = false)
  private NebulaNetEventClient nebulaNetEventClient;

  @Autowired(required = false)
  private MatchInvoiceManuRepository matchInvoiceManuRepository;

  @Override
  @Transactional(rollbackFor = Exception.class)
  public void createBatch(List<AuditMatchInvoice> auditMatchInvoices) {
    //先根据模板和单据类型删除所有数据在进行添加
    Validate.isTrue(!CollectionUtils.isEmpty(auditMatchInvoices), "进行匹配验收单绑定时，未获取到数据");
    Map<String, String> idMap = auditMatchInvoices.stream().collect(Collectors.toMap(AuditMatchInvoice::getRelationId, AuditMatchInvoice::getAuditCode, (a, b) -> a));
    List<MatchInvoiceAcceptance> acceptanceOrder = this.auditMatchInvoiceRepository.findAcceptanceByRelationId(idMap.keySet().stream().collect(Collectors.toList()));
    List<MatchInvoiceManuEntity> order = (List<MatchInvoiceManuEntity>) this.nebulaToolkitService.copyCollectionByWhiteList(acceptanceOrder,MatchInvoiceAcceptance.class, MatchInvoiceManuEntity.class, HashSet.class, ArrayList.class);
    order.forEach(x->{
      x.setAuditCode(idMap.get(x.getAcceptanceGoodsId()));
      x.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
      x.setTenantCode(TenantUtils.getTenantCode());
    });
//    Set<String> auditCodes = auditMatchInvoices.stream().map(AuditMatchInvoice::getAuditCode).collect(Collectors.toSet());
//    this.auditMatchInvoiceRepository.deleteByAuditCode(auditCodes);
    this.matchInvoiceManuRepository.saveBatch(order);
  }

  @Override
  public void createBatchManu(List<String> ids,String auditCode) {
    if (!CollectionUtils.isEmpty(ids)){
      Validate.isTrue(!CollectionUtils.isEmpty(ids), "进行匹配验收单绑定时，未获取到数据");
      List<MatchInvoiceAcceptance> acceptanceOrder = this.auditMatchInvoiceRepository.findAcceptanceByRelationId(ids);
      List<MatchInvoiceManuEntity> order = (List<MatchInvoiceManuEntity>) this.nebulaToolkitService.copyCollectionByWhiteList(acceptanceOrder,MatchInvoiceAcceptance.class, MatchInvoiceManuEntity.class, HashSet.class, ArrayList.class);
      order.forEach(x->{
        x.setAuditCode(auditCode);
        x.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        x.setTenantCode(TenantUtils.getTenantCode());
      });
      this.matchInvoiceManuRepository.saveBatch(order);
    }
  }

  /**
   * 取消匹配接口
   * @param ids
   */
  @Override
  @Transactional(rollbackFor = Exception.class)
  public void deleteByInvoiceTypeAndIds(List<String> ids) {
    Validate.isTrue(!CollectionUtils.isEmpty(ids), "取消单据匹配时，未获取到数据");
    List<MatchInvoiceManuEntity> auditMatchInvoices = this.matchInvoiceManuRepository.findByInvoiceByIds(ids);
    Validate.isTrue(!CollectionUtils.isEmpty(auditMatchInvoices), "取消单据匹配时，未获取到数据");
    if (ids.size() == auditMatchInvoices.size()){
      this.matchInvoiceManuRepository.removeByIds(ids);
    }else {new RuntimeException("个数不匹配");}
    List<String> auditCodes = auditMatchInvoices.stream().map(MatchInvoiceManuEntity::getAuditCode).distinct().collect(Collectors.toList());
    List<AuditMatch> auditMatchList = this.auditMatchRepository.findByAuditCodes(auditCodes);
    //剩下未删除的单据重新进行稽核匹配
    List<MatchInvoiceManuEntity> returnAuditMatchInvoices = this.matchInvoiceManuRepository.findByAuditCodes(auditCodes);
    if (!CollectionUtils.isEmpty(returnAuditMatchInvoices)){
      this.addMatching(null,auditCodes.get(0));
    }else {
      //如果全部删完,则改变稽核单状态为待匹配
      //日志
      for (AuditMatch auditMatch : auditMatchList) {
        AuditMatchDto oldDto = this.nebulaToolkitService.copyObjectByWhiteList(auditMatch, AuditMatchDto.class, HashSet.class, ArrayList.class);
        AuditMatchDto dto = this.nebulaToolkitService.copyObjectByWhiteList(auditMatch, AuditMatchDto.class, HashSet.class, ArrayList.class);
        dto.setMatchConsequences(null);
        dto.setMatchStatus(MatchStatusEnum.M100.getDictCode());
        AuditMatchLogEventDto logEventDto = new AuditMatchLogEventDto();
        logEventDto.setOriginal(oldDto);
        logEventDto.setNewest(dto);
        SerializableBiConsumer<AuditMatchLogEventListener, AuditMatchLogEventDto> onUpdate =
                AuditMatchLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish(logEventDto, AuditMatchLogEventListener.class, onUpdate);
      }
      this.auditMatchConsequenceRepository.deleteByAuditCodes(auditCodes);
      auditMatchRepository.updateAuditMatchStatus(auditCodes, MatchStatusEnum.M100.getDictCode());
    }
  }

  /**
   * 手动匹配单据接口
   * @param auditMatchInvoices
   */
  @Override
  public void addMatching(List<AuditMatchInvoice> auditMatchInvoices,String auditCode){
    if (CollectionUtils.isEmpty(auditMatchInvoices) && StringUtils.isNotEmpty(auditCode)){
      this.auditMatchService.auditMatch(null,auditCode);
    }
    if (!CollectionUtils.isEmpty(auditMatchInvoices) && StringUtils.isEmpty(auditCode)){
      auditMatchInvoices.forEach(x->{
        this.createValidate(x);
      });
      this.auditMatchService.auditMatch(auditMatchInvoices,null);
    }
  }


  /**
   * 创建验证
   *
   * @param auditMatchInvoice
   */
  private void createValidate(AuditMatchInvoice auditMatchInvoice) {
    Validate.notNull(auditMatchInvoice, "新增时，对象信息不能为空！");
    auditMatchInvoice.setId(null);
    Validate.notBlank(auditMatchInvoice.getAuditCode(), "新增数据时，稽核单号不能为空！");
    Validate.notBlank(auditMatchInvoice.getInvoiceCode(), "新增数据时，稽核单号不能为空！");
    Validate.notBlank(auditMatchInvoice.getInvoiceType(), "新增数据时，单据类型不能为空！");
    Validate.notBlank(auditMatchInvoice.getTemplateCode(), "新增数据时，模板编码不能为空！");
    Validate.notBlank(auditMatchInvoice.getRelationId(),"新增数据时，关系id不能为空！");
  }

  @Override
  public InvoiceVo findInvoiceByAuditCode(String auditCode) {
    InvoiceVo invoiceVo = new InvoiceVo();
    Validate.isTrue(StringUtils.isNotEmpty(auditCode),"未获取稽核单号!");
    List<MatchInvoiceManuEntity> acceptanceInvoice = this.matchInvoiceManuRepository.findByAuditCode(auditCode);
    List<MatchInvoiceAcceptance> acceptanceOrder = (List<MatchInvoiceAcceptance>) this.nebulaToolkitService.copyCollectionByWhiteList(acceptanceInvoice,MatchInvoiceManuEntity.class,MatchInvoiceAcceptance.class, HashSet.class, ArrayList.class);
    invoiceVo.setMatchInvoiceAcceptance(acceptanceOrder);
    return invoiceVo;
//    List<AuditMatchInvoice> invoiceList = this.auditMatchInvoiceRepository.findByAuditCode(auditCode);
//    if (!CollectionUtils.isEmpty(invoiceList)){
//      Map<String, List<AuditMatchInvoice>> typeMap = invoiceList.stream().collect(Collectors.groupingBy(AuditMatchInvoice::getInvoiceType));
//      List<String> acceptanceRelationId = new ArrayList<>();
//      List<String> returnOrderRelationId = new ArrayList<>();
//      typeMap.forEach((k,v)->{
//        switch (OrderTypeEnum.getByDictCode(k)) {
//          case ACCEPTANCE:
//            acceptanceRelationId.addAll(v.stream().distinct().map(AuditMatchInvoice::getRelationId).collect(Collectors.toList()));
//            break;
//          case RETURN:
//            returnOrderRelationId.addAll(v.stream().distinct().map(AuditMatchInvoice::getRelationId).collect(Collectors.toList()));
//            break;
//          default:
//            break;
//        }
//      });
//      //查询验收单
//      if (!CollectionUtils.isEmpty(acceptanceRelationId)){
//        List<MatchInvoiceAcceptance> acceptanceOrder = this.auditMatchInvoiceRepository.findAcceptanceByRelationId(acceptanceRelationId);
//        invoiceVo.setMatchInvoiceAcceptance(acceptanceOrder);
//      }
//      //查询退货单
//      if (!CollectionUtils.isEmpty(returnOrderRelationId)){
//        List<InvoiceReturnOrderVo> returnOrder = this.auditMatchInvoiceRepository.findReturnByRelationId(returnOrderRelationId);
//        invoiceVo.setInvoiceReturnOrderVo(returnOrder);
//      }
//    }
  }
}

