package com.biz.crm.kms.business.audit.match.local.service.internal;

import com.biz.crm.kms.business.audit.match.local.entity.AuditMatch;
import com.biz.crm.kms.business.audit.match.local.entity.AuditMatchConsequence;
import com.biz.crm.kms.business.audit.match.local.entity.AuditTemplate;
import com.biz.crm.kms.business.audit.match.local.model.MatchConsequenceCalculatedAbstract;
import com.biz.crm.kms.business.audit.match.local.model.MatchConsequenceCalculatedModel;
import com.biz.crm.kms.business.audit.match.local.repository.AuditMatchConsequenceRepository;
import com.biz.crm.kms.business.audit.match.local.repository.AuditMatchRepository;
import com.biz.crm.kms.business.audit.match.local.service.AuditMatchThreadService;
import com.biz.crm.kms.business.audit.match.sdk.register.InvoiceMatchRegister;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Title: AuditMatchThreadServiceImpl
 * @Package: com.biz.crm.kms.business.audit.match.local.service.internal
 * @Description:
 * @Author: wuxia
 * @Date: 2022/12/1 - 6:24 PM
 */
@Service
public class AuditMatchThreadServiceImpl implements AuditMatchThreadService {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private AuditMatchConsequenceRepository auditMatchConsequenceRepository;

    @Autowired(required = false)
    private List<InvoiceMatchRegister> invoiceMatchRegisters;

    @Autowired(required = false)
    private ApplicationContext applicationContext;

    @Autowired(required = false)
    private AuditMatchRepository auditMatchRepository;



    /**
     * 使用线程异步进行匹配
     * @param auditTemplate
     * @param auditMatchList
     */
    @Override
    @Async
    public void threadHandleMatchDate(AuditTemplate auditTemplate,List<AuditMatch> auditMatchList) {
        //组装成可执行的数据
        List<MatchConsequenceCalculatedModel> calculatedModels = new ArrayList<>();
        List<String> auditCodes = new ArrayList<>();
        for (AuditMatch match : auditMatchList) {
            MatchConsequenceCalculatedModel calculatedModel = this.nebulaToolkitService.copyObjectByWhiteList(match, MatchConsequenceCalculatedModel.class, HashSet.class, ArrayList.class);
            calculatedModels.add(calculatedModel);
            auditCodes.add(match.getAuditCode());
        }
        //查询出已经匹配的数据然后赋值id
        List<AuditMatchConsequence> auditMatchConsequences = this.auditMatchConsequenceRepository.findByAuditCodes(auditCodes);
        if (!CollectionUtils.isEmpty(auditMatchConsequences)) {
            Map<String, String> auditMatchConsequenceMap = auditMatchConsequences.stream()
                    .collect(Collectors.toMap(AuditMatchConsequence::getAuditCode, AuditMatchConsequence::getId, (a, b) -> a));
            calculatedModels.stream().forEach(o -> o.setId(auditMatchConsequenceMap.get(o.getAuditCode())));
        }
        for (InvoiceMatchRegister invoiceMatchRegister : this.invoiceMatchRegisters) {
            if (invoiceMatchRegister.getMatchLogicCode().equals(auditTemplate.getMatchLogicCode())) {
                Class<?> matchLogicCalculatedStrategy = invoiceMatchRegister.getMatchLogicCalculatedAbstract();
                MatchConsequenceCalculatedAbstract bean = (MatchConsequenceCalculatedAbstract) this.applicationContext.getBean(matchLogicCalculatedStrategy);
                bean.executeAuto(auditTemplate, calculatedModels);
                break;
            }
        }
    }
}
