package com.biz.crm.kms.business.audit.match.local.service.internal;

import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.kms.business.audit.match.local.entity.AuditMatch;
import com.biz.crm.kms.business.audit.match.local.entity.AuditTemplate;
import com.biz.crm.kms.business.audit.match.local.entity.AuditTemplateSupermarket;
import com.biz.crm.kms.business.audit.match.local.model.MatchConsequenceCalculatedModel;
import com.biz.crm.kms.business.audit.match.local.repository.AuditMatchRepository;
import com.biz.crm.kms.business.audit.match.local.repository.AuditTemplateRepository;
import com.biz.crm.kms.business.audit.match.local.repository.AuditTemplateSupermarketRepository;
import com.biz.crm.kms.business.audit.match.sdk.constant.AuditMatchConstant;
import com.biz.crm.kms.business.audit.match.sdk.dto.AuditMatchDto;
import com.biz.crm.kms.business.audit.match.sdk.enums.MatchParamsEnum;
import com.biz.crm.kms.business.audit.match.sdk.service.AuditMatchVoService;
import com.biz.crm.kms.business.audit.match.sdk.vo.AuditMatchVo;
import com.biz.crm.kms.business.audit.match.sdk.vo.InvoiceReturnOrderVo;
import com.biz.crm.kms.business.audit.match.sdk.vo.MatchInvoiceAcceptance;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;

import java.util.*;
import java.util.stream.Collectors;

import com.google.common.collect.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

/**
 * 稽核匹配voService实现类
 *
 * @author songjingen
 * @date 2022/10/26 15:21
 */
@Service
public class AuditMatchVoServiceImpl implements AuditMatchVoService {

  @Autowired
  private AuditMatchRepository auditMatchRepository;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Autowired(required = false)
  private GenerateCodeService generateCodeService;

  @Autowired(required = false)
  private AuditTemplateRepository auditTemplateRepository;

  @Override
  @Transactional
  public void createBatch(List<AuditMatchDto> matchDtos) {
    Validate.isTrue(!CollectionUtils.isEmpty(matchDtos), "创建数据时，未获取到入参集合！");
    List<AuditMatch> auditMatches = (List<AuditMatch>) this.nebulaToolkitService.copyCollectionByWhiteList(matchDtos, AuditMatchDto.class,
        AuditMatch.class, HashSet.class, ArrayList.class);
    auditMatches.forEach(this::createValidate);
    this.auditMatchRepository.saveBatch(auditMatches);
  }


  /**
   * 查找该单据未关联的验收单
   * @param pageable
   * @param id
   * @param startTime
   * @param endTime
   * @param orderNumber
   * @return
   */
  @Override
  public List<MatchInvoiceAcceptance> notMatchInvoiceAcceptance(Pageable pageable,String id,String startTime,String endTime,String orderNumber){
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
    AuditMatch auditMatch = this.auditMatchRepository.getById(id);
    //查模板
    AuditTemplate auditTemplate = this.auditTemplateRepository.findByTemplateCode(auditMatch.getTemplateCode());
    Validate.isTrue(Objects.nonNull(auditTemplate),"未获取到改稽核单模板!");
    List<String> productCodes = Lists.newArrayList();
    List<String> storeCodes = Lists.newArrayList();
    List<String> orderCodes = Lists.newArrayList();
    List<String> soldToPartyCodes = Lists.newArrayList();
    List<String> params = Arrays.stream(auditTemplate.getMatchParams().split(",")).collect(Collectors.toList());
    if (params.contains(MatchParamsEnum.PRODUCT.getDictCode())) {
      productCodes.add(auditMatch.getSapMaterialCode());
    }
    if (params.contains(MatchParamsEnum.STORE.getDictCode())) {
      storeCodes.add(auditMatch.getDeliveryCode());
    }
    if (params.contains(MatchParamsEnum.ORDER.getDictCode())) {
      orderCodes.add(auditMatch.getRelationOrderCode());
    }
    if (params.contains(MatchParamsEnum.SOLDTOPARTY.getDictCode())) {
      soldToPartyCodes.add(auditMatch.getSoldToPartyCode());
    }
    List<MatchInvoiceAcceptance> MatchInvoiceAcceptances = this.auditMatchRepository.notMatchInvoice(pageable,auditMatch.getDirectCode(),storeCodes,productCodes,startTime,endTime,orderNumber,orderCodes,soldToPartyCodes);
    return MatchInvoiceAcceptances;
  }
  /**
   * 查找该单据未关联的退货单
   * @param id
   */
  @Override
  public List<InvoiceReturnOrderVo> notMatchInvoiceReturn(Pageable pageable,String id){
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
    AuditMatch auditMatch = this.auditMatchRepository.getById(id);
    List<InvoiceReturnOrderVo> notMatchInvoices = this.auditMatchRepository.notMatchInvoiceReturn(pageable,auditMatch.getDirectCode(),auditMatch.getSoldToPartyCode(),auditMatch.getStoreCode());
    return notMatchInvoices;
  }

  /**
   * 添加或修改备注
   * @param id
   * @param remake
   */
  @Override
  public void addOrUpdateRemake(String id, String remake){
     AuditMatch auditMatch = this.auditMatchRepository.getById(id);
     auditMatch.setRemark(remake);
     this.auditMatchRepository.updateById(auditMatch);
  }

  @Override
  public Page<AuditMatchVo> findAuditMatchPageByConditions(Pageable pageable, AuditMatchDto dto) {
    return this.auditMatchRepository.findAuditMatchVoPageByConditions(pageable,dto);
  }

  /**
   * 创建验证
   *
   * @param auditMatch
   */
  private void createValidate(AuditMatch auditMatch) {
    Validate.notNull(auditMatch, "新增时，对象信息不能为空！");
    auditMatch.setId(null);
    auditMatch.setTenantCode(TenantUtils.getTenantCode());
    auditMatch.setAuditCode(this.generateCodeService.generateCode(AuditMatchConstant.AUDIT_CODE, 1).get(0));
    Validate.notBlank(auditMatch.getTenantCode(), "新增数据时，租户编号不能为空！");
    Validate.notBlank(auditMatch.getAuditCode(), "新增数据时，稽核单号不能为空！");
    Validate.notBlank(auditMatch.getDeliveryCode(), "新增数据时，送达方编码不能为空！");
    Validate.notBlank(auditMatch.getSapOrderCode(), "新增数据时，关联订单号不能为空！");
    Validate.notBlank(auditMatch.getDirectCode(), "新增数据时，系统编码不能为空！");
    Validate.notNull(auditMatch.getSapEaCount(), "新增数据时，ERP单数量（EA）不能为空！");
    Validate.notNull(auditMatch.getSapTotalAmount(), "新增数据时，ERP总金额不能为空！");
    Validate.notNull(auditMatch.getSapTotalAmountTaxExclusive(), "新增数据时，ERP总金额（不含税）不能为空！");

  }
}
