package com.biz.crm.kms.business.audit.match.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.kms.business.audit.match.local.entity.AuditMatch;
import com.biz.crm.kms.business.audit.match.local.entity.AuditSapEntity;
import com.biz.crm.kms.business.audit.match.local.entity.AuditTemplate;
import com.biz.crm.kms.business.audit.match.local.entity.AuditTemplateSupermarket;
import com.biz.crm.kms.business.audit.match.local.repository.*;
import com.biz.crm.kms.business.audit.match.local.service.AuditSapService;
import com.biz.crm.kms.business.audit.match.local.service.AuditSapTransService;
import com.biz.crm.kms.business.audit.match.sdk.constant.AuditMatchConstant;
import com.biz.crm.kms.business.audit.match.sdk.dto.AuditMatchDto;
import com.biz.crm.kms.business.audit.match.sdk.dto.AuditMatchLogEventDto;
import com.biz.crm.kms.business.audit.match.sdk.enums.*;
import com.biz.crm.kms.business.audit.match.sdk.listener.AuditMatchLogEventListener;
import com.biz.crm.kms.business.audit.match.sdk.vo.AuditSapVo;
import com.biz.crm.kms.business.direct.product.sdk.dto.DirectProductDto;
import com.biz.crm.kms.business.direct.product.sdk.service.DirectProductVoService;
import com.biz.crm.kms.business.direct.product.sdk.vo.DirectProductVo;
import com.biz.crm.kms.business.direct.sdk.service.DirectVoService;
import com.biz.crm.kms.business.direct.sdk.vo.DirectVo;
import com.biz.crm.kms.business.direct.store.sdk.service.DirectStoreVoService;
import com.biz.crm.kms.business.direct.store.sdk.vo.DirectStoreVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.kms.business.invoice.sdk.enums.ConstantEnums;
import com.biz.crm.mdm.business.product.sdk.dto.ProductQueryDto;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.common.base.service.RedisCrmService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.mn.third.system.dataphin.sdk.DataphinService;
import com.biz.crm.mn.third.system.dataphin.sdk.vo.Zmfi105Vo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

/**
 * @author cyj
 * @version 1.0
 * @date 2022/12/19 17:55
 * @description AuditSapServiceImpl
 */
@Slf4j
@Service("auditSapService")
public class AuditSapServiceImpl implements AuditSapService {

    @Autowired(required = false)
    private RedisMutexService redisMutexService;
    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private RedisCrmService redisCrmService;

    @Autowired(required = false)
    private AuditSapRepository auditSapRepository;

    @Autowired(required = false)
    private RocketMqProducer rocketMqProducer;

    @Autowired(required = false)
    private AuditTemplateRepository auditTemplateRepository;

    @Autowired(required = false)
    private AuditTemplateSupermarketRepository auditTemplateSupermarketRepository;

    @Autowired(required = false)
    private DirectVoService directVoService;

    @Autowired(required = false)
    private DirectStoreVoService directStoreVoService;

    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    @Autowired(required = false)
    private AuditMatchRepository auditMatchRepository;
    @Autowired
    private DataphinService dataphinService;
    @Autowired
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    @Autowired(required = false)
    private DirectProductVoService directProductVoService;

    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired(required = false)
    private AuditSapTransService auditSapTransService;

    @Autowired(required = false)
    private RedisService redisService;

    @Autowired(required = false)
    private ProductVoService productVoService;

    /**
     * 订单抬头匹配采购单号常量
     */
    private static String rgx = "^[A-Za-z0-9]+$";

    @Override
    public List<AuditSapVo> findBySapCode(String sapCode, String materialCode) {
        List<AuditSapVo> sapEntities = this.auditSapRepository.findBySapCode(sapCode, materialCode);
        List<AuditSapEntity> returnOrderListVertical = this.auditSapRepository.findReturnOrderBySalesDeliveryCode(sapCode);
        if (CollectionUtils.isEmpty(returnOrderListVertical)) {
            List<AuditSapVo> returnVerticalVos = (List<AuditSapVo>) this.nebulaToolkitService.copyCollectionByBlankList(returnOrderListVertical, AuditSapEntity.class
                    , AuditSapVo.class, HashSet.class, ArrayList.class);
            sapEntities.addAll(returnVerticalVos);
        }
        return sapEntities;
    }

    @Override
    public List<AuditSapVo> findByVerifyCode(String VerifyCode) {
        List<AuditSapVo> sapEntities = this.auditSapRepository.findByVerifyCode(VerifyCode);
        if (!CollectionUtils.isEmpty(sapEntities)){
            String sapCode = sapEntities.get(0).getSalesDeliveryNo();
            List<AuditSapEntity> returnOrderListVertical = this.auditSapRepository.findReturnOrderBySalesDeliveryCode(sapCode);
            if (CollectionUtils.isEmpty(returnOrderListVertical)) {
                List<AuditSapVo> returnVerticalVos = (List<AuditSapVo>) this.nebulaToolkitService.copyCollectionByBlankList(returnOrderListVertical, AuditSapEntity.class
                        , AuditSapVo.class, HashSet.class, ArrayList.class);
                sapEntities.addAll(returnVerticalVos);
            }
        }
        return sapEntities;
    }

    @Override
    public void autoExtractSapData() {
        //SAP数据自动生成稽核单锁定时间
        log.info("=====>    SAP数据自动生成稽核单 start   <=====");
        boolean lock = redisMutexService.tryLock(AuditMatchConstant.KMS_AUDIT_SAP_REDIS_LOCK, TimeUnit.SECONDS, AuditMatchConstant.KMS_AUDIT_REDIS_TIME);
        if (!lock) {
            log.warn("SAP数据正在自动转换中,本次生成被忽略!");
            log.info("=====>    SAP数据自动生成稽核单 end   <=====");
            return;
        }
        Pageable pageable = PageRequest.of(1,AuditMatchConstant.KMS_AUDIT_SAP_PAGE_SIZE);
        String transStatus = SapTransStatusEnum.NOT_TRANS.getValue();
        Set<String> currentSapCodeSet = new HashSet<>(AuditMatchConstant.KMS_AUDIT_SAP_PAGE_SIZE);
        try {
            //查询待转换SAP数据信息
            Page<String> sapCodePage = this.auditSapRepository.findSapPageByTransStatus(pageable, transStatus);
            currentSapCodeSet.addAll(sapCodePage.getRecords());
            this.sendMqMessage(sapCodePage.getRecords());
            while (sapCodePage.hasNext()
                    && AuditMatchConstant.KMS_AUDIT_SAP_LOOP_MAX >= pageable.getPageNumber()) {
                pageable = pageable.next();
                sapCodePage = this.auditSapRepository.findSapPageByTransStatus(pageable, transStatus);
                currentSapCodeSet.clear();
                currentSapCodeSet.addAll(sapCodePage.getRecords());
                this.sendMqMessage(sapCodePage.getRecords());
            }
        } catch (Exception e) {
            log.error("", e);
            if (CollectionUtil.isNotEmpty(currentSapCodeSet)) {
                //异常时,删除当前加锁redis
                redisCrmService.hdel(AuditMatchConstant.KMS_AUDIT_SAP_REDIS_LOCK, currentSapCodeSet.toArray());
            }
        } finally {
            redisMutexService.unlock(AuditMatchConstant.KMS_AUDIT_SAP_REDIS_LOCK);
        }
        log.info("=====>    SAP数据自动生成稽核单 end   <=====");
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void transSapDate(List<String> sapCodes) {
        if (CollectionUtil.isEmpty(sapCodes)) {
            log.warn("未接收到需转换SAP单号！");
            return;
        }
        List<AuditMatch> auditMatchList = this.buildAuditMatchDate(sapCodes);
        if (!CollectionUtils.isEmpty(auditMatchList)) {
            //日志
//            for (AuditMatch auditMatch : auditMatchList) {
//                AuditMatchLogEventDto logEventDto = new AuditMatchLogEventDto();
//                logEventDto.setOriginal(null);
//                AuditMatchDto dto = this.nebulaToolkitService.copyObjectByWhiteList(auditMatch, AuditMatchDto.class, HashSet.class, ArrayList.class);
//                logEventDto.setNewest(dto);
//                SerializableBiConsumer<AuditMatchLogEventListener, AuditMatchLogEventDto> onCreate =
//                        AuditMatchLogEventListener::onCreate;
//                this.nebulaNetEventClient.publish(logEventDto, AuditMatchLogEventListener.class, onCreate);
//            }
            this.auditMatchRepository.saveBatch(auditMatchList);
            List<String> verifyCodes = auditMatchList.stream().map(AuditMatch::getVerifyCode).distinct().collect(Collectors.toList());
            this.auditSapRepository.updateStatus(verifyCodes, SapTransStatusEnum.SUCCESS.getValue());
        }
    }

    @Override
    public void extractZmfi105(String ds) {
        log.info("=====>    抓取SAP数据 start   <=====");
        if (redisMutexService.islock(AuditMatchConstant.KMS_SAP_REDIS_LOCK)){
            throw new IllegalArgumentException("SAP正在抓取中，请等待!本次请求结束!");
        }else {
            boolean lock = redisMutexService.tryLock(AuditMatchConstant.KMS_SAP_REDIS_LOCK, TimeUnit.SECONDS, AuditMatchConstant.KMS_AUDIT_REDIS_TIME);
            if (!lock) {
                log.warn("加锁失败,请重试!");
                throw new IllegalArgumentException("SAP正在抓取中，请等待!本次请求结束!");
            }
        }
        if (StringUtils.isNotEmpty(ds)){
            String date = DateUtil.format(ds,DateUtil.DEFAULT_YEAR_MONTH_DAY_NO_CH);
            this.sendZmfi105MqMessage(date);
        }
    }

    private void sendZmfi105MqMessage(String date) {
        if (StringUtils.isEmpty(date)) {
            return;
        }
        //发送MQ消息开始转换单据
        MqMessageVo message = new MqMessageVo();
        message.setMsgBody(JSON.toJSONString(date));
        message.setTag(AuditMatchConstant.KMS_SAP_REDIS_MESSAGE_TAG);
        message.setTopic(AuditMatchConstant.KMS_SAP_TOPIC + RocketMqUtil.mqEnvironment());
        rocketMqProducer.sendMqMsg(message);
        try {
            //单位：毫秒 防止MQ消息发送过于频繁
            Thread.sleep(200);
        } catch (Exception e) {
            log.error("", e);
        }
    }

    /**
     * 自动稽核发送 MQ消息
     *
     * @param sapCodes 模板集合
     */
    private void sendMqMessage(List<String> sapCodes) {
        if (CollectionUtils.isEmpty(sapCodes)) {
            return;
        }
        //过滤单号为空的数据
        sapCodes = sapCodes.stream()
                .filter(StringUtils::isNotBlank)
                .distinct()
                .collect(Collectors.toList());
        if (CollectionUtils.isEmpty(sapCodes)) {
            log.error("SAP数据有空的sapCode编码[sales_delivery_no]存在!");
            return;
        }
        //过滤正在转换的SAP单号
        this.filterSwitchIngOrderNumberList(sapCodes);
        if (CollectionUtil.isEmpty(sapCodes)) {
            return;
        }

        //发送MQ消息开始转换单据
        MqMessageVo message = new MqMessageVo();
        message.setMsgBody(JSON.toJSONString(sapCodes));
        message.setTag(AuditMatchConstant.KMS_AUDIT_SAP_MESSAGE_TAG);
        message.setTopic(AuditMatchConstant.KMS_AUDIT_SAP_TOPIC + RocketMqUtil.mqEnvironment());
        rocketMqProducer.sendMqMsg(message);
        try {
            //单位：毫秒 防止MQ消息发送过于频繁
            Thread.sleep(200);
        } catch (Exception e) {
            log.error("", e);
        }
    }

    /**
     * 过滤正在转换的稽核模板
     *
     * @param sapCodes sap编码集合
     */
    private void filterSwitchIngOrderNumberList(List<String> sapCodes) {
        if (CollectionUtil.isEmpty(sapCodes)) {
            return;
        }
        //获取redis已存在key
        List<Object> updateList = redisCrmService.hmget(AuditMatchConstant.KMS_AUDIT_SAP_REDIS_LOCK, new HashSet<>(sapCodes));

        if (CollectionUtil.isNotEmpty(updateList)) {
            sapCodes.removeAll(updateList.stream()
                    .filter(Objects::nonNull)
                    .filter(k -> StringUtils.isNotEmpty(k.toString()))
                    .map(Object::toString)
                    .collect(Collectors.toList()));
        }

        Map<String, String> redisMap = sapCodes.stream()
                .collect(Collectors.toMap(key -> key, key -> key, (oldValue, newValue) -> newValue));

        //当前执行效率很高,锁定30分钟即可
        redisCrmService.hmset(AuditMatchConstant.KMS_AUDIT_SAP_REDIS_LOCK, redisMap, TimeUnit.SECONDS, AuditMatchConstant.KMS_AUDIT_REDIS_TIME);
    }


    /**
     * 构建稽核单
     *
     * @param sapCodes
     * @return
     */
    private List<AuditMatch> buildAuditMatchDate(List<String> sapCodes) {
        if (CollectionUtil.isEmpty(sapCodes)) {
            return Collections.emptyList();
        }
        List<AuditSapEntity> auditSapEntityList = this.auditSapRepository.findSapByTypeAndSalesDeliveryNo(SapOrderTypeEnum.ZOR2.getValue(), sapCodes);
        if (CollectionUtil.isEmpty(auditSapEntityList)) {
            log.warn("不存在或已删除！");
            return Lists.newArrayList();
        }
        //构建系统信息
        List<String> serviceCodes = auditSapEntityList.stream().map(AuditSapEntity::getServiceCode).distinct().collect(Collectors.toList());
        Map<String, DirectVo> directVoMap = this.buildDirectVoInfo(serviceCodes);

        //查询门店信息
        List<DirectStoreVo> directStoreVos = directStoreVoService.findByDeliveryCodes(serviceCodes);
        if (CollectionUtils.isEmpty(directStoreVos)){
            log.warn("未根据送达方查询到系统和门店信息!");
            return null;
        }
        Map<String, DirectStoreVo> directStoreVoMap = directStoreVos.stream().filter(vo -> StringUtils.isNotEmpty(vo.getTerminalCode()) && StringUtils.isNotEmpty(vo.getDirectCode())).distinct().collect(Collectors.toMap(entity -> (entity.getDirectCode() + "_" + entity.getTerminalCode()), Function.identity(),(a,b)->a));
        //根据系统，送达方，物料编码去找上架产品
        Set<String> directCodes = directVoMap.values().stream().map(DirectVo::getDirectCode).collect(Collectors.toSet());
        Set<String> productCodes = auditSapEntityList.stream().map(AuditSapEntity::getMaterialCode).collect(Collectors.toSet());
        Map<String, List<DirectProductVo>> productMaps = this.buildProductInfo(directCodes, serviceCodes.stream().collect(Collectors.toSet()), productCodes);
//        if (MapUtils.isEmpty(productMaps)){
//            log.error("未能根据条件查询到上架产品!");
//        }

        //找退货单
        Map<String, AuditSapEntity> sapReturnMap = this.findByReturnMap(auditSapEntityList);
        //查询模板
        List<AuditTemplateSupermarket> templateSupermarketList = this.auditTemplateSupermarketRepository.findByDirectCodes(Lists.newArrayList(directCodes));
        if (CollectionUtils.isEmpty(templateSupermarketList)){
            log.warn("未根据商超获取模板信息!");
            return null;
        }
        List<String> templateSupermarketCodes = templateSupermarketList.stream().distinct().map(AuditTemplateSupermarket::getTemplateCode).collect(Collectors.toList());
        List<AuditTemplate> auditTemplateList = this.auditTemplateRepository.findByTemplateCodes(templateSupermarketCodes);
        if (CollectionUtils.isEmpty(auditTemplateList)){
            log.warn("模板为未启用状态!");
            return null;
        }
        Map<String, AuditTemplate> templateMap = auditTemplateList.stream().distinct().collect(Collectors.toMap(AuditTemplate::getTemplateCode, Function.identity(), (a, b) -> a));
        List<String> templateCodes = auditTemplateList.stream().distinct().map(AuditTemplate::getTemplateCode).collect(Collectors.toList());
        Map<String, AuditTemplateSupermarket> templateSupermarketMap = templateSupermarketList.stream().filter(entity-> templateCodes.contains(entity.getTemplateCode())).collect(Collectors.toMap(AuditTemplateSupermarket::getDirectCode, Function.identity(), (a, b) -> a));
        //赋值组装数据
        List<AuditMatch> auditMatchList = this.convertDate(auditSapEntityList, templateSupermarketMap, sapReturnMap, directVoMap, productMaps,directStoreVoMap,templateMap);
        return auditMatchList;
    }

    private List<AuditMatch> convertDate(List<AuditSapEntity> auditSapEntityList,
                                         Map<String, AuditTemplateSupermarket> templateSupermarketMap,
                                         Map<String, AuditSapEntity> sapReturnMap,
                                         Map<String, DirectVo> directVoMap,
                                         Map<String, List<DirectProductVo>> productMaps,
                                         Map<String, DirectStoreVo> directStoreVoMap,
                                         Map<String, AuditTemplate> templateMap) {
        List<AuditMatch> auditMatchList = new ArrayList<>();
        //获取缓存税率
        Object o = redisService.get(AuditMatchConstant.CACHE_PRODUCT_TAX_RATE);
        Map<String,BigDecimal> productTaxMap = (Map<String, BigDecimal>) o;
        //组装数据
        List<AuditSapEntity> auditSapEntities = new ArrayList<>();
        Map<String, List<AuditSapEntity>> materialMap = auditSapEntityList.stream().collect(Collectors.groupingBy(vo -> StringUtils.joinWith("_", vo.getSalesDeliveryNo(), vo.getMaterialCode())));
        for (List<AuditSapEntity> value : materialMap.values()) {
            AuditSapEntity auditSapEntitySummary = value.get(0);
            BigDecimal addNum = BigDecimal.ZERO;
            for (AuditSapEntity auditSapEntity : value) {
                addNum = addNum.add(new BigDecimal(auditSapEntity.getOrderNum1()));
            }
            auditSapEntitySummary.setOrderNum1(String.valueOf(addNum));
            auditSapEntities.add(auditSapEntitySummary);
        }
        for (AuditSapEntity auditSapEntity : auditSapEntities) {
            AuditMatch auditMatch = new AuditMatch();
            DirectVo directVo = directVoMap.get(auditSapEntity.getServiceCode());
            if (Objects.isNull(directVo)) {
                continue;
            }
            AuditTemplateSupermarket auditTemplateSupermarket = templateSupermarketMap.get(directVo.getDirectCode());
            if (Objects.isNull(auditTemplateSupermarket)) {
                continue;
            }
            AuditTemplate auditTemplate = templateMap.get(auditTemplateSupermarket.getTemplateCode());
            String createAuditStatus = auditTemplate.getCreateAuditStatus();
            if (CreateAuditMatchEnum.GOODSMOVESTATUS.getDictCode().equals(createAuditStatus)){
                if (!StringUtils.equals("C",auditSapEntity.getGoodsMoveStatus())){
                    continue;
                }
            }else if (CreateAuditMatchEnum.INVOICESTATUS.getDictCode().equals(createAuditStatus)){
                if (!StringUtils.equals("C",auditSapEntity.getInvoiceStatus())){
                    continue;
                }
            }
            auditMatch.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            auditMatch.setEnableStatus(DelFlagStatusEnum.NORMAL.getCode());
            auditMatch.setDirectCode(directVo.getDirectCode());
            auditMatch.setDirectName(directVo.getSupermarketName());
            auditMatch.setBusinessFormatCode(directVo.getBusinessFormatCode());
            auditMatch.setBusinessUnitCode(directVo.getBusinessUnitCode());
            auditMatch.setTemplateCode(auditTemplateSupermarket.getTemplateCode());
            auditMatch.setKaName(auditTemplateSupermarket.getSupermarketName());
            auditMatch.setKaCode(auditTemplateSupermarket.getSupermarketCode());
            auditMatch.setSapPostingDate(DateUtil.getDateByFormat(this.transition(auditSapEntity.getShippingAccountDate()), DateUtil.DEFAULT_YEAR_MONTH_DAY));
            //处理订单抬头的采购单号
            if (StringUtils.isNotEmpty(auditSapEntity.getOrderHeader())) {
                List<String> purchaseOrderNo = Arrays.stream(auditSapEntity.getOrderHeader().split("/")).collect(Collectors.toList());
                if (StringUtils.isNotEmpty(purchaseOrderNo.get(0))) {
                    if (Pattern.matches(rgx, purchaseOrderNo.get(0))) {
                        auditMatch.setRelationOrderCode(purchaseOrderNo.get(0));
                    }
                }
            }
            auditMatch.setVerifyCode(auditSapEntity.getVerifyCode());
            auditMatch.setSapPrice(auditSapEntity.getOrderRegularPrice());
            auditMatch.setSoldToPartyCode(auditSapEntity.getDealerCode());
            auditMatch.setSoldToPartyName(auditSapEntity.getDealerName());
            auditMatch.setDeliveryCode(auditSapEntity.getServiceCode());
            auditMatch.setDeliveryName(auditSapEntity.getServiceName());
            auditMatch.setSapMaterialCode(auditSapEntity.getMaterialCode());
            auditMatch.setSapMaterialName(auditSapEntity.getMaterialName());
            auditMatch.setSalesOrderNumber(auditSapEntity.getSalesOrderNo());
            //获取区域
            String areaKey = StringUtils.joinWith("_",auditMatch.getDirectCode(),auditMatch.getDeliveryCode());
            if (MapUtils.isNotEmpty(directStoreVoMap)){
                DirectStoreVo directStoreVo = directStoreVoMap.get(areaKey);
                if (Objects.nonNull(directStoreVo)){
                    auditMatch.setKaStoreCode(directStoreVo.getSupermarketStoreCode());
                    auditMatch.setKaStoreName(directStoreVo.getSupermarketStoreName());
                    auditMatch.setBusinessArea(directStoreVo.getBusinessArea());
                    auditMatch.setProvinceCode(directStoreVo.getProvinceCode());
                    auditMatch.setProvinceName(directStoreVo.getProvinceName());
                }
            }
            //获取物料
            DirectProductVo productVo = this.getGoodsInfo(auditMatch, productMaps);
            if (Objects.nonNull(productVo)) {
                auditMatch.setSapMaterialName(productVo.getProductName());
            } else {
                auditMatch.setSapMaterialName("未根据条件查询到上架产品!");
            }
            //获取税率
            BigDecimal taxRate = BigDecimal.ZERO;
            if (MapUtils.isNotEmpty(productTaxMap)){
                BigDecimal productTax = productTaxMap.get(auditMatch.getSapMaterialCode());
                if (productTax != null && productTax.compareTo(BigDecimal.ZERO) != 0){
                    taxRate = taxRate.add(productTax);
                }
            }
            //退货单,减数量算金额
            BigDecimal orderNum = new BigDecimal(auditSapEntity.getOrderNum1() == null ? "0":auditSapEntity.getOrderNum1());
            String returnKey = StringUtils.joinWith("_", auditSapEntity.getSalesDeliveryNo(), auditSapEntity.getMaterialCode());
            BigDecimal sapTotalAmount = BigDecimal.ZERO;
            if (CreateAuditMatchEnum.INVOICESTATUS.equals(createAuditStatus)){
                sapTotalAmount = auditSapEntity.getDeliveryAfterDiscountAmt().subtract(auditSapEntity.getInvoiceDiscountAmt() == null ? BigDecimal.ZERO:auditSapEntity.getInvoiceDiscountAmt());
            }else {
                sapTotalAmount = auditSapEntity.getDeliveryDeforeDiscountAmt() == null ? BigDecimal.ZERO:auditSapEntity.getDeliveryDeforeDiscountAmt();
            }
            AuditSapEntity returnOrder = sapReturnMap.get(returnKey);
            if (!Objects.isNull(returnOrder)) {
                BigDecimal returnNum = new BigDecimal(returnOrder.getOrderNum1()).add(orderNum);
                if (BigDecimal.ZERO.compareTo(returnNum) == 0){
                    continue;
                }
                BigDecimal sapTotalAmountTaxExclusive = BigDecimal.ZERO;
                BigDecimal returnMoney = BigDecimal.ZERO;
                if (CreateAuditMatchEnum.INVOICESTATUS.equals(createAuditStatus)){
                    returnMoney = returnOrder.getDeliveryAfterDiscountAmt().subtract(returnOrder.getInvoiceDiscountAmt() == null ? BigDecimal.ZERO:returnOrder.getInvoiceDiscountAmt());
                }else {
                    returnMoney = returnOrder.getDeliveryDeforeDiscountAmt() == null ? BigDecimal.ZERO:returnOrder.getDeliveryDeforeDiscountAmt();
                }
                sapTotalAmount = sapTotalAmount.add(returnMoney);
                BigDecimal noTax = sapTotalAmount.divide(BigDecimal.ONE.add(taxRate),4,BigDecimal.ROUND_HALF_UP);
                sapTotalAmountTaxExclusive = sapTotalAmountTaxExclusive.add(noTax);
                auditMatch.setSapEaCount(returnNum);
                auditMatch.setSapTotalAmount(sapTotalAmount);
                auditMatch.setSapTotalAmountTaxExclusive(sapTotalAmountTaxExclusive);
            } else {
                auditMatch.setSapEaCount(orderNum);
                auditMatch.setSapTotalAmount(sapTotalAmount);
                auditMatch.setSapTotalAmountTaxExclusive(sapTotalAmount.divide(BigDecimal.ONE.add(taxRate),4,BigDecimal.ROUND_HALF_UP));
            }
            auditMatch.setMatchStatus(MatchStatusEnum.M100.getDictCode());
            auditMatch.setWaitDays(0);
            auditMatch.setSapOrderCode(auditSapEntity.getSalesDeliveryNo());
            auditMatch.setTenantCode(TenantUtils.getTenantCode());
            auditMatchList.add(auditMatch);
        }
        if (!CollectionUtils.isEmpty(auditMatchList)) {
            List<String> auditCodes = this.generateCodeService.generateCode(AuditMatchConstant.AUDIT_CODE, auditMatchList.size());
            for (int i = 0; i < auditMatchList.size(); i++) {
                auditMatchList.get(i).setAuditCode(auditCodes.get(i));
            }
        }
        //设置编码
        return auditMatchList;
    }
    @DynamicTaskService(cornExpression = "0 0 23 * * ?", taskDesc = "同步分子公司垂直出库单(105文档)")
    @Override
    public void syncZmfi105() {
        loginUserService.refreshAuthentication(null);
        AbstractCrmUserIdentity loginUser = loginUserService.getAbstractLoginUser();
        Date nowTime = new Date();
        Date date = DateUtil.dateAddDay(nowTime, -1);
        String ds = DateUtil.format(date, "yyyyMMdd");
        //通过字典获取需要同步的销售组织
        List<DictDataVo> dictDatas = dictDataVoService.findByDictTypeCode("sync_105_sales_org_code");
        Validate.notEmpty(dictDatas, "同步105数据的销售组织的数据字典未配置");
        List<String> salesOrgCodes = dictDatas.stream().map(DictDataVo::getDictCode).collect(Collectors.toList());
        String tenantCode = TenantUtils.getTenantCode();
        List<AuditSapEntity> saveList = new ArrayList<>();
        List<AuditSapEntity> updateList = new ArrayList<>();
        log.info("本次同步数据开始!");
        String totalSql = AuditMatchConstant.PULL_TOTAL_SQL + "(" + this.getInSqlStr(salesOrgCodes) + ") and " + " DS = '" + ds + "'";
        String sql = AuditMatchConstant.PULL_SQL + "(" + this.getInSqlStr(salesOrgCodes) + ")" + " and DS = '" + ds + "' order by sales_delivery_no,sales_delivery_item_no desc LIMIT ";
        List<Zmfi105Vo> zmfi105Vo = this.dataphinService.getZmfi105Vo(200, totalSql, sql);
        if (CollectionUtils.isEmpty(zmfi105Vo)) {
            log.info("本次同步数据量为0,同步结束!");
            return;
        }
        List<List<Zmfi105Vo>> partition = Lists.partition(zmfi105Vo, 2000);
//        分片处理
        for (List<Zmfi105Vo> zmfi105VoList : partition) {
            zmfi105VoList = zmfi105VoList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(vo -> vo.getSalesDeliveryNo() + vo.getSalesDeliveryItemNo()))), ArrayList::new));
            Collection<AuditSapEntity> auditSapEntities = this.nebulaToolkitService.copyCollectionByWhiteList(zmfi105VoList, Zmfi105Vo.class, AuditSapEntity.class, HashSet.class, ArrayList.class);
            List<AuditSapEntity> sapEntities = auditSapEntities.stream().collect(Collectors.toList());
            Set<String> productCodes = sapEntities.stream().map(AuditSapEntity::getMaterialCode).collect(Collectors.toSet());
            ProductQueryDto dto = new ProductQueryDto();
            dto.setProductCodeList(Lists.newArrayList(productCodes.stream().map(a -> a.substring(6)).collect(Collectors.toList())));
            List<ProductVo> productVos = this.productVoService.findByQueryDto(dto);
            Map<String, List<ProductVo>> productVosMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty(productVos)) {
                Map<String, List<ProductVo>> productVoMap = productVos.stream().collect(Collectors.groupingBy(ProductVo::getProductCode));
                productVosMap.putAll(productVoMap);
            }
            sapEntities.forEach(o -> {
                o.setId(IdUtil.fastUUID().replace("-", ""));
                o.setTenantCode(tenantCode);
                o.setCreateName(loginUser.getRealName());
                o.setCreateAccount(loginUser.getAccount());
                o.setCreateTime(nowTime);
                o.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                try {
                    if (StringUtils.isNotEmpty(o.getShippingAccountDate())){
                        Date posDate = new SimpleDateFormat("yyyyMMdd").parse(o.getShippingAccountDate());
                        o.setSapPostingDate(posDate);
                    }
                } catch (ParseException e) {
                    throw new RuntimeException(e);
                }
                o.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                if (o.getMaterialCode().startsWith("000000")) {
                    o.setMaterialCode(o.getMaterialCode().substring(6, o.getMaterialCode().length()));
                }
                o.setVerifyCode(o.getSalesDeliveryNo().concat(o.getSalesDeliveryItemNo()));
                //产品相关信息
                List<ProductVo> productVoList = productVosMap.get(o.getMaterialCode());
                ProductVo productVo = null;
                if (!CollectionUtils.isEmpty(productVoList)) {
                    productVo = productVoList.get(0);
                    o.setProductBrandCode(productVo.getProductBrandCode());
                    o.setProductBrandName(productVo.getProductBrandName());
                    o.setProductCategoryCode(productVo.getProductCategoryCode());
                    o.setProductCategoryName(productVo.getProductCategoryName());
                    o.setProductLevelCode(productVo.getProductLevelCode());
                    o.setProductLevelName(productVo.getProductLevelName());
                }
            });
            List<String> verifyCodeList = sapEntities.stream()
                    .map(AuditSapEntity::getVerifyCode).collect(Collectors.toList());
            // TODO: 2023/3/2 区分新增 分页接口
            List<AuditSapEntity> byVerifyCodes = auditSapRepository.findByVerifyCodes(verifyCodeList);
            if (CollectionUtils.isEmpty(byVerifyCodes)) {
                this.auditSapTransService.saveDataList(sapEntities);
            } else {
                Map<String, AuditSapEntity> map = byVerifyCodes.stream().collect(Collectors.toMap(AuditSapEntity::getVerifyCode, Function.identity(), (a, b) -> a));
                for (AuditSapEntity sapEntity : sapEntities) {
                    if (!map.containsKey(sapEntity.getVerifyCode())) {
                        saveList.add(sapEntity);
                    } else if (StringUtils.isNotEmpty(map.get(sapEntity.getVerifyCode()).getInvoiceStatus()) && StringUtils.equals("C", map.get(sapEntity.getVerifyCode()).getInvoiceStatus())) {
                        AuditSapEntity auditSapEntity = map.get(sapEntity.getVerifyCode());
                        sapEntity.setId(auditSapEntity.getId());
                        updateList.add(sapEntity);
                    }
                }
                if (saveList.size() > 0) {
                    this.auditSapTransService.saveDataList(saveList);
                }
                if (updateList.size() > 0) {
                    this.auditSapRepository.updateBatchDate(updateList, TenantUtils.getTenantCode());
                }
                saveList.clear();
                updateList.clear();
                sapEntities.clear();
            }
        }
        //发送MQ消息开始分子公司日销售105同步
        MqMessageVo message = new MqMessageVo();
        message.setMsgBody(ds);
        message.setTopic(AuditMatchConstant.TPM_SAP_SALES_TOPIC + RocketMqUtil.mqEnvironment());
        message.setTag(AuditMatchConstant.TPM_SAP_SALES_MESSAGE_TAG);
        log.info("-------------------------------------------------------------------------------------------------------" +
                "---------------------------------------------------KMS105发送消息-----------------------------------------------------");
        rocketMqProducer.sendMqMsg(message);
        log.info("-------------------------------------------------------------------------------------------------------" +
                "---------------------------------------------------KMS105发送消息结束-----------------------------------------------------");
        try {
            //单位：毫秒 防止MQ消息发送过于频繁
            Thread.sleep(200);
        } catch (Exception e) {
            log.error("", e);
        }
    }
    /**
     * 每天晚上11点同步分子公司垂直出库单
     */
    @Override
    public void zmfi105(String ds) {
        loginUserService.refreshAuthentication(null);
        AbstractCrmUserIdentity loginUser = loginUserService.getAbstractLoginUser();
        Date nowTime = new Date();
        if (StringUtils.isEmpty(ds)) {
            Date date = DateUtil.dateAddDay(nowTime, -1);
            ds = DateUtil.format(date, "yyyyMMdd");
        }
        //通过字典获取需要同步的销售组织
        List<DictDataVo> dictDatas = dictDataVoService.findByDictTypeCode("sync_105_sales_org_code");
        Validate.notEmpty(dictDatas, "同步105数据的销售组织的数据字典未配置");
        List<String> salesOrgCodes = dictDatas.stream().map(DictDataVo::getDictCode).collect(Collectors.toList());
        String tenantCode = TenantUtils.getTenantCode();
        List<AuditSapEntity> saveList = new ArrayList<>();
        List<AuditSapEntity> updateList = new ArrayList<>();
        log.info("本次同步数据开始!");
        String totalSql = AuditMatchConstant.PULL_TOTAL_SQL + "(" + this.getInSqlStr(salesOrgCodes) + ") and " + " DS = '" + ds + "'";
        String sql = AuditMatchConstant.PULL_SQL + "(" + this.getInSqlStr(salesOrgCodes) + ")" + " and DS = '" + ds + "' order by sales_delivery_no,sales_delivery_item_no desc LIMIT ";
        List<Zmfi105Vo> zmfi105Vo = this.dataphinService.getZmfi105Vo(200, totalSql, sql);
        if (CollectionUtils.isEmpty(zmfi105Vo)) {
            log.info("本次同步数据量为0,同步结束!");
            return;
        }
        List<List<Zmfi105Vo>> partition = Lists.partition(zmfi105Vo, 2000);
        //分片处理
            for (List<Zmfi105Vo> zmfi105VoList : partition) {
                zmfi105VoList = zmfi105VoList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(vo -> vo.getSalesDeliveryNo() + vo.getSalesDeliveryItemNo()))), ArrayList::new));
                Collection<AuditSapEntity> auditSapEntities = this.nebulaToolkitService.copyCollectionByWhiteList(zmfi105VoList, Zmfi105Vo.class, AuditSapEntity.class, HashSet.class, ArrayList.class);
                List<AuditSapEntity> sapEntities = auditSapEntities.stream().collect(Collectors.toList());
                Set<String> productCodes = sapEntities.stream().map(AuditSapEntity::getMaterialCode).collect(Collectors.toSet());
                ProductQueryDto dto = new ProductQueryDto();
                dto.setProductCodeList(Lists.newArrayList(productCodes.stream().map(a -> a.substring(6)).collect(Collectors.toList())));
                List<ProductVo> productVos = this.productVoService.findByQueryDto(dto);
                Map<String, List<ProductVo>> productVosMap = Maps.newHashMap();
                if (!CollectionUtils.isEmpty(productVos)) {
                    Map<String, List<ProductVo>> productVoMap = productVos.stream().collect(Collectors.groupingBy(ProductVo::getProductCode));
                    productVosMap.putAll(productVoMap);
                }
                sapEntities.forEach(o -> {
                    o.setId(IdUtil.fastUUID().replace("-", ""));
                    o.setTenantCode(tenantCode);
                    o.setCreateName(loginUser.getRealName());
                    o.setCreateAccount(loginUser.getAccount());
                    o.setCreateTime(nowTime);
                    o.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    o.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                    if (o.getMaterialCode().startsWith("000000")) {
                        o.setMaterialCode(o.getMaterialCode().substring(6, o.getMaterialCode().length()));
                    }
                    o.setVerifyCode(o.getSalesDeliveryNo().concat(o.getSalesDeliveryItemNo()));
                    //产品相关信息
                    List<ProductVo> productVoList = productVosMap.get(o.getMaterialCode());
                    ProductVo productVo = null;
                    if (!CollectionUtils.isEmpty(productVoList)) {
                        productVo = productVoList.get(0);
                        o.setProductBrandCode(productVo.getProductBrandCode());
                        o.setProductBrandName(productVo.getProductBrandName());
                        o.setProductCategoryCode(productVo.getProductCategoryCode());
                        o.setProductCategoryName(productVo.getProductCategoryName());
                        o.setProductLevelCode(productVo.getProductLevelCode());
                        o.setProductLevelName(productVo.getProductLevelName());
                    }
                });
                List<String> verifyCodeList = sapEntities.stream()
                        .map(AuditSapEntity::getVerifyCode).collect(Collectors.toList());
                // TODO: 2023/3/2 区分新增 分页接口
                List<AuditSapEntity> byVerifyCodes = auditSapRepository.findByVerifyCodes(verifyCodeList);
                if (CollectionUtils.isEmpty(byVerifyCodes)) {
                    this.auditSapTransService.saveDataList(sapEntities);
                } else {
                    Map<String, AuditSapEntity> map = byVerifyCodes.stream().collect(Collectors.toMap(AuditSapEntity::getVerifyCode, Function.identity(), (a, b) -> a));
                    for (AuditSapEntity sapEntity : sapEntities) {
                        if (!map.containsKey(sapEntity.getVerifyCode())) {
                            saveList.add(sapEntity);
                        }else {
                            AuditSapEntity auditSapEntity = map.get(sapEntity.getVerifyCode());
                            sapEntity.setId(auditSapEntity.getId());
                            updateList.add(sapEntity);
                        }
                    }
                    if (saveList.size() > 0) {
                        this.auditSapTransService.saveDataList(saveList);
                    }
                    if (updateList.size() > 0){
                        this.auditSapRepository.updateBatchDate(updateList,TenantUtils.getTenantCode());
                    }
                    saveList.clear();
                    updateList.clear();
                }
            }
            this.redisMutexService.unlock(AuditMatchConstant.KMS_SAP_REDIS_LOCK);
            //发送MQ消息开始分子公司日销售105同步
            MqMessageVo message = new MqMessageVo();
            message.setMsgBody(ds);
            message.setTopic(AuditMatchConstant.TPM_SAP_SALES_TOPIC + RocketMqUtil.mqEnvironment());
            message.setTag(AuditMatchConstant.TPM_SAP_SALES_MESSAGE_TAG);
            rocketMqProducer.sendMqMsg(message);
            try {
                //单位：毫秒 防止MQ消息发送过于频繁
                Thread.sleep(200);
            } catch (Exception e) {
                log.error("", e);
            }
    }

    @Override
    public void zmfi105ByPage(String ds, int startPageNum,int endPageNum, int pageSize) {
        loginUserService.refreshAuthentication(null);
        AbstractCrmUserIdentity loginUser = loginUserService.getAbstractLoginUser();
        Date nowTime = new Date();
        if (StringUtils.isEmpty(ds)) {
            Date date = DateUtil.dateAddDay(nowTime, -1);
            ds = DateUtil.format(date, "yyyyMMdd");
        }
        //通过字典获取需要同步的销售组织
        List<DictDataVo> dictDatas = dictDataVoService.findByDictTypeCode("sync_105_sales_org_code");
        Validate.notEmpty(dictDatas, "同步105数据的销售组织的数据字典未配置");
        List<String> salesOrgCodes = dictDatas.stream().map(DictDataVo::getDictCode).collect(Collectors.toList());
        String tenantCode = TenantUtils.getTenantCode();
        List<AuditSapEntity> saveList = new ArrayList<>();
        List<AuditSapEntity> updateList = new ArrayList<>();
        log.info("本次同步数据开始!");
        String totalSql = AuditMatchConstant.PULL_TOTAL_SQL + "(" + this.getInSqlStr(salesOrgCodes) + ") and " + " DS = '" + ds + "'";
        String sql = AuditMatchConstant.PULL_SQL + "(" + this.getInSqlStr(salesOrgCodes) + ")" + " and DS = '" + ds + "' order by sales_delivery_no,sales_delivery_item_no desc LIMIT ";
        List<Zmfi105Vo> zmfi105Vo = this.dataphinService.getZmfi105Vo(totalSql, sql,startPageNum,endPageNum,pageSize);
        if (CollectionUtils.isEmpty(zmfi105Vo)) {
            log.info("本次同步数据量为0,同步结束!");
            return;
        }
        List<List<Zmfi105Vo>> partition = Lists.partition(zmfi105Vo, 2000);
//        分片处理
        for (List<Zmfi105Vo> zmfi105VoList : partition) {
            zmfi105VoList = zmfi105VoList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(vo -> vo.getSalesDeliveryNo() + vo.getSalesDeliveryItemNo()))), ArrayList::new));
            Collection<AuditSapEntity> auditSapEntities = this.nebulaToolkitService.copyCollectionByWhiteList(zmfi105VoList, Zmfi105Vo.class, AuditSapEntity.class, HashSet.class, ArrayList.class);
            List<AuditSapEntity> sapEntities = auditSapEntities.stream().collect(Collectors.toList());
            Set<String> productCodes = sapEntities.stream().map(AuditSapEntity::getMaterialCode).collect(Collectors.toSet());
            ProductQueryDto dto = new ProductQueryDto();
            dto.setProductCodeList(Lists.newArrayList(productCodes.stream().map(a -> a.substring(6)).collect(Collectors.toList())));
            List<ProductVo> productVos = this.productVoService.findByQueryDto(dto);
            Map<String, List<ProductVo>> productVosMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty(productVos)) {
                Map<String, List<ProductVo>> productVoMap = productVos.stream().collect(Collectors.groupingBy(ProductVo::getProductCode));
                productVosMap.putAll(productVoMap);
            }
            sapEntities.forEach(o -> {
                o.setId(IdUtil.fastUUID().replace("-", ""));
                o.setTenantCode(tenantCode);
                o.setCreateName(loginUser.getRealName());
                o.setCreateAccount(loginUser.getAccount());
                o.setCreateTime(nowTime);
                o.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                try {
                    if (StringUtils.isNotEmpty(o.getShippingAccountDate())){
                        Date posDate = new SimpleDateFormat("yyyyMMdd").parse(o.getShippingAccountDate());
                        o.setSapPostingDate(posDate);
                    }
                } catch (ParseException e) {
                    throw new RuntimeException(e);
                }
                o.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                if (o.getMaterialCode().startsWith("000000")) {
                    o.setMaterialCode(o.getMaterialCode().substring(6, o.getMaterialCode().length()));
                }
                o.setVerifyCode(o.getSalesDeliveryNo().concat(o.getSalesDeliveryItemNo()));
                //产品相关信息
                List<ProductVo> productVoList = productVosMap.get(o.getMaterialCode());
                ProductVo productVo = null;
                if (!CollectionUtils.isEmpty(productVoList)) {
                    productVo = productVoList.get(0);
                    o.setMaterialName(productVo.getProductName());
                    o.setProductBrandCode(productVo.getProductBrandCode());
                    o.setProductBrandName(productVo.getProductBrandName());
                    o.setProductCategoryCode(productVo.getProductCategoryCode());
                    o.setProductCategoryName(productVo.getProductCategoryName());
                    o.setProductLevelCode(productVo.getProductLevelCode());
                    o.setProductLevelName(productVo.getProductLevelName());
                }
            });
            List<String> verifyCodeList = sapEntities.stream()
                    .map(AuditSapEntity::getVerifyCode).collect(Collectors.toList());
            // TODO: 2023/3/2 区分新增 分页接口
            List<AuditSapEntity> byVerifyCodes = auditSapRepository.findByVerifyCodes(verifyCodeList);
            if (CollectionUtils.isEmpty(byVerifyCodes)) {
                this.auditSapTransService.saveDataList(sapEntities);
            } else {
                Map<String, AuditSapEntity> map = byVerifyCodes.stream().collect(Collectors.toMap(AuditSapEntity::getVerifyCode, Function.identity(), (a, b) -> a));
                for (AuditSapEntity sapEntity : sapEntities) {
                    if (!map.containsKey(sapEntity.getVerifyCode())) {
                        saveList.add(sapEntity);
                    } else if (StringUtils.isNotEmpty(map.get(sapEntity.getVerifyCode()).getInvoiceStatus()) && StringUtils.equals("C", map.get(sapEntity.getVerifyCode()).getInvoiceStatus())) {
                        AuditSapEntity auditSapEntity = map.get(sapEntity.getVerifyCode());
                        sapEntity.setId(auditSapEntity.getId());
                        updateList.add(sapEntity);
                    }
                }
                if (saveList.size() > 0) {
                    this.auditSapTransService.saveDataList(saveList);
                }
                if (updateList.size() > 0) {
                    this.auditSapRepository.updateBatchDate(updateList, TenantUtils.getTenantCode());
                }
                saveList.clear();
                updateList.clear();
                sapEntities.clear();
            }
        }
    }

    /**
     * 获取in sql的字符串
     * @param list
     * @return
     */
    public static String getInSqlStr(List<String> list){
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(list)){
            return null;
        }
        String str="";
        for (String s : list) {
            str=str+"'"+s+"'"+",";
        }
        return str.substring(0,str.length()-1);
    }
    /**
     * 构建商品信息
     *
     * @param deliveryPartyCodeSet
     * @param productCodes
     * @return
     */
    private Map<String, List<DirectProductVo>> buildProductInfo(Set<String> directCodeSet,
                                                                Set<String> deliveryPartyCodeSet,
                                                                Set<String> productCodes) {
        Map<String, List<DirectProductVo>> directProductMap = Maps.newHashMap();
        if (CollectionUtil.isEmpty(directCodeSet)
                || CollectionUtil.isEmpty(deliveryPartyCodeSet)
                || CollectionUtil.isEmpty(productCodes)) {
            return directProductMap;
        }
        List<List<String>> productCodeGroupList = Lists.partition(Lists.newArrayList(productCodes), ConstantEnums.PRODUCT_SIZE.getValue());
        DirectProductDto directProductDto = new DirectProductDto();
        directProductDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        directProductDto.setTenantCode(TenantUtils.getTenantCode());
        directProductDto.setOnShelfStatus(BooleanEnum.TRUE.getCapital());
        directProductDto.setDirectCodes(new ArrayList<>(directCodeSet));
        directProductDto.setDeliveryPartyCodes(new ArrayList<>(deliveryPartyCodeSet));
        directProductDto.setOrderType("acceptance");
        productCodeGroupList.forEach(productCodeList -> {
            directProductDto.setProductCodes(productCodeList);
            List<DirectProductVo> productList = this.directProductVoService.findByDirectProductDto(directProductDto);
            if (CollectionUtil.isNotEmpty(productList)) {
                directProductMap.putAll(productList.stream()
                        .filter(k -> BooleanEnum.TRUE.getCapital().equals(k.getOnShelfStatus()))
                        .filter(k -> StringUtils.isNotBlank(k.getDirectCode()))
                        .filter(k -> StringUtils.isNotBlank(k.getDeliveryPartyCode()))
                        .filter(k -> StringUtils.isNotBlank(k.getProductCode()))
                        .collect(Collectors.groupingBy(k -> k.getDirectCode()
                                + "_" + k.getDeliveryPartyCode()
                                + "_" + k.getProductCode())));
            }
        });
        return directProductMap;
    }

    /**
     * 构建商品转换明细信息
     *
     * @param auditMatch
     * @param directProductMap
     * @return
     */
    private DirectProductVo getGoodsInfo(AuditMatch auditMatch,
                                         Map<String, List<DirectProductVo>> directProductMap) {
        DirectProductVo productVo = null;
        if (StringUtils.isBlank(auditMatch.getSapMaterialCode())) {
            return null;
        }
        if (MapUtils.isEmpty(directProductMap)) {
            return null;
        }
        List<DirectProductVo> productVoList = directProductMap.get(auditMatch.getDirectCode() + "_" +
                auditMatch.getDeliveryCode() + "_" + auditMatch.getSapMaterialCode());
        if (CollectionUtil.isEmpty(productVoList)) {
            return null;
        } else  {
            productVo = productVoList.get(0);
        }
        return productVo;
    }

    private Map<String, DirectVo> buildDirectVoInfo(List<String> serviceCodes) {
        if (CollectionUtils.isEmpty(serviceCodes)) {
            return null;
        }
        //根据送达方去找系统
        List<DirectStoreVo> directStoreVos = directStoreVoService.findByDeliveryCodes(serviceCodes);
        Validate.isTrue(!CollectionUtil.isEmpty(directStoreVos), "未根据送达方查询到系统和门店信息!");
        Map<String, String> directStoreVoMap = directStoreVos.stream().collect(Collectors.toMap(DirectStoreVo::getTerminalCode, DirectStoreVo::getDirectCode, (a, b) -> a));
        List<String> directCodes = directStoreVos.stream().map(DirectStoreVo::getDirectCode).distinct().collect(Collectors.toList());
        List<DirectVo> directVoList = directVoService.findByDirectCodes(directCodes);
        Map<String, DirectVo> directVoMap = directVoList.stream().collect(Collectors.toMap(DirectVo::getDirectCode, Function.identity()));
        Map<String, DirectVo> resultDirectVoMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(directVoMap)) {
            for (String service : directStoreVoMap.keySet()) {
                if (directVoMap.containsKey(directStoreVoMap.get(service))) {
                    resultDirectVoMap.put(service, directVoMap.get(directStoreVoMap.get(service)));
                }
            }
        }
        return resultDirectVoMap;
    }

    /**
     * @param prodDate
     * @return
     */
    private String transition(String prodDate) {
        StringBuffer str = new StringBuffer(prodDate);
        str.insert(6, "-");
        str.insert(4, "-");
        return String.valueOf(str);
    }

    /**
     * 根据条件找退货单退货单
     * @param auditSapEntityList
     * @return
     */
    private Map<String, AuditSapEntity> findByReturnMap(List<AuditSapEntity> auditSapEntityList) {
        Map<String, AuditSapEntity> returnMap = new HashMap<>();
        if (CollectionUtils.isEmpty(auditSapEntityList)) {
            return returnMap;
        }
        //物料编码
        List<String> materialCode = auditSapEntityList.stream().map(AuditSapEntity::getMaterialCode).distinct().collect(Collectors.toList());
        //往前1个月的时间分区到现在(当数据量大的时候缩小范围)
        String beginDate = DateUtil.format(DateUtil.getFirstDayOfLastMonth(),DateUtil.DEFAULT_YEAR_MONTH_DAY_NO_CH);
        String endDate = DateUtil.format(new Date(),DateUtil.DEFAULT_YEAR_MONTH_DAY_NO_CH);
        //获取退货单
        List<AuditSapEntity> returnOrder = this.auditSapRepository.findReturnOrderByMaterialCodeAndDate(materialCode, beginDate, endDate);
        if (CollectionUtils.isEmpty(returnOrder)){
            return returnMap;
        }
        Map<String, List<AuditSapEntity>> collect = returnOrder.stream().filter(vo -> StringUtils.isNotEmpty(vo.getOrderHeader())).collect(Collectors.groupingBy(vo -> StringUtils.joinWith("_", this.getOrderHeaderFirst(vo.getOrderHeader()), vo.getMaterialCode())));
        for (List<AuditSapEntity> value : collect.values()) {
            BigDecimal num = BigDecimal.ZERO;
            for (AuditSapEntity auditSapEntity : value) {
                num = num.add(new BigDecimal(auditSapEntity.getOrderNum1()));
            }
            AuditSapEntity auditSapEntity = value.get(0);
            String key = StringUtils.joinWith("_", this.getOrderHeaderFirst(auditSapEntity.getOrderHeader()), auditSapEntity.getMaterialCode());
            auditSapEntity.setOrderNum1(String.valueOf(num));
            returnMap.put(key, auditSapEntity);
        }
        return returnMap;
    }

    private String getOrderHeaderFirst(String param){
        String[] split = StringUtils.split(param,"/");
        return split[0];
    }
}
