package com.biz.crm.kms.business.audit.match.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.kms.business.audit.match.local.repository.AuditSapRepository;
import com.biz.crm.kms.business.audit.match.sdk.dto.AuditSapDto;
import com.biz.crm.kms.business.audit.match.sdk.dto.SurplusFeePoolBalanceAuditMatchDto;
import com.biz.crm.kms.business.audit.match.sdk.service.AuditSapVoService;
import com.biz.crm.kms.business.audit.match.sdk.vo.AuditSapVo;
import com.biz.crm.kms.business.audit.match.sdk.vo.SurplusFeePoolBalanceAuditMatchVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import jodd.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import com.biz.crm.kms.business.audit.match.local.entity.AuditSapEntity;
import com.biz.crm.kms.business.audit.match.sdk.constant.AuditMatchConstant;
import com.biz.crm.kms.business.audit.match.sdk.dto.AuditSapConditionDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

import java.util.*;

/**
 * @author cyj
 * @version 1.0
 * @date 2023/2/21 15:22
 * @description AuditSapVoServiceImpl
 */
@Service
public class AuditSapVoServiceImpl implements AuditSapVoService {

    @Autowired(required = false)
    private AuditSapRepository auditSapRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;


    @Override
    public Page<AuditSapVo> findAuditSapVoByConditions(Pageable pageable, AuditSapDto auditSapDto) {
        return this.auditSapRepository.findPageByConditions(pageable,auditSapDto);
    }

    @Override
    public List<AuditSapVo> findByCondition(AuditSapConditionDto dto) {
        if (ObjectUtils.isEmpty(dto)){
            return new ArrayList<>();
        }
        if (ObjectUtils.isEmpty(dto.getPageNum())){
            dto.setPageNum(0);
        }
        dto.setPageSize(AuditMatchConstant.KMS_AUDIT_SAP_LOOP_MAX);
        dto.setNum(dto.getPageNum() * dto.getPageSize());
        List<AuditSapEntity> byCondition = auditSapRepository.findByCondition(dto);
        return (List<AuditSapVo>) nebulaToolkitService.copyCollectionByWhiteList(byCondition,AuditSapEntity.class, AuditSapVo.class, HashSet.class, ArrayList.class);
    }

    /**
     * 折扣率变量剩余费用池余额 统计
     * @param dto 统计参数
     * @return List<SurplusFeePoolBalanceVo>
     */
    @Override
    public List<SurplusFeePoolBalanceAuditMatchVo> surplusFeePoolBalance(SurplusFeePoolBalanceAuditMatchDto dto) {
        if (StringUtil.isNotBlank(dto.getYearAndMonth()) || CollectionUtils.isEmpty(dto.getServiceCodeList())) {
            return new ArrayList<>();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        List<SurplusFeePoolBalanceAuditMatchVo> list = this.auditSapRepository.surplusFeePoolBalance(dto);
        if(CollectionUtils.isEmpty(list)){
            return new ArrayList<>();
        }
        return list;
    }
}
