package com.biz.crm.kms.business.audit.match.local.service.internal;


import com.biz.crm.kms.business.audit.match.local.entity.AuditTemplateSupermarket;
import com.biz.crm.kms.business.audit.match.local.repository.AuditTemplateSupermarketRepository;
import com.biz.crm.kms.business.audit.match.local.service.AuditTemplateSupermarketService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

/**
 * 稽查模板商超数据表(AuditTemplateSupermarket)表服务实现类
 *
 * @author songjingen
 * @since 2022-10-13 14:40:30
 */
@Service("auditTemplateSupermarketService")
public class AuditTemplateSupermarketServiceImpl implements AuditTemplateSupermarketService {

  @Autowired
  private AuditTemplateSupermarketRepository auditTemplateSupermarketRepository;


  @Transactional
  @Override
  public void createBatch(List<AuditTemplateSupermarket> templateSupermarkets) {
    Validate.isTrue(!CollectionUtils.isEmpty(templateSupermarkets), "保存商超数据时，未获取到数据！");
    templateSupermarkets.forEach(this::createValidate);
    this.auditTemplateSupermarketRepository.saveBatch(templateSupermarkets);
  }

  @Override
  @Transactional
  public void deleteByTemplateCodes(List<String> templateCodes) {
    Validate.isTrue(!CollectionUtils.isEmpty(templateCodes), "删除模板商超数据时，模板编码集合不能为空！");
    this.auditTemplateSupermarketRepository.deleteByTemplateCodes(templateCodes);
  }

  @Override
  public List<AuditTemplateSupermarket> findByTemplateCodes(List<String> templateCodes) {
    if (CollectionUtils.isEmpty(templateCodes)) {
      return new ArrayList<>(0);
    }
    return this.auditTemplateSupermarketRepository.findByTemplateCodes(templateCodes);
  }

  /**
   * 创建验证
   *
   * @param auditTemplateSupermarket
   */
  private void createValidate(AuditTemplateSupermarket auditTemplateSupermarket) {
    Validate.notNull(auditTemplateSupermarket, "新增时，对象信息不能为空！");
    auditTemplateSupermarket.setId(null);
    Validate.notNull(auditTemplateSupermarket.getDelayType(), "新增数据时，延迟时间容差类型不能为空！");
    Validate.notNull(auditTemplateSupermarket.getDelayDays(), "新增数据时，延迟时间容差不能为空！");
    Validate.notBlank(auditTemplateSupermarket.getPriceType(), "新增数据时，价格容差类型不能为空！");
    Validate.notNull(auditTemplateSupermarket.getPriceValue(), "新增数据时，价格容差值不能为空！");
    Validate.notBlank(auditTemplateSupermarket.getDirectCode(), "新增数据时，系统编码不能为空！");
    Validate.notBlank(auditTemplateSupermarket.getDirectName(), "新增数据时，系统名称不能为空！");
    Validate.notBlank(auditTemplateSupermarket.getTemplateCode(), "新增数据时，模板编码不能为空！");
  }
}

