package com.biz.crm.kms.business.audit.match.local.service.internal;

import com.biz.crm.kms.business.audit.match.local.entity.AuditTemplateSupermarket;
import com.biz.crm.kms.business.audit.match.local.repository.AuditTemplateSupermarketRepository;
import com.biz.crm.kms.business.audit.match.sdk.service.AuditTemplateSupermarketVoService;
import com.biz.crm.kms.business.audit.match.sdk.vo.AuditTemplateSupermarketVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/**
 * 稽核模板voService实现类
 *
 * @author songjingen
 * @date 2022/10/27 14:03
 */
@Service
public class AuditTemplateSupermarketVoServiceImpl implements AuditTemplateSupermarketVoService {

  @Autowired
  private AuditTemplateSupermarketRepository auditTemplateSupermarketRepository;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public List<AuditTemplateSupermarketVo> findByTemplateCode(List<String> templateCodes) {
    if (CollectionUtils.isEmpty(templateCodes)) {
      return new ArrayList<>(0);
    }
    List<AuditTemplateSupermarket> auditTemplateSupermarkets = this.auditTemplateSupermarketRepository.findByTemplateCodes(templateCodes);
    if (CollectionUtils.isEmpty(auditTemplateSupermarkets)) {
      return new ArrayList<>(0);
    }
    return (List<AuditTemplateSupermarketVo>) this.nebulaToolkitService.copyCollectionByWhiteList(auditTemplateSupermarkets, AuditTemplateSupermarket.class, AuditTemplateSupermarketVo.class,
        HashSet.class, ArrayList.class);
  }
}
