package com.biz.crm.kms.business.audit.match.local.service.internal;

import com.biz.crm.kms.business.audit.match.local.service.AuditMatchConsequenceService;
import com.biz.crm.kms.business.audit.match.local.service.AuditMatchService;
import com.biz.crm.kms.business.audit.match.local.service.AuditSapService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 稽核数据定时任务     job
 *
 * @author cyj
 * @version 1.0
 * @date 2023/1/10 16:00
 * @description AuditXxlJob
 */
@Slf4j
@Service
public class AuditXxlJob {

    @Autowired(required = false)
    private AuditSapService auditSapService;

    @Autowired(required = false)
    private AuditMatchService auditMatchService;

    @Autowired(required = false)
    private AuditMatchConsequenceService auditMatchConsequenceService;

    /**
     * 自动转换稽核数据定时任务
     */
    @DynamicTaskService(cornExpression = "0 0/30 * * * ?", taskDesc = "自动转换稽核数据定时任务")
    public void autoExtractSapData() {
        //TODO  需要改成  定时任务分片+redis锁
        auditSapService.autoExtractSapData();
    }

    /**
     * 自动稽核匹配定时任务
     */
    @DynamicTaskService(cornExpression = "0 0/30 * * * ?", taskDesc = "自动稽核匹配定时任务")
    public void autoAuditMatch() {
        //TODO  需要改成  定时任务分片+redis锁
        auditMatchService.autoAuditMatch();
    }

    /**
     * 自动稽核核定定时任务
     */
    @DynamicTaskService(cornExpression = "0 0/30 * * * ?", taskDesc = "自动稽核核定定时任务")
    public void autoAuditMatchConfirmStatus() {
        //TODO  需要改成  定时任务分片+redis锁
        auditMatchConsequenceService.autoAuditMatchConfirmStatus();
    }
}
