package com.biz.crm.kms.business.audit.match.local.service.internal;

import com.biz.crm.kms.business.audit.match.sdk.register.InvoiceMatchRegister;
import com.biz.crm.kms.business.audit.match.sdk.service.InvoiceMatchVoService;
import com.biz.crm.kms.business.audit.match.sdk.vo.InvoiceMatchVo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/**
 * 单据匹配voService实现类
 *
 * @author songjingen
 */
@Service
public class InvoiceMatchVoServiceImpl implements InvoiceMatchVoService {

  @Autowired(required = false)
  private List<InvoiceMatchRegister> invoiceMatchRegisters;

  @Override
  public List<InvoiceMatchVo> findAll() {
    if (CollectionUtils.isEmpty(this.invoiceMatchRegisters)) {
      return new ArrayList<>(0);
    }
    List<InvoiceMatchRegister> matchRegistersSortedOrder = this.invoiceMatchRegisters.stream().sorted(Comparator.comparing(InvoiceMatchRegister::order)).collect(Collectors.toList());
    List<InvoiceMatchVo> list = new ArrayList<>();
    for (InvoiceMatchRegister invoiceMatchRegister : matchRegistersSortedOrder) {
      InvoiceMatchVo invoiceMatchVo = new InvoiceMatchVo();
      invoiceMatchVo.setMatchLogicCode(invoiceMatchRegister.getMatchLogicCode());
      invoiceMatchVo.setMatchLogicDesc(invoiceMatchRegister.getMatchLogicDesc());
      invoiceMatchVo.setMatchInvoiceType(invoiceMatchRegister.getMatchInvoiceType());
      invoiceMatchVo.setMatchParams(invoiceMatchRegister.getMatchParams());
      list.add(invoiceMatchVo);
    }
    return list;
  }

  @Override
  public InvoiceMatchVo findByMatchLogicCode(String matchLogicCode) {
    if (StringUtils.isBlank(matchLogicCode)) {
      return null;
    }
    if (CollectionUtils.isEmpty(this.invoiceMatchRegisters)) {
      return null;
    }
    InvoiceMatchVo invoiceMatchVo = new InvoiceMatchVo();
    for (InvoiceMatchRegister invoiceMatchRegister : this.invoiceMatchRegisters) {
      if (invoiceMatchRegister.getMatchLogicCode().equals(matchLogicCode)) {
        invoiceMatchVo.setMatchLogicCode(invoiceMatchRegister.getMatchLogicCode());
        invoiceMatchVo.setMatchLogicDesc(invoiceMatchRegister.getMatchLogicDesc());
        invoiceMatchVo.setMatchInvoiceType(invoiceMatchRegister.getMatchInvoiceType());
        invoiceMatchVo.setMatchParams(invoiceMatchRegister.getMatchParams());
        break;
      }
    }
    return invoiceMatchVo;
  }
}
