package com.biz.crm.kms.business.audit.match.local.view;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * KMS稽核匹配数据视图
 *
 * @author 陈禹杰
 * @date 2022/10/26
 */
@Component
public class AuditMatchDataViewRegister implements DataviewRegister {

  @Override
  public String code() {
    return "kms_audit_match_data_view";
  }

  @Override
  public String desc() {
    return "KMS稽核匹配数据视图";
  }

  @Override
  public String buildSql() {
    return  "SELECT t.*," +
            "t1.amount_variance," +
            "t1.amount_variance_tax_exclusive," +
            "t1.confirm_status," +
            "t1.invoice_total_amount," +
            "t1.invoice_total_amount_tax_exclusive," +
            "t1.invoice_total_count," +
            "t1.match_consequence," +
            "t1.quantity_variance," +
            "t1.amount_variance_price," +
            "t1.invoice_price," +
            "t1.invoice_price_no_tax," +
            "t1.differ_type," +
            "DATE_FORMAT(t.sap_posting_date,'%Y-%m-%d') as 'post_date'," +
            "kd.sales_org_code," +
            "IF(t.match_status = '300','Y','N') as is_audit " +
            "FROM " +
            "kms_audit_match t " +
            "LEFT JOIN kms_direct kd on t.direct_code = kd.direct_code " +
            "LEFT JOIN kms_audit_match_consequence t1 on t1.audit_code = t.audit_code " +
            "WHERE t.tenant_code = :tenantCode " +
            "AND t.template_code = :templateCode ";
  }
}
