package com.biz.crm.kms.business.audit.match.local.view;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * KMS稽核模板数据视图注册器
 *
 * @author zhengbo
 * @date 2022/10/26
 */
@Component
public class AuditTemplateDataViewRegister implements DataviewRegister {

  @Override
  public String code() {
    return "kms_audit_template_data_view";
  }

  @Override
  public String desc() {
    return "KMS稽核模板数据视图";
  }

  @Override
  public String buildSql() {
//    return "select a.* from (SELECT kat.*,group_concat(kas.direct_code) direct_code,group_concat(CONCAT( kas.direct_code, '-', kas.supermarket_name )) " +
//            "direct_name FROM kms_audit_template kat " +
//            "LEFT JOIN kms_audit_template_supermarket kas ON kat.template_code = kas.template_code " +
//            "WHERE kat.tenant_code = :tenantCode " +
//            "AND kat.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' " +
//            "GROUP BY kat.id) a";

    return "SELECT kat.*,group_concat(kas.direct_code) direct_code,group_concat(CONCAT( kas.direct_code, '-', kas.supermarket_name )) " +
            "direct_name FROM kms_audit_template kat " +
            "LEFT JOIN kms_audit_template_supermarket kas ON kat.template_code = kas.template_code " +
            "WHERE kat.tenant_code = :tenantCode " +
            "AND kat.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' " +
            "GROUP BY kat.id";
  }
}
