package com.biz.crm.kms.business.audit.match.local.view;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * @author cyj
 * @version 1.0
 * @date 2023/1/4 14:47
 * @description KmsAuditSummaryDataViewRegister
 */
@Component
public class KmsAuditSummaryDataViewRegister implements DataviewRegister {

    @Override
    public String code() {
        return "kms_audit_summary_data_view";
    }

    @Override
    public String desc() {
        return "KMS稽核汇总数据视图";
    }

    @Override
    public String buildSql() {
        return "SELECT " +
                "id, " +
                "create_account, " +
                "create_name, " +
                "create_time, " +
                "modify_name, " +
                "modify_account, " +
                "modify_time, " +
                "acceptance_order_total, " +
                "CONCAT( acceptance_success_rate, '%' ) AS 'acceptance_success_rate', " +
                "grab_sap_total, " +
                "remark, " +
                "acceptance_total, " +
                "CONCAT( audit_differ_rate, '%' ) AS 'audit_differ_rate', " +
                "CONCAT( audit_success_rate, '%' ) AS 'audit_success_rate', " +
                "time_range_start, " +
                "time_range_end,  " +
                "differ_type, " +
                "direct_code, " +
                "direct_name, " +
                "match_failed_product, " +
                "match_failed_delivery, " +
                "sales_org_code, " +
                "sales_org_name, " +
                "sap_total, " +
                "sap_total_matched  " +
                "FROM " +
                "kms_audit_summary  " +
                "WHERE tenant_code = :tenantCode " +
                "AND template_code = :templateCode " +
                "AND del_flag = '"+ DelFlagStatusEnum.NORMAL.getCode() + "' ";
    }
}
