package com.biz.crm.kms.business.audit.match.rule.abstracts;

import com.biz.crm.kms.business.audit.match.local.entity.AuditMatchInvoice;
import com.biz.crm.kms.business.audit.match.local.entity.AuditTemplate;
import com.biz.crm.kms.business.audit.match.local.model.AuditMatchInvoiceModel;
import com.biz.crm.kms.business.audit.match.local.model.MatchConsequenceCalculatedAbstract;
import com.biz.crm.kms.business.audit.match.local.model.MatchConsequenceCalculatedModel;
import com.biz.crm.kms.business.audit.match.local.repository.AuditMatchInvoiceRepository;
import com.biz.crm.kms.business.audit.match.sdk.constant.AuditMatchConstant;
import com.biz.crm.kms.business.invoice.sdk.service.InvoiceStatisticsVoService;
import com.biz.crm.kms.business.invoice.sdk.vo.InvoiceStatisticsVo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/**
 * 出货数据(第三方稽核匹配数据)=验收单+退货单 计算逻辑策略实现
 *
 * @author songjingen
 * @date 2022/10/28 9:45
 */
@Component
public class AcceptanceAddReturnEqualToShipmentCalculatedAbstract extends MatchConsequenceCalculatedAbstract {

  @Autowired(required = false)
  private InvoiceStatisticsVoService invoiceStatisticsVoService;
  @Autowired(required = false)
  private AuditMatchInvoiceRepository auditMatchInvoiceRepository;


  @Override
  public void execute(String templateCode, List<MatchConsequenceCalculatedModel> calculatedModels) {
    Validate.isTrue(!CollectionUtils.isEmpty(calculatedModels), "执行匹配计算逻辑时，需要匹配的数据不存在！");
    //1、查询单据统计
    List<Date> invoiceDates = calculatedModels.stream().map(MatchConsequenceCalculatedModel::getSapPostingDate).collect(Collectors.toList());
    List<String> goodsCodes = calculatedModels.stream().map(MatchConsequenceCalculatedModel::getSapMaterialCode).collect(Collectors.toList());
    List<String> storeCodes = calculatedModels.stream().map(MatchConsequenceCalculatedModel::getDeliveryCode).collect(Collectors.toList());
    //1.1、查询验收单数据和退货单的数据，合并成一个list，并且按照匹配条件转成map
    List<InvoiceStatisticsVo> acceptanceStatisticsVos = this.invoiceStatisticsVoService.findByType(AuditMatchConstant.ACCEPTANCE, invoiceDates, goodsCodes, storeCodes, null);
    Validate.isTrue(!CollectionUtils.isEmpty(acceptanceStatisticsVos), "执行匹配计算逻辑时，未匹配到验收单！");
    List<InvoiceStatisticsVo> returnStatisticsVos = this.invoiceStatisticsVoService.findByType(AuditMatchConstant.RETURN, invoiceDates, goodsCodes, storeCodes, null);
    Validate.isTrue(!CollectionUtils.isEmpty(returnStatisticsVos), "执行匹配计算逻辑时，未匹配到退货单！");
    acceptanceStatisticsVos.addAll(returnStatisticsVos);
    Map<String, List<InvoiceStatisticsVo>> invoiceStatisticsVoMap = acceptanceStatisticsVos.stream()
        .collect(Collectors.groupingBy(o -> StringUtils.joinWith("", o.getStoreCode(), o.getGoodsCode(), o.getKaOrderNumber())));
    //1.2、查询单据已匹配的稽核数据，并且根据单据类型和单据编码转成map
    List<String> invoiceCodes = acceptanceStatisticsVos.stream().map(InvoiceStatisticsVo::getInvoiceCode).collect(Collectors.toList());
    List<AuditMatchInvoice> auditMatchInvoices = this.auditMatchInvoiceRepository.findByTemplateCodeAndInvoiceTypesAndInvoiceCodes(templateCode,
        Lists.newArrayList(AuditMatchConstant.ACCEPTANCE, AuditMatchConstant.RETURN), invoiceCodes);
    Map<String, String> auditCodeMapByInvoiceMap = new HashMap<>();
    if (!CollectionUtils.isEmpty(auditMatchInvoices)) {
      auditCodeMapByInvoiceMap = auditMatchInvoices.stream()
          .collect(Collectors.toMap(o -> StringUtils.joinWith("", o.getInvoiceCode(), o.getInvoiceType()), AuditMatchInvoice::getAuditCode, (a, b) -> a));
    }
    //2、赋值
    ArrayList<AuditMatchInvoiceModel> invoiceModels = new ArrayList<>();
    for (MatchConsequenceCalculatedModel calculatedModel : calculatedModels) {
      BigDecimal invoiceTotalCount = BigDecimal.ZERO;
      BigDecimal invoiceTotalAmount = BigDecimal.ZERO;
      BigDecimal invoiceTotalAmountTaxExclusive = BigDecimal.ZERO;
      String mapKey = StringUtils.joinWith("", calculatedModel.getDeliveryCode(), calculatedModel.getSapMaterialCode(), calculatedModel.getRelationOrderCode());
      List<InvoiceStatisticsVo> invoiceStatisticsVos = invoiceStatisticsVoMap.get(mapKey);
      if (CollectionUtils.isEmpty(invoiceStatisticsVos)) {
        continue;
      }
      for (InvoiceStatisticsVo statisticsVo : invoiceStatisticsVos) {
        //如果当前单据已经匹配了数据并且和当前稽核编码不匹配，则跳过统计
        String key = StringUtils.joinWith("", statisticsVo.getInvoiceCode(), statisticsVo.getInvoiceType());
        String auditCode = auditCodeMapByInvoiceMap.get(key);
        if (StringUtils.isNotBlank(auditCode) && !auditCode.equals(calculatedModel.getAuditCode())) {
          continue;
        }
        invoiceTotalCount = invoiceTotalCount.add(statisticsVo.getInvoiceCount());
        invoiceTotalAmount = invoiceTotalAmount.add(statisticsVo.getInvoiceAmount());
        invoiceTotalAmountTaxExclusive = invoiceTotalAmountTaxExclusive.add(statisticsVo.getInvoiceAmountTaxExclusive());
        //将已使用的单据匹配到稽核数据上
        auditCodeMapByInvoiceMap.put(key, calculatedModel.getAuditCode());
        //绑定单据
        AuditMatchInvoiceModel invoiceModel = new AuditMatchInvoiceModel();
        invoiceModel.setInvoiceCode(statisticsVo.getInvoiceCode());
        invoiceModel.setInvoiceType(statisticsVo.getInvoiceType());
        invoiceModel.setTemplateCode(templateCode);
        invoiceModel.setAuditCode(calculatedModel.getAuditCode());
        invoiceModels.add(invoiceModel);
      }
      calculatedModel.setInvoiceTotalCount(invoiceTotalCount);
      calculatedModel.setInvoiceTotalAmount(invoiceTotalAmount);
      calculatedModel.setInvoiceTotalAmountTaxExclusive(invoiceTotalAmountTaxExclusive);
      calculatedModel.setAuditMatchInvoiceModels(invoiceModels);
    }
    //3、执行计算
    this.calculate(calculatedModels,null);
  }

  @Override
  public void executeAuto(AuditTemplate auditTemplate, List<MatchConsequenceCalculatedModel> models) {

  }

  @Override
  public void notAutoExecute(String templateCode, MatchConsequenceCalculatedModel model, List<AuditMatchInvoice> auditMatchInvoices) {
    // TODO: 2022/12/17 手动匹配逻辑 
  }
}
