package com.biz.crm.kms.business.audit.match.rule.register;

import com.biz.crm.kms.business.audit.match.rule.abstracts.AcceptanceEqualToShipmentCalculatedAbstract;
import com.biz.crm.kms.business.audit.match.sdk.enums.MatchParamsEnum;
import com.biz.crm.kms.business.audit.match.sdk.register.InvoiceMatchRegister;
import com.biz.crm.kms.business.invoice.sdk.register.InvoiceTypeRegister;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

/**
 * 出库单(第三方稽核匹配数据)=验收单 匹配注册器
 *
 * @author songjingen
 */
@Component
public class AcceptanceEqualToShipmentMatchRegister implements InvoiceMatchRegister {

  @Autowired(required = false)
  @Qualifier("acceptanceInvoiceTypeRegister")
  private InvoiceTypeRegister acceptanceInvoiceTypeRegister;

  @Override
  public String getMatchLogicCode() {
    return AcceptanceEqualToShipmentMatchRegister.class.getSimpleName();
  }

  @Override
  public String getMatchLogicDesc() {
    return "出库单=验收单";
  }

  @Override
  public Map<String, String> getMatchInvoiceType() {
    Map<String, String> map = new HashMap<>();
    map.put(this.acceptanceInvoiceTypeRegister.type(), this.acceptanceInvoiceTypeRegister.name());
    return map;
  }

  @Override
  public Map<String, String> getMatchParams() {
    Map<String, String> map = new HashMap<>();
    map.put(MatchParamsEnum.PRODUCT.getDictCode(), MatchParamsEnum.PRODUCT.getValue());
    map.put(MatchParamsEnum.STORE.getDictCode(), MatchParamsEnum.STORE.getValue());
    map.put(MatchParamsEnum.ORDER.getDictCode(), MatchParamsEnum.ORDER.getValue());
    map.put(MatchParamsEnum.DATE.getDictCode(), MatchParamsEnum.DATE.getValue());
    map.put(MatchParamsEnum.SOLDTOPARTY.getDictCode(), MatchParamsEnum.SOLDTOPARTY.getValue());
    return map;
  }

  @Override
  public Class<?> getMatchLogicCalculatedAbstract() {
    return AcceptanceEqualToShipmentCalculatedAbstract.class;
  }

  @Override
  public Integer order() {
    return 1;
  }
}
