/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.audit.match.rule.abstracts;

import com.biz.crm.kms.business.audit.match.local.entity.AuditMatchInvoice;
import com.biz.crm.kms.business.audit.match.local.entity.AuditTemplate;
import com.biz.crm.kms.business.audit.match.local.model.AuditMatchInvoiceModel;
import com.biz.crm.kms.business.audit.match.local.model.MatchConsequenceCalculatedAbstract;
import com.biz.crm.kms.business.audit.match.local.model.MatchConsequenceCalculatedModel;
import com.biz.crm.kms.business.audit.match.local.model.MatchParamModel;
import com.biz.crm.kms.business.audit.match.local.repository.AuditMatchInvoiceRepository;
import com.biz.crm.kms.business.invoice.sdk.service.InvoiceStatisticsVoService;
import com.biz.crm.kms.business.invoice.sdk.vo.InvoiceStatisticsVo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AcceptanceAddReturnEqualToStatementEqualToShipmentCalculatedAbstract
extends MatchConsequenceCalculatedAbstract {
    @Autowired(required=false)
    private InvoiceStatisticsVoService invoiceStatisticsVoService;
    @Autowired(required=false)
    private AuditMatchInvoiceRepository auditMatchInvoiceRepository;

    public void execute(String templateCode, List<MatchConsequenceCalculatedModel> calculatedModels) {
        Validate.notNull((Object)templateCode, (String)"\u6267\u884c\u5339\u914d\u8ba1\u7b97\u903b\u8f91\u65f6\uff0c\u6a21\u677f\u7f16\u7801\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(calculatedModels) ? 1 : 0) != 0, (String)"\u6267\u884c\u5339\u914d\u8ba1\u7b97\u903b\u8f91\u65f6\uff0c\u9700\u8981\u5339\u914d\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        List relationOrderCodes = calculatedModels.stream().map(MatchParamModel::getRelationOrderCode).collect(Collectors.toList());
        List goodsCodes = calculatedModels.stream().map(MatchParamModel::getSapMaterialCode).collect(Collectors.toList());
        List storeCodes = calculatedModels.stream().map(MatchParamModel::getDeliveryCode).collect(Collectors.toList());
        List acceptanceStatisticsVos = this.invoiceStatisticsVoService.findByType("acceptance", null, goodsCodes, storeCodes, relationOrderCodes, new List[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)acceptanceStatisticsVos) ? 1 : 0) != 0, (String)"\u6267\u884c\u5339\u914d\u8ba1\u7b97\u903b\u8f91\u65f6\uff0c\u672a\u5339\u914d\u5230\u9a8c\u6536\u5355\uff01", (Object[])new Object[0]);
        List returnStatisticsVos = this.invoiceStatisticsVoService.findByType("return", null, goodsCodes, storeCodes, relationOrderCodes, new List[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)returnStatisticsVos) ? 1 : 0) != 0, (String)"\u6267\u884c\u5339\u914d\u8ba1\u7b97\u903b\u8f91\u65f6\uff0c\u672a\u5339\u914d\u5230\u9000\u8d27\u5355\uff01", (Object[])new Object[0]);
        acceptanceStatisticsVos.addAll(returnStatisticsVos);
        Map<String, List<InvoiceStatisticsVo>> invoiceStatisticsVoMap = acceptanceStatisticsVos.stream().collect(Collectors.groupingBy(o -> StringUtils.joinWith((String)"", (Object[])new Object[]{o.getStoreCode(), o.getGoodsCode(), o.getKaOrderNumber()})));
        List invoiceCodes = acceptanceStatisticsVos.stream().map(InvoiceStatisticsVo::getInvoiceCode).collect(Collectors.toList());
        List auditMatchInvoices = this.auditMatchInvoiceRepository.findByTemplateCodeAndInvoiceTypesAndInvoiceCodes(templateCode, (List)Lists.newArrayList((Object[])new String[]{"acceptance", "return"}), invoiceCodes);
        Map<Object, Object> auditCodeMapByInvoiceMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)auditMatchInvoices)) {
            auditCodeMapByInvoiceMap = auditMatchInvoices.stream().collect(Collectors.toMap(o -> StringUtils.joinWith((String)"", (Object[])new Object[]{o.getInvoiceCode(), o.getInvoiceType()}), AuditMatchInvoice::getAuditCode, (a, b) -> a));
        }
        ArrayList<AuditMatchInvoiceModel> invoiceModels = new ArrayList<AuditMatchInvoiceModel>();
        for (MatchConsequenceCalculatedModel calculatedModel : calculatedModels) {
            BigDecimal invoiceTotalCount = BigDecimal.ZERO;
            BigDecimal invoiceTotalAmount = BigDecimal.ZERO;
            BigDecimal invoiceTotalAmountTaxExclusive = BigDecimal.ZERO;
            String mapKey = StringUtils.joinWith((String)"", (Object[])new Object[]{calculatedModel.getDeliveryCode(), calculatedModel.getSapMaterialCode(), calculatedModel.getRelationOrderCode()});
            List<InvoiceStatisticsVo> invoiceStatisticsVos = invoiceStatisticsVoMap.get(mapKey);
            if (CollectionUtils.isEmpty(invoiceStatisticsVos)) continue;
            for (InvoiceStatisticsVo statisticsVo : invoiceStatisticsVos) {
                String key = StringUtils.joinWith((String)"", (Object[])new Object[]{statisticsVo.getInvoiceCode(), statisticsVo.getInvoiceType()});
                String auditCode = (String)auditCodeMapByInvoiceMap.get(key);
                if (StringUtils.isNotBlank((CharSequence)auditCode) && !auditCode.equals(calculatedModel.getAuditCode())) continue;
                invoiceTotalCount = invoiceTotalCount.add(statisticsVo.getInvoiceCount());
                invoiceTotalAmount = invoiceTotalAmount.add(statisticsVo.getInvoiceAmount());
                invoiceTotalAmountTaxExclusive = invoiceTotalAmountTaxExclusive.add(statisticsVo.getInvoiceAmountTaxExclusive());
                auditCodeMapByInvoiceMap.put(key, calculatedModel.getAuditCode());
                AuditMatchInvoiceModel invoiceModel = new AuditMatchInvoiceModel();
                invoiceModel.setInvoiceCode(statisticsVo.getInvoiceCode());
                invoiceModel.setInvoiceType(statisticsVo.getInvoiceType());
                invoiceModel.setTemplateCode(templateCode);
                invoiceModel.setAuditCode(calculatedModel.getAuditCode());
                invoiceModels.add(invoiceModel);
            }
            calculatedModel.setInvoiceTotalCount(invoiceTotalCount);
            calculatedModel.setInvoiceTotalAmount(invoiceTotalAmount);
            calculatedModel.setInvoiceTotalAmountTaxExclusive(invoiceTotalAmountTaxExclusive);
            calculatedModel.setAuditMatchInvoiceModels(invoiceModels);
        }
        this.calculate(calculatedModels, null);
    }

    public void executeAuto(AuditTemplate auditTemplate, List<MatchConsequenceCalculatedModel> models) {
    }

    public void notAutoExecute(String templateCode, MatchConsequenceCalculatedModel model, List<AuditMatchInvoice> auditMatchInvoices) {
    }
}

