/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.audit.match.rule.abstracts;

import cn.hutool.core.date.DateUtil;
import com.biz.crm.kms.business.audit.match.local.entity.AuditMatchCrossAcceptance;
import com.biz.crm.kms.business.audit.match.local.entity.AuditMatchInvoice;
import com.biz.crm.kms.business.audit.match.local.entity.AuditTemplate;
import com.biz.crm.kms.business.audit.match.local.entity.AuditTemplateSupermarket;
import com.biz.crm.kms.business.audit.match.local.entity.MatchInvoiceManuEntity;
import com.biz.crm.kms.business.audit.match.local.model.AuditMatchInvoiceModel;
import com.biz.crm.kms.business.audit.match.local.model.MatchConsequenceCalculatedAbstract;
import com.biz.crm.kms.business.audit.match.local.model.MatchConsequenceCalculatedModel;
import com.biz.crm.kms.business.audit.match.local.model.MatchParamModel;
import com.biz.crm.kms.business.audit.match.local.repository.AuditMatchCrossAcceptanceRepository;
import com.biz.crm.kms.business.audit.match.local.repository.AuditMatchInvoiceRepository;
import com.biz.crm.kms.business.audit.match.local.repository.MatchInvoiceManuRepository;
import com.biz.crm.kms.business.audit.match.local.service.AuditMatchService;
import com.biz.crm.kms.business.audit.match.sdk.dto.AuditMatchNotReasonDto;
import com.biz.crm.kms.business.audit.match.sdk.enums.AuditMatchCrossExceptionEnum;
import com.biz.crm.kms.business.audit.match.sdk.enums.AuditMatchCrossTypeEnum;
import com.biz.crm.kms.business.audit.match.sdk.enums.MatchParamsEnum;
import com.biz.crm.kms.business.audit.match.sdk.enums.PriceTypeEnum;
import com.biz.crm.kms.business.invoice.acceptance.sdk.enums.AcceptanceStatus;
import com.biz.crm.kms.business.invoice.sdk.service.InvoiceStatisticsVoService;
import com.biz.crm.kms.business.invoice.sdk.vo.InvoiceStatisticsVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class AcceptanceEqualToShipmentCalculatedAbstract
extends MatchConsequenceCalculatedAbstract {
    private static final Logger log = LoggerFactory.getLogger(AcceptanceEqualToShipmentCalculatedAbstract.class);
    @Autowired(required=false)
    private InvoiceStatisticsVoService invoiceStatisticsVoService;
    @Autowired(required=false)
    private AuditMatchInvoiceRepository auditMatchInvoiceRepository;
    @Autowired(required=false)
    private MatchInvoiceManuRepository matchInvoiceManuRepository;
    @Autowired(required=false)
    private AuditMatchService auditMatchService;
    @Autowired(required=false)
    private AuditMatchCrossAcceptanceRepository auditMatchCrossAcceptanceRepository;

    @Transactional(rollbackFor={Exception.class})
    public void execute(String templateCode, List<MatchConsequenceCalculatedModel> calculatedModels) {
        Validate.isTrue((!CollectionUtils.isEmpty(calculatedModels) ? 1 : 0) != 0, (String)"\u6267\u884c\u5339\u914d\u8ba1\u7b97\u903b\u8f91\u65f6\uff0c\u9700\u8981\u5339\u914d\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        List invoiceDates = calculatedModels.stream().map(MatchParamModel::getSapPostingDate).collect(Collectors.toList());
        List goodsCodes = calculatedModels.stream().map(MatchParamModel::getSapMaterialCode).collect(Collectors.toList());
        List storeCodes = calculatedModels.stream().map(MatchParamModel::getDeliveryCode).collect(Collectors.toList());
        List invoiceStatisticsVos = this.invoiceStatisticsVoService.findByType("acceptance", invoiceDates, goodsCodes, storeCodes, null, new List[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)invoiceStatisticsVos) ? 1 : 0) != 0, (String)"\u6267\u884c\u5339\u914d\u8ba1\u7b97\u903b\u8f91\u65f6\uff0c\u672a\u5339\u914d\u5230\u9a8c\u6536\u5355\uff01", (Object[])new Object[0]);
        Map<String, List<InvoiceStatisticsVo>> groupMap = invoiceStatisticsVos.stream().collect(Collectors.groupingBy(o -> StringUtils.joinWith((String)"", (Object[])new Object[]{o.getStoreCode(), o.getGoodsCode(), DateUtil.format((Date)o.getInvoiceDate(), (String)"yyyy-MM-dd")})));
        List invoiceCodes = invoiceStatisticsVos.stream().map(InvoiceStatisticsVo::getInvoiceCode).collect(Collectors.toList());
        List auditMatchInvoices = this.auditMatchInvoiceRepository.findByTemplateCodeAndInvoiceTypesAndInvoiceCodes(templateCode, (List)Lists.newArrayList((Object[])new String[]{"acceptance", "return"}), invoiceCodes);
        Map<Object, Object> auditCodeMapByInvoiceMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)auditMatchInvoices)) {
            auditCodeMapByInvoiceMap = auditMatchInvoices.stream().collect(Collectors.toMap(o -> StringUtils.joinWith((String)"", (Object[])new Object[]{o.getInvoiceCode(), o.getInvoiceType()}), AuditMatchInvoice::getAuditCode, (a, b) -> a));
        }
        ArrayList<AuditMatchInvoiceModel> invoiceModels = new ArrayList<AuditMatchInvoiceModel>();
        for (MatchConsequenceCalculatedModel calculatedModel : calculatedModels) {
            BigDecimal invoiceTotalCount = BigDecimal.ZERO;
            BigDecimal invoiceTotalAmount = BigDecimal.ZERO;
            BigDecimal invoiceTotalAmountTaxExclusive = BigDecimal.ZERO;
            String mapKey = StringUtils.joinWith((String)"", (Object[])new Object[]{calculatedModel.getDeliveryCode(), calculatedModel.getSapMaterialCode(), DateUtil.format((Date)calculatedModel.getSapPostingDate(), (String)"yyyy-MM-dd")});
            List<InvoiceStatisticsVo> statisticsVos = groupMap.get(mapKey);
            if (CollectionUtils.isEmpty(statisticsVos)) continue;
            for (InvoiceStatisticsVo statisticsVo : statisticsVos) {
                String key = StringUtils.joinWith((String)"", (Object[])new Object[]{statisticsVo.getInvoiceCode(), statisticsVo.getInvoiceType()});
                String auditCode = (String)auditCodeMapByInvoiceMap.get(key);
                if (StringUtils.isNotBlank((CharSequence)auditCode) && !auditCode.equals(calculatedModel.getAuditCode())) continue;
                invoiceTotalCount = invoiceTotalCount.add(statisticsVo.getInvoiceCount());
                invoiceTotalAmount = invoiceTotalAmount.add(statisticsVo.getInvoiceAmount());
                invoiceTotalAmountTaxExclusive = invoiceTotalAmountTaxExclusive.add(statisticsVo.getInvoiceAmountTaxExclusive());
                auditCodeMapByInvoiceMap.put(key, calculatedModel.getAuditCode());
                AuditMatchInvoiceModel invoiceModel = new AuditMatchInvoiceModel();
                invoiceModel.setInvoiceCode(statisticsVo.getInvoiceCode());
                invoiceModel.setInvoiceType(statisticsVo.getInvoiceType());
                invoiceModel.setTemplateCode(templateCode);
                invoiceModel.setAuditCode(calculatedModel.getAuditCode());
                invoiceModels.add(invoiceModel);
            }
            calculatedModel.setInvoiceTotalCount(invoiceTotalCount);
            calculatedModel.setInvoiceTotalAmount(invoiceTotalAmount);
            calculatedModel.setInvoiceTotalAmountTaxExclusive(invoiceTotalAmountTaxExclusive);
            calculatedModel.setAuditMatchInvoiceModels(invoiceModels);
        }
        this.calculate(calculatedModels, null);
    }

    /*
     * WARNING - void declaration
     */
    public void executeAuto(AuditTemplate auditTemplate, List<MatchConsequenceCalculatedModel> models) {
        List directCodes;
        List invoiceStatisticsVos;
        List successInvoiceStatisticsVos;
        List soldCodes;
        List relationOrderCodes;
        List deliveryCodes;
        List goodsCodes;
        if (CollectionUtils.isEmpty(models)) {
            log.error("\u6267\u884c\u5339\u914d\u8ba1\u7b97\u903b\u8f91\u65f6\uff0c\u9700\u8981\u5339\u914d\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff01");
            return;
        }
        ArrayList<MatchConsequenceCalculatedModel> modelList = new ArrayList<MatchConsequenceCalculatedModel>();
        List templateSupermarkets = auditTemplate.getTemplateSupermarkets();
        if (CollectionUtils.isEmpty((Collection)templateSupermarkets)) {
            log.error("\u672a\u80fd\u6839\u636e[%s]\u6a21\u677f\u4fe1\u606f\u67e5\u8be2\u5230\u5546\u8d85\u6a21\u677f!", (Object)auditTemplate.getTemplateCode());
            return;
        }
        Map<String, AuditTemplateSupermarket> auditTemplateSupermarketMap = templateSupermarkets.stream().collect(Collectors.toMap(AuditTemplateSupermarket::getDirectCode, Function.identity()));
        ArrayList productCodes = Lists.newArrayList();
        ArrayList storeCodes = Lists.newArrayList();
        ArrayList orderCodes = Lists.newArrayList();
        ArrayList soldToPartyCodes = Lists.newArrayList();
        List params = Arrays.stream(auditTemplate.getMatchParams().split(",")).collect(Collectors.toList());
        String maxAcceptanceDate = null;
        String minAcceptanceDate = null;
        if (params.contains(MatchParamsEnum.PRODUCT.getDictCode()) && !CollectionUtils.isEmpty(goodsCodes = models.stream().map(MatchParamModel::getSapMaterialCode).distinct().collect(Collectors.toList()))) {
            productCodes.addAll(goodsCodes);
        }
        if (params.contains(MatchParamsEnum.STORE.getDictCode()) && !CollectionUtils.isEmpty(deliveryCodes = models.stream().map(MatchParamModel::getDeliveryCode).distinct().collect(Collectors.toList()))) {
            storeCodes.addAll(deliveryCodes);
        }
        if (params.contains(MatchParamsEnum.ORDER.getDictCode()) && !CollectionUtils.isEmpty(relationOrderCodes = models.stream().map(MatchParamModel::getRelationOrderCode).distinct().collect(Collectors.toList()))) {
            orderCodes.addAll(relationOrderCodes);
        }
        if (params.contains(MatchParamsEnum.DATE.getDictCode())) {
            Date maxDate = models.stream().max(Comparator.comparing(MatchParamModel::getSapPostingDate)).get().getSapPostingDate();
            Date minDate = models.stream().min(Comparator.comparing(MatchParamModel::getSapPostingDate)).get().getSapPostingDate();
            Integer delayDay = templateSupermarkets.stream().filter(entity -> entity.getDelayDays() != null).max(Comparator.comparing(AuditTemplateSupermarket::getDelayDays)).get().getDelayDays();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(maxDate);
            calendar.add(5, delayDay);
            maxAcceptanceDate = DateUtil.format((Date)calendar.getTime(), (String)"yyyy-MM-dd");
            calendar.setTime(minDate);
            calendar.add(5, -1 * delayDay);
            minAcceptanceDate = DateUtil.format((Date)calendar.getTime(), (String)"yyyy-MM-dd");
        }
        if (params.contains(MatchParamsEnum.SOLDTOPARTY.getDictCode()) && !CollectionUtils.isEmpty(soldCodes = models.stream().map(MatchParamModel::getSoldToPartyCode).distinct().collect(Collectors.toList()))) {
            soldToPartyCodes.addAll(soldCodes);
        }
        if (CollectionUtils.isEmpty(successInvoiceStatisticsVos = (invoiceStatisticsVos = this.invoiceStatisticsVoService.findByConditions("acceptance", (List)productCodes, (List)storeCodes, (List)orderCodes, minAcceptanceDate, maxAcceptanceDate, (List)soldToPartyCodes, directCodes = templateSupermarkets.stream().map(AuditTemplateSupermarket::getDirectCode).collect(Collectors.toList()))).stream().filter(vo -> StringUtils.equals((CharSequence)AcceptanceStatus.S200.getDictCode(), (CharSequence)vo.getOrderStatus())).collect(Collectors.toList()))) {
            if (params.contains(MatchParamsEnum.ORDER.getDictCode())) {
                log.info("\u672a\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5230\u9a8c\u6536\u5355,\u8be5\u6b21\u5339\u914d\u9000\u51fa!");
                this.updateNotReason(models, invoiceStatisticsVos);
                return;
            }
            log.info("\u672a\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5230\u9a8c\u6536\u5355,\u8be5\u6b21\u5339\u914d\u9000\u51fa!");
            return;
        }
        successInvoiceStatisticsVos = params.contains(MatchParamsEnum.ORDER.getDictCode()) ? successInvoiceStatisticsVos.stream().filter(vo -> StringUtils.isNotEmpty((CharSequence)vo.getOrderCode())).collect(Collectors.toList()) : successInvoiceStatisticsVos.stream().filter(vo -> StringUtils.isEmpty((CharSequence)vo.getOrderCode())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(successInvoiceStatisticsVos)) {
            log.info("\u672a\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5230\u8f6c\u6362\u6210\u529f\u7684\u9a8c\u6536\u5355,\u8be5\u6b21\u5339\u914d\u9000\u51fa!");
            this.updateNotReason(models, invoiceStatisticsVos);
            return;
        }
        Map<Object, Object> acceptanceMap = new HashMap();
        if (CollectionUtils.isEmpty((Collection)storeCodes) && CollectionUtils.isEmpty((Collection)orderCodes)) {
            return;
        }
        if (params.size() == 4 && CollectionUtils.isEmpty((Collection)orderCodes)) {
            acceptanceMap = successInvoiceStatisticsVos.stream().collect(Collectors.groupingBy(vo -> StringUtils.joinWith((String)"_", (Object[])new Object[]{vo.getGoodsCode(), vo.getStoreCode(), vo.getSoldToPartyCode()})));
        }
        if (params.size() == 4 && CollectionUtils.isEmpty((Collection)storeCodes)) {
            acceptanceMap = successInvoiceStatisticsVos.stream().collect(Collectors.groupingBy(vo -> StringUtils.joinWith((String)"_", (Object[])new Object[]{vo.getGoodsCode(), vo.getOrderCode(), vo.getSoldToPartyCode()})));
        }
        if (params.size() == 5) {
            acceptanceMap = successInvoiceStatisticsVos.stream().collect(Collectors.groupingBy(vo -> StringUtils.joinWith((String)"_", (Object[])new Object[]{vo.getGoodsCode(), vo.getStoreCode(), vo.getOrderCode(), vo.getSoldToPartyCode()})));
        }
        if (MapUtils.isEmpty(acceptanceMap)) {
            return;
        }
        for (MatchConsequenceCalculatedModel model : models) {
            AuditMatchInvoiceModel invoiceModel;
            BigDecimal invoiceTotalAmountTaxExclusive;
            BigDecimal invoiceTotalAmount;
            BigDecimal invoiceTotalCount;
            ArrayList<InvoiceStatisticsVo> matchInvoices;
            ArrayList<AuditMatchInvoiceModel> invoiceModels;
            block85: {
                List invoiceStatisticsList;
                block84: {
                    invoiceModels = new ArrayList<AuditMatchInvoiceModel>();
                    String mapKey = null;
                    if (params.size() == 4 && CollectionUtils.isEmpty((Collection)orderCodes)) {
                        mapKey = StringUtils.joinWith((String)"_", (Object[])new Object[]{model.getSapMaterialCode(), model.getDeliveryCode(), model.getSoldToPartyCode()});
                    }
                    if (params.size() == 4 && CollectionUtils.isEmpty((Collection)storeCodes)) {
                        mapKey = StringUtils.joinWith((String)"_", (Object[])new Object[]{model.getSapMaterialCode(), model.getRelationOrderCode(), model.getSoldToPartyCode()});
                    }
                    if (params.size() == 5) {
                        mapKey = StringUtils.joinWith((String)"_", (Object[])new Object[]{model.getSapMaterialCode(), model.getDeliveryCode(), model.getRelationOrderCode(), model.getSoldToPartyCode()});
                    }
                    if (CollectionUtils.isEmpty((Collection)(invoiceStatisticsList = (List)acceptanceMap.get(mapKey)))) {
                        modelList.add(model);
                        continue;
                    }
                    AuditTemplateSupermarket auditTemplateSupermarket = (AuditTemplateSupermarket)auditTemplateSupermarketMap.get(model.getDirectCode());
                    if (auditTemplateSupermarket == null) continue;
                    model.setPriceValue(auditTemplateSupermarket.getPriceValue());
                    model.setPriceType(auditTemplateSupermarket.getPriceType());
                    matchInvoices = new ArrayList<InvoiceStatisticsVo>();
                    invoiceTotalCount = BigDecimal.ZERO;
                    invoiceTotalAmount = BigDecimal.ZERO;
                    invoiceTotalAmountTaxExclusive = BigDecimal.ZERO;
                    if (!params.contains(MatchParamsEnum.DATE.getDictCode())) break block84;
                    if (!StringUtils.isNotEmpty((CharSequence)auditTemplateSupermarket.getDelayType())) break block85;
                    Iterator delayDays = auditTemplateSupermarket.getDelayDays();
                    Object var28_29 = null;
                    String endDate = null;
                    String posDate = DateUtil.format((Date)model.getSapPostingDate(), (String)"yyyy-MM-dd");
                    Calendar calendar = Calendar.getInstance();
                    switch (PriceTypeEnum.getByDictCode((String)auditTemplateSupermarket.getDelayType())) {
                        case Z: {
                            String invoiceDate;
                            calendar.setTime(model.getSapPostingDate());
                            calendar.add(5, (Integer)((Object)delayDays));
                            endDate = DateUtil.format((Date)calendar.getTime(), (String)"yyyy-MM-dd");
                            for (InvoiceStatisticsVo invoiceStatisticsVo : invoiceStatisticsList) {
                                invoiceDate = DateUtil.format((Date)invoiceStatisticsVo.getInvoiceDate(), (String)"yyyy-MM-dd");
                                if (invoiceDate == null || invoiceDate.compareTo(posDate) < 0 || invoiceDate.compareTo(endDate) > 0) continue;
                                matchInvoices.add(invoiceStatisticsVo);
                            }
                            break block85;
                        }
                        case F: {
                            String invoiceDate;
                            calendar.setTime(model.getSapPostingDate());
                            calendar.add(5, -1 * (Integer)((Object)delayDays));
                            String string = DateUtil.format((Date)calendar.getTime(), (String)"yyyy-MM-dd");
                            for (InvoiceStatisticsVo invoiceStatisticsVo : invoiceStatisticsList) {
                                invoiceDate = DateUtil.format((Date)invoiceStatisticsVo.getInvoiceDate(), (String)"yyyy-MM-dd");
                                if (invoiceDate == null || invoiceDate.compareTo(string) < 0 || invoiceDate.compareTo(posDate) > 0) continue;
                                matchInvoices.add(invoiceStatisticsVo);
                            }
                            break block85;
                        }
                        case UD: {
                            String invoiceDate;
                            calendar.setTime(model.getSapPostingDate());
                            calendar.add(5, (Integer)((Object)delayDays));
                            endDate = DateUtil.format((Date)calendar.getTime(), (String)"yyyy-MM-dd");
                            calendar.setTime(model.getSapPostingDate());
                            calendar.add(5, -1 * (Integer)((Object)delayDays));
                            String string = DateUtil.format((Date)calendar.getTime(), (String)"yyyy-MM-dd");
                            for (InvoiceStatisticsVo invoiceStatisticsVo : invoiceStatisticsList) {
                                invoiceDate = DateUtil.format((Date)invoiceStatisticsVo.getInvoiceDate(), (String)"yyyy-MM-dd");
                                if (invoiceDate == null || invoiceDate.compareTo(string) < 0 || invoiceDate.compareTo(endDate) > 0) continue;
                                matchInvoices.add(invoiceStatisticsVo);
                            }
                            break block85;
                        }
                    }
                    break block85;
                }
                matchInvoices.addAll(invoiceStatisticsList);
            }
            if (CollectionUtils.isEmpty(matchInvoices)) {
                modelList.add(model);
                continue;
            }
            if (matchInvoices.size() == 1) {
                for (InvoiceStatisticsVo invoiceStatisticsVo : matchInvoices) {
                    invoiceTotalCount = invoiceTotalCount.add(invoiceStatisticsVo.getInvoiceCount());
                    invoiceTotalAmount = invoiceTotalAmount.add(invoiceStatisticsVo.getInvoiceAmount());
                    invoiceTotalAmountTaxExclusive = invoiceTotalAmountTaxExclusive.add(invoiceStatisticsVo.getInvoiceAmountTaxExclusive());
                    invoiceModel = new AuditMatchInvoiceModel();
                    invoiceModel.setInvoiceCode(invoiceStatisticsVo.getInvoiceCode());
                    invoiceModel.setRelationId(invoiceStatisticsVo.getInvoiceCode());
                    invoiceModel.setInvoiceType(invoiceStatisticsVo.getInvoiceType());
                    invoiceModel.setTemplateCode(auditTemplate.getTemplateCode());
                    invoiceModel.setAuditCode(model.getAuditCode());
                    invoiceModels.add(invoiceModel);
                }
            } else {
                for (InvoiceStatisticsVo invoiceStatisticsVo : matchInvoices) {
                    if (model.getSapEaCount().compareTo(invoiceStatisticsVo.getInvoiceCount()) != 0) continue;
                    invoiceTotalCount = invoiceTotalCount.add(invoiceStatisticsVo.getInvoiceCount());
                    invoiceTotalAmount = invoiceTotalAmount.add(invoiceStatisticsVo.getInvoiceAmount());
                    invoiceTotalAmountTaxExclusive = invoiceTotalAmountTaxExclusive.add(invoiceStatisticsVo.getInvoiceAmountTaxExclusive());
                    invoiceModel = new AuditMatchInvoiceModel();
                    invoiceModel.setInvoiceCode(invoiceStatisticsVo.getInvoiceCode());
                    invoiceModel.setRelationId(invoiceStatisticsVo.getInvoiceCode());
                    invoiceModel.setInvoiceType(invoiceStatisticsVo.getInvoiceType());
                    invoiceModel.setTemplateCode(auditTemplate.getTemplateCode());
                    invoiceModel.setAuditCode(model.getAuditCode());
                    invoiceModels.add(invoiceModel);
                    break;
                }
            }
            model.setInvoiceTotalCount(invoiceTotalCount);
            model.setInvoiceTotalAmount(invoiceTotalAmount);
            model.setInvoiceTotalAmountTaxExclusive(invoiceTotalAmountTaxExclusive);
            model.setAuditMatchInvoiceModels(invoiceModels);
            model.setInvoicePrice(((InvoiceStatisticsVo)matchInvoices.get(0)).getInvoicePrice());
            model.setInvoicePriceNoTax(((InvoiceStatisticsVo)matchInvoices.get(0)).getInvoicePriceNoTax());
        }
        List<Object> crossModels = new ArrayList();
        List verifyCodes = models.stream().map(MatchConsequenceCalculatedModel::getVerifyCode).distinct().collect(Collectors.toList());
        List crossAuditVo = this.auditMatchCrossAcceptanceRepository.findAuditCrossAcceptanceByVerifyCodes(verifyCodes, TenantUtils.getTenantCode());
        if (!CollectionUtils.isEmpty((Collection)crossAuditVo)) {
            List conVerifyCodes = crossAuditVo.stream().map(AuditMatchCrossAcceptance::getVerifyCode).distinct().collect(Collectors.toList());
            crossModels = models.stream().filter(vo -> conVerifyCodes.contains(vo.getVerifyCode())).collect(Collectors.toList());
        }
        models.removeAll(crossModels);
        for (MatchConsequenceCalculatedModel model : models) {
            void var28_40;
            AuditMatchInvoiceModel invoiceModel;
            BigDecimal invoiceTotalAmountTaxExclusive;
            BigDecimal bigDecimal;
            BigDecimal invoiceTotalCount;
            ArrayList<InvoiceStatisticsVo> matchInvoices;
            ArrayList<AuditMatchInvoiceModel> invoiceModels;
            block87: {
                List invoiceStatisticsList;
                block86: {
                    invoiceModels = new ArrayList<AuditMatchInvoiceModel>();
                    String mapKey = null;
                    if (params.size() == 4 && CollectionUtils.isEmpty((Collection)orderCodes)) {
                        mapKey = StringUtils.joinWith((String)"_", (Object[])new Object[]{model.getSapMaterialCode(), model.getDeliveryCode(), model.getSoldToPartyCode()});
                    }
                    if (params.size() == 4 && CollectionUtils.isEmpty((Collection)storeCodes)) {
                        mapKey = StringUtils.joinWith((String)"_", (Object[])new Object[]{model.getSapMaterialCode(), model.getRelationOrderCode(), model.getSoldToPartyCode()});
                    }
                    if (params.size() == 5) {
                        mapKey = StringUtils.joinWith((String)"_", (Object[])new Object[]{model.getSapMaterialCode(), model.getDeliveryCode(), model.getRelationOrderCode(), model.getSoldToPartyCode()});
                    }
                    if (CollectionUtils.isEmpty((Collection)(invoiceStatisticsList = (List)acceptanceMap.get(mapKey)))) {
                        modelList.add(model);
                        continue;
                    }
                    AuditTemplateSupermarket auditTemplateSupermarket = auditTemplateSupermarketMap.get(model.getDirectCode());
                    if (auditTemplateSupermarket == null) continue;
                    model.setPriceValue(auditTemplateSupermarket.getPriceValue());
                    model.setPriceType(auditTemplateSupermarket.getPriceType());
                    matchInvoices = new ArrayList<InvoiceStatisticsVo>();
                    invoiceTotalCount = BigDecimal.ZERO;
                    bigDecimal = BigDecimal.ZERO;
                    invoiceTotalAmountTaxExclusive = BigDecimal.ZERO;
                    if (!params.contains(MatchParamsEnum.DATE.getDictCode())) break block86;
                    if (!StringUtils.isNotEmpty((CharSequence)auditTemplateSupermarket.getDelayType())) break block87;
                    Iterator delayDays = auditTemplateSupermarket.getDelayDays();
                    String beginDate = null;
                    String endDate = null;
                    String posDate = DateUtil.format((Date)model.getSapPostingDate(), (String)"yyyy-MM-dd");
                    Calendar calendar = Calendar.getInstance();
                    switch (PriceTypeEnum.getByDictCode((String)auditTemplateSupermarket.getDelayType())) {
                        case Z: {
                            String invoiceDate;
                            calendar.setTime(model.getSapPostingDate());
                            calendar.add(5, (Integer)((Object)delayDays));
                            endDate = DateUtil.format((Date)calendar.getTime(), (String)"yyyy-MM-dd");
                            for (InvoiceStatisticsVo invoiceStatisticsVo : invoiceStatisticsList) {
                                invoiceDate = DateUtil.format((Date)invoiceStatisticsVo.getInvoiceDate(), (String)"yyyy-MM-dd");
                                if (invoiceDate == null || invoiceDate.compareTo(posDate) < 0 || invoiceDate.compareTo(endDate) > 0) continue;
                                matchInvoices.add(invoiceStatisticsVo);
                            }
                            break block87;
                        }
                        case F: {
                            String invoiceDate;
                            calendar.setTime(model.getSapPostingDate());
                            calendar.add(5, -1 * (Integer)((Object)delayDays));
                            beginDate = DateUtil.format((Date)calendar.getTime(), (String)"yyyy-MM-dd");
                            for (InvoiceStatisticsVo invoiceStatisticsVo : invoiceStatisticsList) {
                                invoiceDate = DateUtil.format((Date)invoiceStatisticsVo.getInvoiceDate(), (String)"yyyy-MM-dd");
                                if (invoiceDate == null || invoiceDate.compareTo(beginDate) < 0 || invoiceDate.compareTo(posDate) > 0) continue;
                                matchInvoices.add(invoiceStatisticsVo);
                            }
                            break block87;
                        }
                        case UD: {
                            String invoiceDate;
                            calendar.setTime(model.getSapPostingDate());
                            calendar.add(5, (Integer)((Object)delayDays));
                            endDate = DateUtil.format((Date)calendar.getTime(), (String)"yyyy-MM-dd");
                            calendar.setTime(model.getSapPostingDate());
                            calendar.add(5, -1 * (Integer)((Object)delayDays));
                            beginDate = DateUtil.format((Date)calendar.getTime(), (String)"yyyy-MM-dd");
                            for (InvoiceStatisticsVo invoiceStatisticsVo : invoiceStatisticsList) {
                                invoiceDate = DateUtil.format((Date)invoiceStatisticsVo.getInvoiceDate(), (String)"yyyy-MM-dd");
                                if (invoiceDate == null || invoiceDate.compareTo(beginDate) < 0 || invoiceDate.compareTo(endDate) > 0) continue;
                                matchInvoices.add(invoiceStatisticsVo);
                            }
                            break block87;
                        }
                    }
                    break block87;
                }
                matchInvoices.addAll(invoiceStatisticsList);
            }
            if (CollectionUtils.isEmpty(matchInvoices)) {
                modelList.add(model);
                continue;
            }
            if (matchInvoices.size() == 1) {
                for (InvoiceStatisticsVo statisticsVo : matchInvoices) {
                    void var28_37;
                    invoiceTotalCount = invoiceTotalCount.add(statisticsVo.getInvoiceCount());
                    BigDecimal bigDecimal2 = var28_37.add(statisticsVo.getInvoiceAmount());
                    invoiceTotalAmountTaxExclusive = invoiceTotalAmountTaxExclusive.add(statisticsVo.getInvoiceAmountTaxExclusive());
                    invoiceModel = new AuditMatchInvoiceModel();
                    invoiceModel.setInvoiceCode(statisticsVo.getInvoiceCode());
                    invoiceModel.setRelationId(statisticsVo.getInvoiceCode());
                    invoiceModel.setInvoiceType(statisticsVo.getInvoiceType());
                    invoiceModel.setTemplateCode(auditTemplate.getTemplateCode());
                    invoiceModel.setAuditCode(model.getAuditCode());
                    invoiceModels.add(invoiceModel);
                }
            } else {
                for (InvoiceStatisticsVo statisticsVo : matchInvoices) {
                    if (model.getSapEaCount().compareTo(statisticsVo.getInvoiceCount()) != 0) continue;
                    invoiceTotalCount = invoiceTotalCount.add(statisticsVo.getInvoiceCount());
                    BigDecimal bigDecimal3 = bigDecimal.add(statisticsVo.getInvoiceAmount());
                    invoiceTotalAmountTaxExclusive = invoiceTotalAmountTaxExclusive.add(statisticsVo.getInvoiceAmountTaxExclusive());
                    invoiceModel = new AuditMatchInvoiceModel();
                    invoiceModel.setInvoiceCode(statisticsVo.getInvoiceCode());
                    invoiceModel.setRelationId(statisticsVo.getInvoiceCode());
                    invoiceModel.setInvoiceType(statisticsVo.getInvoiceType());
                    invoiceModel.setTemplateCode(auditTemplate.getTemplateCode());
                    invoiceModel.setAuditCode(model.getAuditCode());
                    invoiceModels.add(invoiceModel);
                    break;
                }
            }
            model.setInvoiceTotalCount(invoiceTotalCount);
            model.setInvoiceTotalAmount((BigDecimal)var28_40);
            model.setInvoiceTotalAmountTaxExclusive(invoiceTotalAmountTaxExclusive);
            model.setAuditMatchInvoiceModels(invoiceModels);
            model.setInvoicePrice(((InvoiceStatisticsVo)matchInvoices.get(0)).getInvoicePrice());
        }
        if (!CollectionUtils.isEmpty((Collection)crossAuditVo)) {
            Map<String, List<AuditMatchCrossAcceptance>> crossMap = crossAuditVo.stream().collect(Collectors.groupingBy(AuditMatchCrossAcceptance::getVerifyCode));
            List crossRelationKaOrderCode = crossAuditVo.stream().filter(vo -> StringUtils.equals((CharSequence)AuditMatchCrossTypeEnum.RELATIONKACODE.getDictCode(), (CharSequence)vo.getCrossOrderType())).map(AuditMatchCrossAcceptance::getCrossOrderNumber).collect(Collectors.toList());
            List crossAcceptanceOrderNumber = crossAuditVo.stream().filter(vo -> StringUtils.equals((CharSequence)AuditMatchCrossTypeEnum.ORDERNUMBER.getDictCode(), (CharSequence)vo.getCrossOrderType())).map(AuditMatchCrossAcceptance::getCrossOrderNumber).collect(Collectors.toList());
            List crossInvoiceStatisticsVos = this.invoiceStatisticsVoService.findCrossByConditions("acceptance", crossRelationKaOrderCode, crossAcceptanceOrderNumber);
            List crossSuccessInvoiceStatisticsVos = crossInvoiceStatisticsVos.stream().filter(vo -> StringUtils.equals((CharSequence)AcceptanceStatus.S200.getDictCode(), (CharSequence)vo.getOrderStatus())).collect(Collectors.toList());
            Map<String, List<InvoiceStatisticsVo>> orderNumberMap = crossSuccessInvoiceStatisticsVos.stream().collect(Collectors.groupingBy(vo -> StringUtils.joinWith((String)"-", (Object[])new Object[]{vo.getOrderNumber(), vo.getGoodsCode()})));
            Map<String, List<InvoiceStatisticsVo>> orderCodeMap = crossSuccessInvoiceStatisticsVos.stream().collect(Collectors.groupingBy(vo -> StringUtils.joinWith((String)"-", (Object[])new Object[]{vo.getOrderCode(), vo.getGoodsCode()})));
            if (CollectionUtils.isEmpty(crossSuccessInvoiceStatisticsVos)) {
                if (params.contains(MatchParamsEnum.ORDER.getDictCode())) {
                    log.info("\u672a\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5230\u9a8c\u6536\u5355,\u8be5\u6b21\u7a9c\u5355\u5339\u914d\u9000\u51fa!");
                    this.updateNotReason(crossModels, crossInvoiceStatisticsVos);
                } else {
                    log.info("\u672a\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5230\u9a8c\u6536\u5355,\u8be5\u6b21\u7a9c\u5355\u5339\u914d\u9000\u51fa!");
                }
            } else {
                for (MatchConsequenceCalculatedModel matchConsequenceCalculatedModel : crossModels) {
                    AuditMatchInvoiceModel invoiceModel;
                    ArrayList<AuditMatchInvoiceModel> invoiceModels;
                    AuditTemplateSupermarket auditTemplateSupermarket = auditTemplateSupermarketMap.get(matchConsequenceCalculatedModel.getDirectCode());
                    if (auditTemplateSupermarket == null) continue;
                    matchConsequenceCalculatedModel.setPriceValue(auditTemplateSupermarket.getPriceValue());
                    matchConsequenceCalculatedModel.setPriceType(auditTemplateSupermarket.getPriceType());
                    BigDecimal invoiceTotalCount = BigDecimal.ZERO;
                    BigDecimal invoiceTotalAmount = BigDecimal.ZERO;
                    BigDecimal invoiceTotalAmountTaxExclusive = BigDecimal.ZERO;
                    BigDecimal price = BigDecimal.ZERO;
                    BigDecimal priceNot = BigDecimal.ZERO;
                    List<AuditMatchCrossAcceptance> auditMatchCrossAcceptances = crossMap.get(matchConsequenceCalculatedModel.getVerifyCode());
                    AuditMatchCrossAcceptance auditMatchCrossAcceptance = auditMatchCrossAcceptances.get(0);
                    if (StringUtils.equals((CharSequence)AuditMatchCrossExceptionEnum.WHOLEORDER.getDictCode(), (CharSequence)auditMatchCrossAcceptance.getExceptionType())) {
                        AuditMatchInvoiceModel invoiceModel2;
                        List<InvoiceStatisticsVo> waitMatchInvoices;
                        Object key;
                        invoiceModels = new ArrayList<AuditMatchInvoiceModel>();
                        if (StringUtils.equals((CharSequence)AuditMatchCrossTypeEnum.RELATIONKACODE.getDictCode(), (CharSequence)auditMatchCrossAcceptance.getCrossOrderType())) {
                            key = StringUtils.joinWith((String)"-", (Object[])new Object[]{auditMatchCrossAcceptance.getCrossOrderNumber(), auditMatchCrossAcceptance.getSapMaterialCode()});
                            waitMatchInvoices = orderCodeMap.get(key);
                            if (CollectionUtils.isEmpty(waitMatchInvoices)) {
                                modelList.add(matchConsequenceCalculatedModel);
                            } else {
                                if (waitMatchInvoices.size() == 1) {
                                    invoiceTotalCount = invoiceTotalCount.add(waitMatchInvoices.get(0).getInvoiceCount());
                                    invoiceTotalAmount = invoiceTotalAmount.add(waitMatchInvoices.get(0).getInvoiceAmount());
                                    invoiceTotalAmountTaxExclusive = invoiceTotalAmountTaxExclusive.add(waitMatchInvoices.get(0).getInvoiceAmountTaxExclusive());
                                    invoiceModel2 = new AuditMatchInvoiceModel();
                                    invoiceModel2.setInvoiceCode(waitMatchInvoices.get(0).getInvoiceCode());
                                    invoiceModel2.setRelationId(waitMatchInvoices.get(0).getInvoiceCode());
                                    invoiceModel2.setInvoiceType(waitMatchInvoices.get(0).getInvoiceType());
                                    invoiceModel2.setTemplateCode(auditTemplate.getTemplateCode());
                                    invoiceModel2.setAuditCode(matchConsequenceCalculatedModel.getAuditCode());
                                    invoiceModels.add(invoiceModel2);
                                } else {
                                    for (InvoiceStatisticsVo statisticsVo : waitMatchInvoices) {
                                        if (auditMatchCrossAcceptance.getCrossOrderNum().compareTo(statisticsVo.getInvoiceCount()) != 0) continue;
                                        invoiceTotalCount = invoiceTotalCount.add(statisticsVo.getInvoiceCount());
                                        invoiceTotalAmount = invoiceTotalAmount.add(statisticsVo.getInvoiceAmount());
                                        invoiceTotalAmountTaxExclusive = invoiceTotalAmountTaxExclusive.add(statisticsVo.getInvoiceAmountTaxExclusive());
                                        invoiceModel = new AuditMatchInvoiceModel();
                                        invoiceModel.setInvoiceCode(statisticsVo.getInvoiceCode());
                                        invoiceModel.setRelationId(statisticsVo.getInvoiceCode());
                                        invoiceModel.setInvoiceType(statisticsVo.getInvoiceType());
                                        invoiceModel.setTemplateCode(auditTemplate.getTemplateCode());
                                        invoiceModel.setAuditCode(matchConsequenceCalculatedModel.getAuditCode());
                                        invoiceModels.add(invoiceModel);
                                        break;
                                    }
                                }
                                matchConsequenceCalculatedModel.setInvoiceTotalCount(invoiceTotalCount);
                                matchConsequenceCalculatedModel.setInvoiceTotalAmount(invoiceTotalAmount);
                                matchConsequenceCalculatedModel.setInvoiceTotalAmountTaxExclusive(invoiceTotalAmountTaxExclusive);
                                matchConsequenceCalculatedModel.setAuditMatchInvoiceModels(invoiceModels);
                                matchConsequenceCalculatedModel.setInvoicePrice(waitMatchInvoices.get(0).getInvoicePrice());
                                matchConsequenceCalculatedModel.setInvoicePriceNoTax(waitMatchInvoices.get(0).getInvoicePriceNoTax());
                                matchConsequenceCalculatedModel.setCrossOrderNumber(auditMatchCrossAcceptance.getCrossOrderNumber());
                            }
                        } else {
                            key = StringUtils.joinWith((String)"-", (Object[])new Object[]{auditMatchCrossAcceptance.getCrossOrderNumber(), auditMatchCrossAcceptance.getSapMaterialCode()});
                            waitMatchInvoices = orderNumberMap.get(key);
                            if (CollectionUtils.isEmpty(waitMatchInvoices)) {
                                modelList.add(matchConsequenceCalculatedModel);
                            } else {
                                if (waitMatchInvoices.size() == 1) {
                                    invoiceTotalCount = invoiceTotalCount.add(waitMatchInvoices.get(0).getInvoiceCount());
                                    invoiceTotalAmount = invoiceTotalAmount.add(waitMatchInvoices.get(0).getInvoiceAmount());
                                    invoiceTotalAmountTaxExclusive = invoiceTotalAmountTaxExclusive.add(waitMatchInvoices.get(0).getInvoiceAmountTaxExclusive());
                                    invoiceModel2 = new AuditMatchInvoiceModel();
                                    invoiceModel2.setInvoiceCode(waitMatchInvoices.get(0).getInvoiceCode());
                                    invoiceModel2.setRelationId(waitMatchInvoices.get(0).getInvoiceCode());
                                    invoiceModel2.setInvoiceType(waitMatchInvoices.get(0).getInvoiceType());
                                    invoiceModel2.setTemplateCode(auditTemplate.getTemplateCode());
                                    invoiceModel2.setAuditCode(matchConsequenceCalculatedModel.getAuditCode());
                                    invoiceModels.add(invoiceModel2);
                                } else {
                                    for (InvoiceStatisticsVo statisticsVo : waitMatchInvoices) {
                                        if (auditMatchCrossAcceptance.getCrossOrderNum().compareTo(statisticsVo.getInvoiceCount()) != 0) continue;
                                        invoiceTotalCount = invoiceTotalCount.add(statisticsVo.getInvoiceCount());
                                        invoiceTotalAmount = invoiceTotalAmount.add(statisticsVo.getInvoiceAmount());
                                        invoiceTotalAmountTaxExclusive = invoiceTotalAmountTaxExclusive.add(statisticsVo.getInvoiceAmountTaxExclusive());
                                        invoiceModel = new AuditMatchInvoiceModel();
                                        invoiceModel.setInvoiceCode(statisticsVo.getInvoiceCode());
                                        invoiceModel.setRelationId(statisticsVo.getInvoiceCode());
                                        invoiceModel.setInvoiceType(statisticsVo.getInvoiceType());
                                        invoiceModel.setTemplateCode(auditTemplate.getTemplateCode());
                                        invoiceModel.setAuditCode(matchConsequenceCalculatedModel.getAuditCode());
                                        invoiceModels.add(invoiceModel);
                                        break;
                                    }
                                }
                                matchConsequenceCalculatedModel.setInvoiceTotalCount(invoiceTotalCount);
                                matchConsequenceCalculatedModel.setInvoiceTotalAmount(invoiceTotalAmount);
                                matchConsequenceCalculatedModel.setInvoiceTotalAmountTaxExclusive(invoiceTotalAmountTaxExclusive);
                                matchConsequenceCalculatedModel.setAuditMatchInvoiceModels(invoiceModels);
                                matchConsequenceCalculatedModel.setInvoicePrice(waitMatchInvoices.get(0).getInvoicePrice());
                                matchConsequenceCalculatedModel.setInvoicePriceNoTax(waitMatchInvoices.get(0).getInvoicePriceNoTax());
                                matchConsequenceCalculatedModel.setCrossOrderNumber(auditMatchCrossAcceptance.getCrossOrderNumber());
                            }
                        }
                    } else {
                        invoiceModels = new ArrayList();
                        block25: for (AuditMatchCrossAcceptance matchCrossAcceptance : auditMatchCrossAcceptances) {
                            List<InvoiceStatisticsVo> waitMatchInvoices;
                            String key;
                            if (StringUtils.equals((CharSequence)AuditMatchCrossTypeEnum.RELATIONKACODE.getDictCode(), (CharSequence)auditMatchCrossAcceptance.getCrossOrderType())) {
                                key = StringUtils.joinWith((String)"-", (Object[])new Object[]{matchCrossAcceptance.getCrossOrderNumber(), matchCrossAcceptance.getSapMaterialCode()});
                                waitMatchInvoices = orderCodeMap.get(key);
                                if (CollectionUtils.isEmpty(waitMatchInvoices)) continue;
                                if (waitMatchInvoices.size() == 1) {
                                    invoiceTotalCount = invoiceTotalCount.add(waitMatchInvoices.get(0).getInvoiceCount());
                                    invoiceTotalAmount = invoiceTotalAmount.add(waitMatchInvoices.get(0).getInvoiceAmount());
                                    invoiceTotalAmountTaxExclusive = invoiceTotalAmountTaxExclusive.add(waitMatchInvoices.get(0).getInvoiceAmountTaxExclusive());
                                    invoiceModel = new AuditMatchInvoiceModel();
                                    invoiceModel.setInvoiceCode(waitMatchInvoices.get(0).getInvoiceCode());
                                    invoiceModel.setRelationId(waitMatchInvoices.get(0).getInvoiceCode());
                                    invoiceModel.setInvoiceType(waitMatchInvoices.get(0).getInvoiceType());
                                    invoiceModel.setCrossOrderNumber(matchCrossAcceptance.getCrossOrderNumber());
                                    invoiceModel.setTemplateCode(auditTemplate.getTemplateCode());
                                    invoiceModel.setAuditCode(matchConsequenceCalculatedModel.getAuditCode());
                                    invoiceModels.add(invoiceModel);
                                    continue;
                                }
                                for (InvoiceStatisticsVo statisticsVo : waitMatchInvoices) {
                                    if (matchCrossAcceptance.getCrossOrderNum().compareTo(statisticsVo.getInvoiceCount()) != 0) continue;
                                    invoiceTotalCount = invoiceTotalCount.add(statisticsVo.getInvoiceCount());
                                    invoiceTotalAmount = invoiceTotalAmount.add(statisticsVo.getInvoiceAmount());
                                    invoiceTotalAmountTaxExclusive = invoiceTotalAmountTaxExclusive.add(statisticsVo.getInvoiceAmountTaxExclusive());
                                    AuditMatchInvoiceModel invoiceModel3 = new AuditMatchInvoiceModel();
                                    invoiceModel3.setInvoiceCode(statisticsVo.getInvoiceCode());
                                    invoiceModel3.setRelationId(statisticsVo.getInvoiceCode());
                                    invoiceModel3.setInvoiceType(statisticsVo.getInvoiceType());
                                    invoiceModel3.setCrossOrderNumber(matchCrossAcceptance.getCrossOrderNumber());
                                    invoiceModel3.setTemplateCode(auditTemplate.getTemplateCode());
                                    invoiceModel3.setAuditCode(matchConsequenceCalculatedModel.getAuditCode());
                                    invoiceModels.add(invoiceModel3);
                                    continue block25;
                                }
                                continue;
                            }
                            key = StringUtils.joinWith((String)"-", (Object[])new Object[]{auditMatchCrossAcceptance.getCrossOrderNumber(), auditMatchCrossAcceptance.getSapMaterialCode()});
                            waitMatchInvoices = orderNumberMap.get(key);
                            if (CollectionUtils.isEmpty(waitMatchInvoices)) {
                                modelList.add(matchConsequenceCalculatedModel);
                                continue;
                            }
                            if (waitMatchInvoices.size() == 1) {
                                invoiceTotalCount = invoiceTotalCount.add(waitMatchInvoices.get(0).getInvoiceCount());
                                invoiceTotalAmount = invoiceTotalAmount.add(waitMatchInvoices.get(0).getInvoiceAmount());
                                invoiceTotalAmountTaxExclusive = invoiceTotalAmountTaxExclusive.add(waitMatchInvoices.get(0).getInvoiceAmountTaxExclusive());
                                price = waitMatchInvoices.get(0).getInvoicePrice();
                                priceNot = waitMatchInvoices.get(0).getInvoicePriceNoTax();
                                invoiceModel = new AuditMatchInvoiceModel();
                                invoiceModel.setInvoiceCode(waitMatchInvoices.get(0).getInvoiceCode());
                                invoiceModel.setRelationId(waitMatchInvoices.get(0).getInvoiceCode());
                                invoiceModel.setInvoiceType(waitMatchInvoices.get(0).getInvoiceType());
                                invoiceModel.setTemplateCode(auditTemplate.getTemplateCode());
                                invoiceModel.setCrossOrderNumber(matchCrossAcceptance.getCrossOrderNumber());
                                invoiceModel.setAuditCode(matchConsequenceCalculatedModel.getAuditCode());
                                invoiceModels.add(invoiceModel);
                                continue;
                            }
                            for (InvoiceStatisticsVo statisticsVo : waitMatchInvoices) {
                                if (auditMatchCrossAcceptance.getCrossOrderNum().compareTo(statisticsVo.getInvoiceCount()) != 0) continue;
                                price = waitMatchInvoices.get(0).getInvoicePrice();
                                priceNot = waitMatchInvoices.get(0).getInvoicePriceNoTax();
                                invoiceTotalCount = invoiceTotalCount.add(statisticsVo.getInvoiceCount());
                                invoiceTotalAmount = invoiceTotalAmount.add(statisticsVo.getInvoiceAmount());
                                invoiceTotalAmountTaxExclusive = invoiceTotalAmountTaxExclusive.add(statisticsVo.getInvoiceAmountTaxExclusive());
                                AuditMatchInvoiceModel invoiceModel3 = new AuditMatchInvoiceModel();
                                invoiceModel3.setInvoiceCode(statisticsVo.getInvoiceCode());
                                invoiceModel3.setRelationId(statisticsVo.getInvoiceCode());
                                invoiceModel3.setInvoiceType(statisticsVo.getInvoiceType());
                                invoiceModel3.setCrossOrderNumber(matchCrossAcceptance.getCrossOrderNumber());
                                invoiceModel3.setTemplateCode(auditTemplate.getTemplateCode());
                                invoiceModel3.setAuditCode(matchConsequenceCalculatedModel.getAuditCode());
                                invoiceModels.add(invoiceModel3);
                                continue block25;
                            }
                        }
                        matchConsequenceCalculatedModel.setInvoiceTotalCount(invoiceTotalCount);
                        matchConsequenceCalculatedModel.setInvoiceTotalAmount(invoiceTotalAmount);
                        matchConsequenceCalculatedModel.setInvoiceTotalAmountTaxExclusive(invoiceTotalAmountTaxExclusive);
                        matchConsequenceCalculatedModel.setAuditMatchInvoiceModels(invoiceModels);
                        StringBuffer buffer = new StringBuffer();
                        for (AuditMatchInvoiceModel invoiceModel2 : invoiceModels) {
                            buffer.append(invoiceModel2.getCrossOrderNumber() + "/");
                        }
                        matchConsequenceCalculatedModel.setCrossOrderNumber(String.valueOf(buffer));
                        matchConsequenceCalculatedModel.setInvoicePrice(price);
                        matchConsequenceCalculatedModel.setInvoicePriceNoTax(priceNot);
                    }
                    models.add(matchConsequenceCalculatedModel);
                }
            }
        }
        if (params.contains(MatchParamsEnum.ORDER.getDictCode())) {
            List<AuditMatchNotReasonDto> notMatchReason = this.findNotMatchReason(invoiceStatisticsVos, modelList, auditTemplateSupermarketMap);
            this.calculate(models, notMatchReason);
        } else {
            this.calculate(models, null);
        }
    }

    public void notAutoExecute(String templateCode, MatchConsequenceCalculatedModel calculatedModel, List<AuditMatchInvoice> auditMatchInvoices) {
        AuditMatchInvoiceModel invoiceModel;
        Validate.isTrue((!Objects.isNull(calculatedModel) ? 1 : 0) != 0, (String)"\u6267\u884c\u5339\u914d\u8ba1\u7b97\u903b\u8f91\u65f6\uff0c\u9700\u8981\u5339\u914d\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        ArrayList auditCodes = Lists.newArrayList((Object[])new String[]{calculatedModel.getAuditCode()});
        List matchInvoiceList = this.matchInvoiceManuRepository.findByAuditCodes((List)auditCodes);
        List invoiceStatisticsVos = new ArrayList();
        List<Object> relationId = new ArrayList();
        if (!CollectionUtils.isEmpty(auditMatchInvoices)) {
            relationId = auditMatchInvoices.stream().map(AuditMatchInvoice::getRelationId).collect(Collectors.toList());
            invoiceStatisticsVos = this.invoiceStatisticsVoService.findByRelationId("acceptance", relationId);
            Validate.isTrue((!CollectionUtils.isEmpty(invoiceStatisticsVos) ? 1 : 0) != 0, (String)"\u6267\u884c\u5339\u914d\u8ba1\u7b97\u903b\u8f91\u65f6\uff0c\u672a\u5339\u914d\u5230\u9a8c\u6536\u5355\uff01", (Object[])new Object[0]);
        }
        ArrayList<AuditMatchInvoiceModel> invoiceModels = new ArrayList<AuditMatchInvoiceModel>();
        BigDecimal invoiceTotalCount = BigDecimal.ZERO;
        BigDecimal invoiceTotalAmount = BigDecimal.ZERO;
        BigDecimal invoiceTotalAmountTaxExclusive = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(auditMatchInvoices)) {
            for (InvoiceStatisticsVo statisticsVo : invoiceStatisticsVos) {
                invoiceTotalCount = invoiceTotalCount.add(statisticsVo.getInvoiceCount() == null ? BigDecimal.ZERO : statisticsVo.getInvoiceCount());
                invoiceTotalAmount = invoiceTotalAmount.add(statisticsVo.getInvoiceAmount() == null ? BigDecimal.ZERO : statisticsVo.getInvoiceAmount());
                invoiceTotalAmountTaxExclusive = invoiceTotalAmountTaxExclusive.add(statisticsVo.getInvoiceAmountTaxExclusive() == null ? BigDecimal.ZERO : statisticsVo.getInvoiceAmountTaxExclusive());
                invoiceModel = new AuditMatchInvoiceModel();
                invoiceModel.setInvoiceCode(statisticsVo.getInvoiceCode());
                invoiceModel.setInvoiceType(statisticsVo.getInvoiceType());
                invoiceModel.setTemplateCode(templateCode);
                invoiceModel.setAuditCode(calculatedModel.getAuditCode());
                invoiceModel.setRelationId(statisticsVo.getInvoiceCode());
                invoiceModels.add(invoiceModel);
            }
        }
        for (MatchInvoiceManuEntity matchInvoiceManuEntity : matchInvoiceList) {
            invoiceTotalCount = invoiceTotalCount.add(matchInvoiceManuEntity.getCurCompanyUnitOrderQuantity() == null ? BigDecimal.ZERO : matchInvoiceManuEntity.getCurCompanyUnitOrderQuantity());
            invoiceTotalAmount = invoiceTotalAmount.add(matchInvoiceManuEntity.getAcceptanceAmount() == null ? BigDecimal.ZERO : matchInvoiceManuEntity.getAcceptanceAmount());
            invoiceTotalAmountTaxExclusive = invoiceTotalAmountTaxExclusive.add(matchInvoiceManuEntity.getAcceptanceAmountNot() == null ? BigDecimal.ZERO : matchInvoiceManuEntity.getAcceptanceAmountNot());
            invoiceModel = new AuditMatchInvoiceModel();
            invoiceModel.setInvoiceCode(matchInvoiceManuEntity.getId());
            invoiceModel.setTemplateCode(templateCode);
            invoiceModel.setAuditCode(matchInvoiceManuEntity.getAuditCode());
            invoiceModel.setRelationId(matchInvoiceManuEntity.getId());
            invoiceModels.add(invoiceModel);
        }
        calculatedModel.setInvoiceTotalCount(invoiceTotalCount);
        calculatedModel.setInvoiceTotalAmount(invoiceTotalAmount);
        calculatedModel.setInvoiceTotalAmountTaxExclusive(invoiceTotalAmountTaxExclusive);
        calculatedModel.setAuditMatchInvoiceModels(invoiceModels);
        calculatedModel.setTemplateCode(templateCode);
        calculatedModel.setInvoicePrice(((InvoiceStatisticsVo)invoiceStatisticsVos.get(0)).getInvoicePrice());
        calculatedModel.setInvoicePriceNoTax(((InvoiceStatisticsVo)invoiceStatisticsVos.get(0)).getInvoicePriceNoTax());
        this.manuCalculate(calculatedModel, relationId);
    }

    private List<AuditMatchNotReasonDto> findNotMatchReason(List<InvoiceStatisticsVo> invoiceStatisticsVos, List<MatchConsequenceCalculatedModel> models, Map<String, AuditTemplateSupermarket> auditTemplateSupermarketMap) {
        ArrayList<AuditMatchNotReasonDto> notMatchModel = new ArrayList<AuditMatchNotReasonDto>();
        Map<String, List<InvoiceStatisticsVo>> caseOneMap = invoiceStatisticsVos.stream().collect(Collectors.groupingBy(InvoiceStatisticsVo::getOrderCode));
        for (MatchConsequenceCalculatedModel model : models) {
            AuditTemplateSupermarket auditTemplateSupermarket = auditTemplateSupermarketMap.get(model.getDirectCode());
            Integer delayDays = auditTemplateSupermarket.getDelayDays();
            String caseOneKey = model.getRelationOrderCode();
            String caseTwoKey = StringUtils.joinWith((String)"-", (Object[])new Object[]{model.getRelationOrderCode(), model.getSapMaterialCode()});
            String caseThreeKey = StringUtils.joinWith((String)"-", (Object[])new Object[]{model.getSapMaterialCode(), model.getSoldToPartyCode(), model.getRelationOrderCode()});
            StringBuffer reason = new StringBuffer();
            if (StringUtils.isEmpty((CharSequence)caseOneKey)) {
                reason.append("\u65e0\u91c7\u8d2d\u5355\u53f7!");
            } else {
                List<InvoiceStatisticsVo> caseOneVo = caseOneMap.get(caseOneKey);
                if (CollectionUtils.isEmpty(caseOneVo)) {
                    reason.append("KA\u5355\u636e\u4e0d\u5b58\u5728||");
                } else {
                    List caseSuccessOneVo = caseOneVo.stream().filter(vo -> StringUtils.equals((CharSequence)AcceptanceStatus.S200.getDictCode(), (CharSequence)vo.getOrderStatus())).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(caseSuccessOneVo)) {
                        reason.append("\u5355\u636e\u8f6c\u6362\u5931\u8d25||" + caseOneVo.get(0).getOrderStatusMsg());
                    } else {
                        Map<String, List<InvoiceStatisticsVo>> caseTwoMap = caseSuccessOneVo.stream().collect(Collectors.groupingBy(vo -> StringUtils.joinWith((String)"-", (Object[])new Object[]{vo.getOrderCode(), vo.getGoodsCode()})));
                        List<InvoiceStatisticsVo> caseTwoVo = caseTwoMap.get(caseTwoKey);
                        reason.append("\u8f6c\u6362\u6210\u529f||");
                        if (CollectionUtils.isEmpty(caseTwoVo)) {
                            reason.append("\u8be5\u91c7\u8d2d\u5355\u4e0b,\u8be5\u4ea7\u54c1\u6570\u636e\u4e0d\u5b58\u5728||");
                        } else {
                            Map<String, List<InvoiceStatisticsVo>> caseThreeMap = caseSuccessOneVo.stream().collect(Collectors.groupingBy(vo -> StringUtils.joinWith((String)"-", (Object[])new Object[]{vo.getGoodsCode(), vo.getSoldToPartyCode(), vo.getOrderCode()})));
                            List<InvoiceStatisticsVo> caseThreeVo = caseThreeMap.get(caseThreeKey);
                            if (CollectionUtils.isEmpty(caseThreeVo)) {
                                reason.append("\u552e\u8fbe\u65b9\u672a\u80fd\u5339\u914d||");
                            } else {
                                ArrayList<InvoiceStatisticsVo> dateInvoices = new ArrayList<InvoiceStatisticsVo>();
                                String beginDate = null;
                                String endDate = null;
                                String posDate = DateUtil.format((Date)model.getSapPostingDate(), (String)"yyyy-MM-dd");
                                Calendar calendar = Calendar.getInstance();
                                switch (PriceTypeEnum.getByDictCode((String)auditTemplateSupermarket.getDelayType())) {
                                    case Z: {
                                        String invoiceDate;
                                        calendar.setTime(model.getSapPostingDate());
                                        calendar.add(5, delayDays);
                                        endDate = DateUtil.format((Date)calendar.getTime(), (String)"yyyy-MM-dd");
                                        for (InvoiceStatisticsVo invoiceStatisticsVo : caseThreeVo) {
                                            invoiceDate = DateUtil.format((Date)invoiceStatisticsVo.getInvoiceDate(), (String)"yyyy-MM-dd");
                                            if (invoiceDate == null || invoiceDate.compareTo(posDate) < 0 || invoiceDate.compareTo(endDate) > 0) continue;
                                            dateInvoices.add(invoiceStatisticsVo);
                                        }
                                        break;
                                    }
                                    case F: {
                                        String invoiceDate;
                                        calendar.setTime(model.getSapPostingDate());
                                        calendar.add(5, -1 * delayDays);
                                        beginDate = DateUtil.format((Date)calendar.getTime(), (String)"yyyy-MM-dd");
                                        for (InvoiceStatisticsVo invoiceStatisticsVo : caseThreeVo) {
                                            invoiceDate = DateUtil.format((Date)invoiceStatisticsVo.getInvoiceDate(), (String)"yyyy-MM-dd");
                                            if (invoiceDate == null || invoiceDate.compareTo(beginDate) < 0 || invoiceDate.compareTo(posDate) > 0) continue;
                                            dateInvoices.add(invoiceStatisticsVo);
                                        }
                                        break;
                                    }
                                    case UD: {
                                        String invoiceDate;
                                        calendar.setTime(model.getSapPostingDate());
                                        calendar.add(5, delayDays);
                                        endDate = DateUtil.format((Date)calendar.getTime(), (String)"yyyy-MM-dd");
                                        calendar.setTime(model.getSapPostingDate());
                                        calendar.add(5, -1 * delayDays);
                                        beginDate = DateUtil.format((Date)calendar.getTime(), (String)"yyyy-MM-dd");
                                        for (InvoiceStatisticsVo invoiceStatisticsVo : caseThreeVo) {
                                            invoiceDate = DateUtil.format((Date)invoiceStatisticsVo.getInvoiceDate(), (String)"yyyy-MM-dd");
                                            if (invoiceDate == null || invoiceDate.compareTo(beginDate) < 0 || invoiceDate.compareTo(endDate) > 0) continue;
                                            dateInvoices.add(invoiceStatisticsVo);
                                        }
                                        break;
                                    }
                                }
                                if (CollectionUtils.isEmpty(dateInvoices)) {
                                    reason.append("\u8d85\u51fa\u65f6\u95f4\u5bb9\u5dee\u8303\u56f4||");
                                } else if (dateInvoices.size() > 1) {
                                    boolean numFlag = false;
                                    for (InvoiceStatisticsVo invoiceStatisticsVo : caseThreeVo) {
                                        if (model.getSapEaCount().compareTo(invoiceStatisticsVo.getInvoiceCount()) != 0) continue;
                                        numFlag = true;
                                    }
                                    if (!numFlag) {
                                        reason.append("\u6709\u591a\u4e2a\u9a8c\u6536\u5173\u7cfb,\u6570\u91cf\u672a\u80fd\u5339\u914d||");
                                    }
                                } else if (dateInvoices.size() == 1) {
                                    reason.append("\u672a\u77e5\u539f\u56e0||");
                                }
                            }
                        }
                    }
                }
            }
            AuditMatchNotReasonDto dto = new AuditMatchNotReasonDto();
            dto.setAuditCode(model.getAuditCode());
            dto.setNotMatchReason(String.valueOf(reason));
            notMatchModel.add(dto);
        }
        return notMatchModel;
    }

    private void updateNotReason(List<MatchConsequenceCalculatedModel> models, List<InvoiceStatisticsVo> invoiceStatisticsVos) {
        ArrayList<AuditMatchNotReasonDto> notMatchModel = new ArrayList<AuditMatchNotReasonDto>();
        Map<String, List<InvoiceStatisticsVo>> caseOneMap = invoiceStatisticsVos.stream().collect(Collectors.groupingBy(InvoiceStatisticsVo::getOrderCode));
        for (MatchConsequenceCalculatedModel model : models) {
            if (caseOneMap.containsKey(model.getRelationOrderCode())) {
                List<InvoiceStatisticsVo> invoiceStatisticsList = caseOneMap.get(model.getRelationOrderCode());
                AuditMatchNotReasonDto dto = new AuditMatchNotReasonDto();
                dto.setNotMatchReason("\u5355\u636e\u8f6c\u6362\u5931\u8d25||" + invoiceStatisticsList.get(0).getOrderStatusMsg());
                dto.setAuditCode(model.getAuditCode());
                notMatchModel.add(dto);
                continue;
            }
            AuditMatchNotReasonDto dto = new AuditMatchNotReasonDto();
            dto.setNotMatchReason("KA\u5355\u636e\u4e0d\u5b58\u5728||");
            dto.setAuditCode(model.getAuditCode());
            notMatchModel.add(dto);
        }
        this.auditMatchService.updateNotMatchReason(notMatchModel);
    }
}

