package com.biz.crm.kms.business.direct.account.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.direct.account.sdk.dto.DirectAccountDto;
import com.biz.crm.kms.business.direct.account.sdk.service.DirectAccountVoService;
import com.biz.crm.kms.business.direct.account.sdk.vo.DirectAccountVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import java.util.List;

import lombok.extern.slf4j.Slf4j;

/**
 * 直营账号管理表(DirectAccount)表控制层
 *
 * @author xi.peng
 * @since 2022-09-23 10:47:58
 */
@Slf4j
@Api(tags = "直营账号管理表：DirectAccountVo")
@RestController
@RequestMapping(value = {"/v1/directAccount/directAccountVo"})
public class DirectAccountVoController {

  @Autowired(required = false)
  private DirectAccountVoService directAccountVoService;

  @ApiOperation(value = "按系统编码查询")
  @GetMapping(value = {"/findByDirectCode"})
  public Result<List<DirectAccountVo>> findByDirectCode(@RequestParam("directCode") String directCode) {
    try {
      List<DirectAccountVo> result = this.directAccountVoService.findByDirectCode(directCode);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "按账号集合查询")
  @GetMapping(value = {"/findByAccountList"})
  public Result<List<DirectAccountVo>> findByAccountList(@RequestBody List<String> accountList) {
    try {
      List<DirectAccountVo> result = this.directAccountVoService.findByAccountList(accountList);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "详情")
  @GetMapping(value = {"/findDetailById"})
  public Result<DirectAccountVo> findDetailById(@RequestParam("id") String id) {
    try {
      DirectAccountVo vo = this.directAccountVoService.findDetailById(id);
      return Result.ok(vo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "创建")
  @PostMapping(value = "")
  public Result create(@RequestBody DirectAccountDto dto) {
    try {
      this.directAccountVoService.create(dto);
      return Result.ok("创建成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "更新")
  @PatchMapping(value = "")
  public Result update(@RequestBody DirectAccountDto dto) {
    try {
      this.directAccountVoService.update(dto);
      return Result.ok("更新成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "启用")
  @PatchMapping("/enable")
  public Result enable(@RequestBody List<String> ids) {
    try {
      this.directAccountVoService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "禁用")
  @PatchMapping("/disable")
  public Result disable(@RequestBody List<String> ids) {
    try {
      this.directAccountVoService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "逻辑删除")
  @DeleteMapping("/delete")
  public Result delete(@RequestParam("ids") List<String> ids) {
    try {
      this.directAccountVoService.updateDelFlagByIds(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
