package com.biz.crm.kms.business.direct.account.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 直营账号管理表(DirectAccount)实体类
 * 
 * @author pengxi
 * @since 2022-09-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@Table(name = "kms_direct_account")
@TableName(value = "kms_direct_account")
@ApiModel(value = "DirectAccount", description = "直营账号管理表")
@org.hibernate.annotations.Table(appliesTo = "kms_direct_account", comment = "直营账号管理表")
public class DirectAccountEntity extends TenantFlagOpEntity {

  @ApiModelProperty("系统编码")
  @TableField(value = "direct_code")
  @Column(name = "direct_code", length = 32, columnDefinition = "varchar(32) COMMENT '系统编码'")
  private String directCode;

  @ApiModelProperty("账号")
  @TableField(value = "account")
  @Column(name = "account", length = 32, columnDefinition = "varchar(32) COMMENT '账号'")
  private String account;

  @ApiModelProperty("密码")
  @TableField(value = "password")
  @Column(name = "password", length = 32, columnDefinition = "varchar(32) COMMENT '密码'")
  private String password;

}
