/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.direct.account.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.kms.business.direct.account.local.entity.DirectAccountEntity;
import com.biz.crm.kms.business.direct.account.local.repository.DirectAccountRepository;
import com.biz.crm.kms.business.direct.account.sdk.dto.DirectAccountDto;
import com.biz.crm.kms.business.direct.account.sdk.service.DirectAccountVoService;
import com.biz.crm.kms.business.direct.account.sdk.vo.DirectAccountVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DirectAccountVoServiceImpl
implements DirectAccountVoService {
    private static final Logger log = LoggerFactory.getLogger(DirectAccountVoServiceImpl.class);
    @Autowired(required=false)
    private DirectAccountRepository directAccountRepository;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    public List<DirectAccountVo> findByDirectCode(String directCode) {
        if (StringUtils.isBlank((CharSequence)directCode)) {
            return null;
        }
        List<DirectAccountEntity> entities = this.directAccountRepository.findByDirectCode(directCode, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(entities)) {
            return null;
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, DirectAccountEntity.class, DirectAccountVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<DirectAccountVo> findByDirectCodes(List<String> directCodes) {
        if (CollectionUtils.isEmpty(directCodes)) {
            return null;
        }
        List<DirectAccountEntity> entities = this.directAccountRepository.findByDirectCodes(directCodes, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(entities)) {
            return null;
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, DirectAccountEntity.class, DirectAccountVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<DirectAccountVo> findByAccountList(List<String> accountList) {
        if (CollectionUtils.isEmpty(accountList)) {
            return null;
        }
        List<DirectAccountEntity> entities = this.directAccountRepository.findByAccountList(accountList, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(entities)) {
            return null;
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, DirectAccountEntity.class, DirectAccountVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public DirectAccountVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        DirectAccountEntity entity = this.directAccountRepository.findById(id);
        if (entity == null) {
            return null;
        }
        return (DirectAccountVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, DirectAccountVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public void create(DirectAccountDto dto) {
        this.createValidation(dto);
        DirectAccountEntity entity = (DirectAccountEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, DirectAccountEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.directAccountRepository.save((Object)entity);
    }

    @Transactional
    public void update(DirectAccountDto dto) {
        this.updateValidation(dto);
        DirectAccountEntity oldEntity = this.directAccountRepository.findById(dto.getId());
        Validate.notNull((Object)((Object)oldEntity), (String)"\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\uff01", (Object[])new Object[0]);
        DirectAccountEntity entity = (DirectAccountEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, DirectAccountEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.directAccountRepository.updateById((Object)entity);
    }

    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<DirectAccountEntity> entities = this.directAccountRepository.findByIds(ids);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(entities), (String)"\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\uff01", (Object[])new Object[0]);
        this.directAccountRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<DirectAccountEntity> entities = this.directAccountRepository.findByIds(ids);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(entities), (String)"\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\uff01", (Object[])new Object[0]);
        this.directAccountRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<DirectAccountEntity> entities = this.directAccountRepository.findByIds(ids);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(entities), (String)"\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\uff01", (Object[])new Object[0]);
        this.directAccountRepository.updateDelFlagByIds(ids);
    }

    private void createValidation(DirectAccountDto dto) {
        this.validation(dto);
        dto.setId(null);
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    }

    private void updateValidation(DirectAccountDto dto) {
        this.validation(dto);
        Validate.notBlank((CharSequence)dto.getId(), (String)"ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void validation(DirectAccountDto dto) {
        Validate.notNull((Object)dto, (String)"\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getDirectCode(), (String)"\u7cfb\u7edf\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getAccount(), (String)"\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((dto.getAccount().length() <= 32 ? 1 : 0) != 0, (String)"\u8d26\u53f7\u6700\u591a32\u4f4d\u5b57\u7b26\u4e32", (Object[])new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)dto.getRemark())) {
            Validate.isTrue((dto.getRemark().length() <= 400 ? 1 : 0) != 0, (String)"\u5907\u6ce8\u6700\u591a400\u4f4d\u5b57\u7b26\u4e32", (Object[])new Object[0]);
        }
    }
}

