/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.direct.account.local.service.notifier;

import com.biz.crm.business.common.sdk.vo.UuidVo;
import com.biz.crm.kms.business.direct.account.sdk.service.DirectAccountVoService;
import com.biz.crm.kms.business.direct.sdk.listener.DirectOperationListener;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class DirectAccountListenerImpl
implements DirectOperationListener {
    private static final Logger log = LoggerFactory.getLogger(DirectAccountListenerImpl.class);
    @Autowired(required=false)
    private DirectAccountVoService directAccountVoService;

    @Async(value="otherThread")
    public void onEnable(List<String> directCodes) {
        List directAccountVos = this.directAccountVoService.findByDirectCodes(directCodes);
        if (CollectionUtils.isEmpty((Collection)directAccountVos)) {
            return;
        }
        List ids = directAccountVos.stream().map(UuidVo::getId).distinct().collect(Collectors.toList());
        this.directAccountVoService.enableBatch(ids);
        log.info("\u7cfb\u7edf\u542f\u7528\u65f6\u88ab\u901a\u77e5\u542f\u7528\u7684\u76f4\u8425\u8d26\u53f7ID\u96c6\u5408\uff1a{}", ids);
    }

    @Async(value="otherThread")
    public void onDisable(List<String> directCodes) {
        List directAccountVos = this.directAccountVoService.findByDirectCodes(directCodes);
        if (CollectionUtils.isEmpty((Collection)directAccountVos)) {
            return;
        }
        List ids = directAccountVos.stream().map(UuidVo::getId).distinct().collect(Collectors.toList());
        this.directAccountVoService.disableBatch(ids);
        log.info("\u7cfb\u7edf\u7981\u7528\u65f6\u88ab\u901a\u77e5\u7981\u7528\u7684\u76f4\u8425\u8d26\u53f7ID\u96c6\u5408\uff1a{}", ids);
    }

    @Async(value="otherThread")
    public void onDelete(List<String> directCodes) {
        List directAccountVos = this.directAccountVoService.findByDirectCodes(directCodes);
        if (CollectionUtils.isEmpty((Collection)directAccountVos)) {
            return;
        }
        List ids = directAccountVos.stream().map(UuidVo::getId).distinct().collect(Collectors.toList());
        this.directAccountVoService.updateDelFlagByIds(ids);
        log.info("\u7cfb\u7edf\u5220\u9664\u65f6\u88ab\u901a\u77e5\u5220\u9664\u7684\u76f4\u8425\u8d26\u53f7ID\u96c6\u5408\uff1a{}", ids);
    }
}

