package com.biz.crm.kms.business.direct.account.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 直营账号管理表dto
 *
 * @author xi.peng
 * @since 2022-09-23 10:45:21
 */
@Data
@ApiModel(value = "DirectAccountDto", description = "直营账号管理表dto")
public class DirectAccountDto extends TenantFlagOpDto {

  /**
   * 商超编码
   */
  @ApiModelProperty("系统编码")
  private String directCode;

  /**
   * 账号
   */
  @ApiModelProperty("账号")
  private String account;

  /**
   * 密码（密文）
   */
  @ApiModelProperty("密码")
  private String password;

  /**
   * 确认密码（密文）
   */
  @ApiModelProperty("确认密码（密文）")
  private String confirmPassword;
}

