package com.biz.crm.kms.business.direct.account.sdk.service;

import com.biz.crm.kms.business.direct.account.sdk.dto.DirectAccountDto;
import com.biz.crm.kms.business.direct.account.sdk.vo.DirectAccountVo;

import java.util.List;

/**
 * 直营账号管理表(directAccount)表服务接口
 *
 * @author xi.peng
 * @since 2022-09-23 10:45:21
 */
public interface DirectAccountVoService {

  /**
   * 按系统编码查询详情
   *
   * @param directCode
   * @return
   */
  List<DirectAccountVo> findByDirectCode(String directCode);

  /**
   * 按系统编码查询详情
   *
   * @param directCodes
   * @return
   */
  List<DirectAccountVo> findByDirectCodes(List<String> directCodes);

  /**
   * 按账号集合查询详情
   *
   * @param account
   * @return
   */
  List<DirectAccountVo> findByAccountList(List<String> account);

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  DirectAccountVo findDetailById(String id);

  /**
   * 创建
   *
   * @param dto
   * @return
   */
  void create(DirectAccountDto dto);

  /**
   * 更新
   *
   * @param dto
   * @return
   */
  void update(DirectAccountDto dto);

  /**
   * 按id集合启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 按id集合禁用
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 逻辑删除
   *
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);
}
