package com.biz.crm.kms.business.direct.account.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 直营账号管理表vo
 *
 * @author xi.peng
 * @since 2022-09-23 10:45:22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "直营账号管理表Vo")
public class DirectAccountVo extends TenantFlagOpVo {

  /**
   * 商超编码
   */
  @ApiModelProperty("系统编码")
  private String directCode;

  /**
   * 账号
   */
  @ApiModelProperty("账号")
  private String account;

  /**
   * 密码
   */
  @ApiModelProperty("密码")
  private String password;
}

