package com.biz.crm.kms.business.direct.local.controller;


import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.direct.local.entity.Direct;
import com.biz.crm.kms.business.direct.local.service.DirectService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 系统表(Direct)表相关的http接口
 *
 * @author songjingen
 * @since 2022-09-26 16:31:55
 */
@RestController
@RequestMapping("/v1/direct/direct")
@Slf4j
@Api(tags = "系统：Direct：系统")
public class DirectController {
  /**
   * 服务对象
   */
  @Autowired
  private DirectService directService;

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("{id}")
  public Result<Direct> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      Direct direct = this.directService.findById(id);
      return Result.ok(direct);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 新增数据
   *
   * @param direct 实体对象
   * @return 新增结果
   */
  @ApiOperation(value = "新增数据")
  @PostMapping
  public Result<Direct> create(@ApiParam(name = "direct", value = "系统表") @RequestBody Direct direct) {
    try {
      Direct result = this.directService.create(direct);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 修改数据
   *
   * @param direct 实体对象
   * @return 修改结果
   */
  @ApiOperation(value = "修改数据")
  @PatchMapping
  public Result<Direct> update(@ApiParam(name = "direct", value = "系统表") @RequestBody Direct direct) {
    try {
      Direct result = this.directService.update(direct);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 删除数据（单个或者批量）
   *
   * @param ids 主键集合
   * @return 删除结果
   */
  @DeleteMapping
  @ApiOperation(value = "删除数据（单个或者批量）")
  public Result<?> delete(@ApiParam(name = "ids", value = "主键集合") @RequestParam("ids") List<String> ids) {
    try {
      this.directService.delete(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 启用（单个或者批量）
   *
   * @param ids 主键结合
   * @return 启用结果
   */
  @PatchMapping("enable")
  @ApiOperation(value = "启用（单个或者批量）")
  public Result<?> enable(@ApiParam(name = "ids", value = "主键集合") @RequestBody List<String> ids) {
    try {
      this.directService.enable(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 禁用（单个或者批量）
   *
   * @param ids 主键结合
   * @return 禁用结果
   */
  @PatchMapping("disable")
  @ApiOperation(value = "禁用（单个或者批量）")
  public Result<?> disable(@ApiParam(name = "ids", value = "主键集合") @RequestBody List<String> ids) {
    try {
      this.directService.disable(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
