package com.biz.crm.kms.business.direct.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 系统表
 *
 * @author songjingen
 * @date 2022/9/26
 */
@Getter
@Setter
@Entity
@EqualsAndHashCode(callSuper = false)
@TableName("kms_direct")
@Table(name = "kms_direct", indexes = {
    @Index(name = "kms_direct_index1", columnList = "direct_code,tenant_code", unique = true),
    @Index(name = "kms_direct_index2", columnList = "supermarket_code,sales_org_code", unique = true)
})
@ApiModel(value = "Direct", description = "系统表")
@org.hibernate.annotations.Table(appliesTo = "kms_direct", comment = "系统表")
public class Direct extends TenantFlagOpEntity {

  private static final long serialVersionUID = -2559992139232179428L;


  /**
   * 业态[数据字典:mdm_business_format]
   */
  @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "")
  @Column(name = "business_format_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态[数据字典:mdm_business_format] '")
  private String businessFormatCode;

  /**
   * 业务单元[数据字典:mdm_business_unit]
   */
  @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "")
  @Column(name = "business_unit_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元[数据字典:mdm_business_unit] '")
  private String businessUnitCode;

  /**
   * 系统编码
   */
  @ApiModelProperty("系统编码")
  @Column(name = "direct_code", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '系统编码'")
  private String directCode;

  /**
   * 销售组织编码
   */
  @ApiModelProperty("销售组织编码")
  @TableField(value = "sales_org_code")
  @Column(name = "sales_org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT ' 销售组织编码 '")
  private String salesOrgCode;

  /**
   * 销售组织名称
   */
  @TableField(value = "sales_org_name")
  @ApiModelProperty("销售组织名称")
  @Column(name = "sales_org_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT ' 销售组织名称 '")
  private String salesOrgName;

  /**
   * 关联商超编码
   */
  @ApiModelProperty("关联商超编码")
  @Column(name = "supermarket_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT '关联商超编码'")
  private String supermarketCode;

  /**
   * 客户组织编码
   */
  @ApiModelProperty("客户组织编码")
  @Column(name = "customer_org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户组织编码'")
  private String customerOrgCode;

  /**
   * 客户组织名称
   */
  @ApiModelProperty("客户组织名称")
  @Column(name = "customer_org_name", length = 255, nullable = true, columnDefinition = "varchar(255) COMMENT '客户组织名称'")
  private String customerOrgName;


}
