package com.biz.crm.kms.business.direct.local.imports.service;

import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * 获取字典数据工具类
 *
 * @author zs
 * @date 2022年12月31日 15:41:43
 */
public class DictValueUtil {

  /**
   * 获取字典值
   *
   * @param mapDict
   * @param dictTypeCode
   * @param name
   * @return
   */
  public static String findDictValue(Map<String, List<DictDataVo>> mapDict, String dictTypeCode, String name) {
    if (Objects.isNull(mapDict) || StringUtils.isBlank(dictTypeCode) || StringUtils.isBlank(name)) {
      return StringUtils.EMPTY;
    }
    final List<DictDataVo> vos = mapDict.get(dictTypeCode);
    if (org.apache.commons.collections.CollectionUtils.isEmpty(vos)) {
      return StringUtils.EMPTY;
    }
    final Optional<String> first =
        vos.stream()
            .filter(a -> a.getDictValue().equals(name))
            .map(DictDataVo::getDictCode)
            .findFirst();
    return first.orElse(StringUtils.EMPTY);
  }
}
