package com.biz.crm.kms.business.direct.local.imports.service;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.kms.business.direct.local.constant.DirectConstant;
import com.biz.crm.kms.business.direct.local.entity.Direct;
import com.biz.crm.kms.business.direct.local.imports.model.DirectImportVo;
import com.biz.crm.kms.business.direct.local.service.DirectService;
import com.biz.crm.kms.business.direct.sdk.service.DirectVoService;
import com.biz.crm.kms.business.direct.sdk.vo.DirectVo;
import com.biz.crm.kms.business.supermarket.sdk.service.SupermarketVoService;
import com.biz.crm.kms.business.supermarket.sdk.vo.SupermarketVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Class DirectImportProcess
 * @Description 系统导入
 * @Author : ZS
 * @Date: 2022/12/27  15:14
 */
@Slf4j
@Component
public class DirectImportProcess implements ImportProcess<DirectImportVo> {

    @Autowired(required = false)
    private DirectService directService;
    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required = false)
    private DictDataVoService dictDataVoService;
    @Autowired(required = false)
    private SupermarketVoService supermarketVoService;
    @Autowired
    private DirectVoService directVoService;


    @Override
    public Map<Integer, String> execute(LinkedHashMap<Integer, DirectImportVo> data
            , TaskGlobalParamsVo taskGlobalParamsVo
            , Map<String, Object> map) {

        log.info("系统导入开始",data.values());

        //先查出零售商的名称对应的编码
        List<SupermarketVo> supermarketVos = this.supermarketVoService.findBySupermaketNames(data.values().stream().map(DirectImportVo::getSupermarketName).collect(Collectors.toSet()));
        Map<String ,SupermarketVo> supermarketMaps = supermarketVos.stream().collect(Collectors.toMap(SupermarketVo::getSupermarketName, Function.identity()));
        Set<String> directCodes = data.values().stream().map(DirectImportVo::getDirectCode).collect(Collectors.toSet());
        List<DirectVo> directVos = this.directVoService.findByDirectCodes(directCodes.stream().collect(Collectors.toList()));
        Validate.isTrue(CollectionUtils.isEmpty(directVos),"系统编码已有重复数据");
        Collection<DirectImportVo> directImportVos = data.values();
        List<Direct> directs = new ArrayList<>();
        directImportVos.forEach(aa->{
            log.info("转换开始");
            Direct direct = this.nebulaToolkitService.copyObjectByWhiteList(aa,Direct.class,HashSet.class,ArrayList.class);
            SupermarketVo supermarketVo = supermarketMaps.get(aa.getSupermarketName());
            Validate.isTrue(!Objects.isNull(supermarketVo),"该零售商不存在");
            direct.setSupermarketCode(supermarketVo.getSupermarketCode());
            log.info("调整业态业务单元");
            this.adjustData(direct);
            directs.add(direct);
        });
        log.info("数据校验结束");
        directs.forEach(v->this.directService.create(v));
        return Maps.newHashMap();
    }

    //获取数据字典的值
    /**
     * 调整数据
     *
     * @param data 待调整数据
     * @return 调整后数据
     */
    private Direct adjustData(Direct data) {
        if (ObjectUtils.isEmpty(data)) {
            return new Direct();
        }
        Map<String, List<DictDataVo>> fomatMap = this.dictDataVoService.findByDictTypeCodeList(Lists.newArrayList(DirectConstant.MDM_BUSINESS_FORMAT));
        Map<String, List<DictDataVo>> unitMap = this.dictDataVoService.findByDictTypeCodeList(Lists.newArrayList(DirectConstant.MDM_BUSINESS_UNIT));
        data.setBusinessFormatCode(DictValueUtil.findDictValue(fomatMap, DirectConstant.MDM_BUSINESS_FORMAT, data.getBusinessFormatCode()));
        data.setBusinessUnitCode(DictValueUtil.findDictValue(unitMap, DirectConstant.MDM_BUSINESS_UNIT, data.getBusinessUnitCode()));

        return data;
    }

    @Override
    public Class<DirectImportVo> findCrmExcelVoClass() {
        return DirectImportVo.class;
    }

    @Override
    public String getTemplateCode() {
        return "KMS_DIRECT_IMPORT";
    }

    @Override
    public String getTemplateName() {
        return "系统导入";
    }
}
