package com.biz.crm.kms.business.direct.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.kms.business.direct.local.entity.Direct;
import com.biz.crm.kms.business.direct.sdk.vo.DirectVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 系统表(Direct)表mybatis访问层
 *
 * @author songjingen
 * @since 2022-09-26 16:31:55
 */
public interface DirectMapper extends BaseMapper<Direct> {

    /**
     * 根据销售组织和商超编码查询系统
     * @param saleOrgCodes
     * @param superMarketCodes
     * @param tenantCode
     * @return
     */
    List<DirectVo> findBySaleOrgCodesAndSuperMarketCodes(@RequestParam("saleOrgCodes") List<String> saleOrgCodes
            ,@RequestParam("superMarketCodes") List<String> superMarketCodes
            ,@RequestParam("tenantCode") String tenantCode);

    /**
     * 查询系统编码
     * @param businessUnitCode
     * @param tenantCode
     * @return
     */
    List<DirectVo> findDirectCodesByBusinessUnitCode (@Param("businessUnitCode")String businessUnitCode,@Param("tenantCode")String tenantCode);
}

