package com.biz.crm.kms.business.direct.local.service;


import com.biz.crm.kms.business.direct.local.entity.Direct;

import java.util.List;

/**
 * 系统表(Direct)表服务接口
 *
 * @author songjingen
 * @since 2022-09-26 16:31:55
 */
public interface DirectService {

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  Direct findById(String id);

  /**
   * 新增数据
   *
   * @param direct 实体对象
   * @return 新增结果
   */
  Direct create(Direct direct);

  /**
   * 修改新据
   *
   * @param direct 实体对象
   * @return 修改结果
   */
  Direct update(Direct direct);

  /**
   * 删除数据
   *
   * @param idList 主键结合
   * @return 删除结果
   */
  void delete(List<String> idList);

  /**
   * 启用（单个或者批量）
   *
   * @param idList 主键结合
   * @return 启用结果
   */
  void enable(List<String> idList);

  /**
   * 禁用（单个或者批量）
   *
   * @param idList 主键结合
   * @return 禁用结果
   */
  void disable(List<String> idList);

}

