package com.biz.crm.kms.business.direct.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.kms.business.direct.local.entity.Direct;
import com.biz.crm.kms.business.direct.local.repository.DirectRepository;
import com.biz.crm.kms.business.direct.sdk.service.DirectVoService;
import com.biz.crm.kms.business.direct.sdk.vo.DirectVo;
import com.biz.crm.kms.business.supermarket.sdk.service.SupermarketVoService;
import com.biz.crm.kms.business.supermarket.sdk.vo.SupermarketVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 系统voService实现类
 *
 * @author songjingen
 * @date 2022/9/27
 */
@Service
public class DirectVoServiceImpl implements DirectVoService {

  @Autowired
  private DirectRepository directRepository;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private SupermarketVoService supermarketVoService;

  @Override
  public List<DirectVo> findByDirectCodes(List<String> directCodes) {
    if (CollectionUtils.isEmpty(directCodes)) {
      return new ArrayList<>(0);
    }
    List<Direct> directs = this.directRepository.findByDirectCodes(directCodes);
    if (CollectionUtils.isEmpty(directs)) {
      return new ArrayList<>(0);
    }
    List<DirectVo> directVos = (List<DirectVo>) this.nebulaToolkitService.copyCollectionByWhiteList(directs, Direct.class, DirectVo.class, HashSet.class, ArrayList.class);
    //查询商超数据
    Set<String> supermarketCodes = directVos.stream().map(DirectVo::getSupermarketCode).collect(Collectors.toSet());
    List<SupermarketVo> supermarketVos = this.supermarketVoService.findBySupermarketCodes(supermarketCodes);
    Map<String, String> supermarketNameStuMap = new HashMap<>();
    if (!CollectionUtils.isEmpty(supermarketVos)) {
      supermarketNameStuMap = supermarketVos.stream().collect(Collectors.toMap(SupermarketVo::getSupermarketCode, SupermarketVo::getSupermarketName));
    }
    //赋值
    for (DirectVo directVo : directVos) {
      directVo.setSupermarketName(supermarketNameStuMap.get(directVo.getSupermarketCode()));
    }
    return directVos;
  }

  @Override
  public DirectVo findByDirectCode(String directCode) {
    if(StringUtils.isEmpty(directCode)){
      return null;
    }
    Direct direct = this.directRepository.findByDirectCode(directCode);
    if(direct == null){
      return null;
    }
    DirectVo directVo = this.nebulaToolkitService.copyObjectByBlankList(direct, DirectVo.class, HashSet.class, ArrayList.class);
    return directVo;
  }

  /**
   * 查询全部系统数据
   * */
  @Override
  public List<DirectVo> findAllDirect() {
    LambdaQueryWrapper<Direct> wrapper = Wrappers.<Direct>lambdaQuery();
    wrapper.eq(Direct::getDelFlag, DelFlagStatusEnum.NORMAL.getCode());
    wrapper.eq(Direct::getEnableStatus, EnableStatusEnum.ENABLE.getCode());
    List<Direct> directs = this.directRepository.list(wrapper);
    if (CollectionUtils.isEmpty(directs)) {
      return Lists.newLinkedList();
    }
    List<DirectVo> directVos = (List<DirectVo>) this.nebulaToolkitService.copyCollectionByWhiteList(directs, Direct.class, DirectVo.class, HashSet.class, ArrayList.class);
    //查询商超数据
    Set<String> supermarketCodes = directVos.stream().map(DirectVo::getSupermarketCode).collect(Collectors.toSet());
    List<SupermarketVo> supermarketVos = this.supermarketVoService.findBySupermarketCodes(supermarketCodes);
    Map<String, String> supermarketNameStuMap = new HashMap<>();
    Map<String, String> customerRetailerNameMap = new HashMap<>();
    if (!CollectionUtils.isEmpty(supermarketVos)) {
      supermarketNameStuMap = supermarketVos.stream().collect(Collectors.toMap(SupermarketVo::getSupermarketCode, SupermarketVo::getSupermarketName));
      customerRetailerNameMap = supermarketVos.stream().filter(a -> StringUtils.isNotEmpty(a.getCustomerRetailerName())).collect(Collectors.toMap(SupermarketVo::getSupermarketCode, SupermarketVo::getCustomerRetailerName));
    }
    //赋值
    for (DirectVo directVo : directVos) {
      directVo.setSupermarketName(supermarketNameStuMap.get(directVo.getSupermarketCode()));
      directVo.setCustomerRetailerName(customerRetailerNameMap.get(directVo.getSupermarketCode()));
    }
    return directVos;
  }

  @Override
  public List<DirectVo> findBySaleOrgCodesAndSuperMarketCodes(List<String> saleOrgCodes, List<String> superMarketCodes) {
    List<DirectVo> voList = this.directRepository.findBySaleOrgCodesAndSuperMarketCodes(saleOrgCodes, superMarketCodes);
    if (CollectionUtils.isEmpty(voList)){
      return Lists.newArrayList();
    }else {
      return voList;
    }
  }

  @Override
  public List<DirectVo> findDirectCodesByBusinessUnitCode(String businessUnitCode) {
    return this.directRepository.findDirectCodesByBusinessUnitCode(businessUnitCode);
  }
}
