package com.biz.crm.kms.business.direct.local.service.notifier;

import com.biz.crm.kms.business.direct.local.entity.Direct;
import com.biz.crm.kms.business.direct.local.repository.DirectRepository;
import com.biz.crm.kms.business.supermarket.sdk.listener.SupermarketOperationListener;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 系统实现商超操作监听器
 *
 * @author songjingen
 * @date 2022/9/27
 */
@Component
public class SupermarketOperationForDirectListener implements SupermarketOperationListener {

  @Autowired
  private DirectRepository directRepository;

  @Override
  public void onEnable(List<String> supermarketCodes) {

  }

  @Override
  public void onDisable(List<String> supermarketCodes) {

  }

  /**
   * 商超系统数据执行删除时，系统需要验证当前商超是否正在被使用，如果是则不允许删除
   *
   * @param supermarketCodes 商超编码集合
   */
  @Override
  public void onDelete(List<String> supermarketCodes) {
    Validate.isTrue(!CollectionUtils.isEmpty(supermarketCodes), "系统监听商超删除时，未获取到商朝编码参数集合！");
    List<Direct> directs = this.directRepository.findBySupermarketCodes(supermarketCodes);
    Validate.isTrue(CollectionUtils.isEmpty(directs), "系统监听商超删除时，存在系统，不允许删除！");
  }
}
