package com.biz.crm.kms.business.direct.product.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.direct.product.sdk.dto.DirectProductDto;
import com.biz.crm.kms.business.direct.product.sdk.service.DirectProductVoService;
import com.biz.crm.kms.business.direct.product.sdk.vo.DirectProductVo;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgBaseDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import java.util.List;

import lombok.extern.slf4j.Slf4j;

/**
 * 直营上架产品管理表(DirectProduct)表控制层
 *
 * @author xi.peng
 * @since 2022-09-23 10:47:58
 */
@Slf4j
@Api(tags = "直营上架产品管理表：DirectProductVo：直营上架产品")
@RestController
@RequestMapping(value = {"/v1/directProduct/directProductVo"})
public class DirectProductVoController {

  @Autowired(required = false)
  private DirectProductVoService directProductVoService;

  @ApiOperation(value = "条件查询列表")
  @GetMapping(value = {"/findByListConditions"})
  public Result<List<DirectProductVo>> findByListConditions(DirectProductDto dto) {
    try {
      List<DirectProductVo> result = this.directProductVoService.findByListConditions(dto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "按系统编码查询详情")
  @GetMapping(value = {"/findByDirectCode"})
  public Result<List<DirectProductVo>> findByDirectCode(@RequestParam("directCode") String directCode) {
    try {
      List<DirectProductVo> result = this.directProductVoService.findByDirectCode(directCode);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "详情")
  @GetMapping(value = {"/findDetailById"})
  public Result<DirectProductVo> findDetailById(@RequestParam("id") String id) {
    try {
      DirectProductVo vo = this.directProductVoService.findDetailById(id);
      return Result.ok(vo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "创建")
  @PostMapping(value = "")
  public Result create(@RequestBody DirectProductDto dto) {
    try {
      this.directProductVoService.create(dto);
      return Result.ok("创建成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "更新")
  @PatchMapping(value = "")
  public Result update(@RequestBody DirectProductDto dto) {
    try {
      this.directProductVoService.update(dto);
      return Result.ok("更新成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "启用")
  @PatchMapping("/enable")
  public Result enable(@RequestBody List<String> ids) {
    try {
      this.directProductVoService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "禁用")
  @PatchMapping("/disable")
  public Result disable(@RequestBody List<String> ids) {
    try {
      this.directProductVoService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "逻辑删除")
  @DeleteMapping("/delete")
  public Result delete(@RequestParam("ids") List<String> ids) {
    try {
      this.directProductVoService.updateDelFlagByIds(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 批量拉取 MDG 上架产品数据
   *
   * @param dto 请求参数
   * @return 上架产品列表
   */
  @ApiOperation(value = "批量拉取 MDG 上架产品数据")
  @PostMapping(value = {"/pullKmsDirectProductList"})
  public Result<?> pullKmsDirectProductList(@RequestBody MasterDataMdgBaseDto dto) {
    try {
      this.directProductVoService.pullKmsDirectProductList(dto);
      return Result.ok("批量拉取 MDG 上架产品数据成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 手动触发缓存产品税率
   */
  @ApiOperation(value = "手动触发缓存产品税率")
  @GetMapping(value = {"/cacheProductTaxRate"})
  public Result<?> cacheProductTaxRate() {
    try {
      directProductVoService.cacheProductTaxRate();
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
