package com.biz.crm.kms.business.direct.product.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 直营上架产品管理表(DirectProduct)实体类
 * 
 * @author pengxi
 * @since 2022-09-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName(value = "kms_direct_product")
@Table(name = "kms_direct_product", indexes = {
        @Index(name = "kms_direct_product_index1", columnList = "direct_code"),
        @Index(name = "kms_direct_product_index2", columnList = "ka_product_code"),
})
@ApiModel(value = "DirectProduct", description = "直营上架产品管理表")
@org.hibernate.annotations.Table(appliesTo = "kms_direct_product", comment = "直营上架产品管理表")
public class DirectProductEntity extends TenantFlagOpEntity {

  /**
   * 业态[数据字典:mdm_business_format]
   */
  @ApiModelProperty(value = "业态[数据字典:mdm_business_format]", notes = "")
  @Column(name = "business_format_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '业态[数据字典:mdm_business_format] '")
  private String businessFormatCode;

  /**
   * 业务单元[数据字典:mdm_business_unit]
   */
  @ApiModelProperty(value = "业务单元[数据字典:mdm_business_unit]", notes = "")
  @Column(name = "business_unit_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '业务单元[数据字典:mdm_business_unit] '")
  private String businessUnitCode;

  @ApiModelProperty("系统编码")
  @TableField(value = "direct_code")
  @Column(name = "direct_code", length = 32, columnDefinition = "varchar(32) COMMENT '系统编码'")
  private String directCode;

  @ApiModelProperty("售达方编码")
  @TableField(value = "sell_party_code")
  @Column(name = "sell_party_code", length = 64, columnDefinition = "varchar(32) COMMENT '售达方编码'")
  private String sellPartyCode;

  @ApiModelProperty("售达方名称")
  @TableField(value = "sell_party_name")
  @Column(name = "sell_party_name", length = 255, columnDefinition = "varchar(255) COMMENT '售达方名称'")
  private String sellPartyName;

  @ApiModelProperty("送达方编码")
  @TableField(value = "delivery_party_code")
  @Column(name = "delivery_party_code", length = 64, columnDefinition = "varchar(32) COMMENT '送达方编码'")
  private String deliveryPartyCode;

  @ApiModelProperty("送达方名称")
  @TableField(value = "delivery_party_name")
  @Column(name = "delivery_party_name", length = 255, columnDefinition = "varchar(255) COMMENT '售达方名称'")
  private String deliveryPartyName;

  @ApiModelProperty("产品编码")
  @TableField(value = "product_code")
  @Column(name = "product_code", length = 64, columnDefinition = "varchar(32) COMMENT '企业产品编码'")
  private String productCode;

  @ApiModelProperty("产品名称")
  @TableField(value = "product_name")
  @Column(name = "product_name", length = 255, columnDefinition = "varchar(255) COMMENT '企业产品名称'")
  private String productName;

  @ApiModelProperty("商超产品编码")
  @TableField(value = "ka_product_code")
  @Column(name = "ka_product_code", length = 64, columnDefinition = "varchar(32) COMMENT '客户产品编码'")
  private String kaProductCode;

  @ApiModelProperty("商超产品名称")
  @TableField(value = "ka_product_name")
  @Column(name = "ka_product_name", length = 255, columnDefinition = "varchar(255) COMMENT '客户产品名称'")
  private String kaProductName;

  @ApiModelProperty("是否默认物料（0：否，1：是）")
  @TableField(value = "is_default")
  @Column(name = "is_default", length = 8, columnDefinition = "varchar(32) COMMENT '是否默认物料（0：否，1：是）'")
  private String isDefault;

  @ApiModelProperty("上下架（0：下架，1：上架）")
  @TableField(value = "on_shelf_status")
  @Column(name = "on_shelf_status", length = 8, columnDefinition = "varchar(32) COMMENT '上下架（0：下架，1：上架）'")
  private String onShelfStatus;

  /**
   * 数据来源
   */
  @ApiModelProperty("数据来源")
  @Column(name = "source_type", length = 32, columnDefinition = "VARCHAR(32) COMMENT '数据来源'")
  private String sourceType;

  /**
   * 税率
   */
  @ApiModelProperty("税率")
  @Column(name = "tax_rate", columnDefinition = "decimal(20,4) COMMENT '税率'")
  private BigDecimal taxRate;
}
