package com.biz.crm.kms.business.direct.product.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 直营上架产品单位管理表(DirectProductUnit)实体类
 *
 * @author pengxi
 * @since 2022-09-23 10:49:13
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@Table(name = "kms_direct_product_unit")
@TableName(value = "kms_direct_product_unit")
@ApiModel(value = "DirectProductUnitEntity", description = "直营上架产品单位管理表")
@org.hibernate.annotations.Table(appliesTo = "kms_direct_product_unit", comment = "直营上架产品单位管理表")
public class DirectProductUnitEntity extends UuidEntity {

  @ApiModelProperty("企业产品与客户产品关系ID")
  @TableField(value = "direct_product_id")
  @Column(name = "direct_product_id", length = 256, columnDefinition = "varchar(256) COMMENT '企业产品与客户产品关系ID'")
  private String directProductId;

  @ApiModelProperty("单据类型")
  @TableField(value = "order_type")
  @Column(name = "order_type", length = 32, columnDefinition = "varchar(64) COMMENT '单据类型'")
  private String orderType;

  @ApiModelProperty("企业产品单位编码")
  @TableField(value = "unit_code")
  @Column(name = "unit_code", length = 64, columnDefinition = "varchar(64) COMMENT '企业产品单位编码'")
  private String unitCode;

  @ApiModelProperty("企业产品单位名称")
  @TableField(value = "unit_name")
  @Column(name = "unit_name", length = 255, columnDefinition = "varchar(255) COMMENT '企业产品单位名称'")
  private String unitName;

  @ApiModelProperty("企业单位数量")
  @TableField(value = "unit_quantity")
  @Column(name = "unit_quantity", length = 11, columnDefinition = "int COMMENT '企业单位数量'")
  private BigDecimal unitQuantity;

  @ApiModelProperty("客户产品单位编码")
  @TableField(value = "ka_unit_code")
  @Column(name = "ka_unit_code", length = 64, columnDefinition = "varchar(64) COMMENT '客户产品单位编码'")
  private String kaUnitCode;

  @ApiModelProperty("客户产品单位数量")
  @TableField(value = "ka_unit_quantity")
  @Column(name = "ka_unit_quantity", length = 11, columnDefinition = "int COMMENT '客户产品单位数量'")
  private BigDecimal kaUnitQuantity;
}
