package com.biz.crm.kms.business.direct.product.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.kms.business.direct.product.local.entity.DirectProductEntity;
import com.biz.crm.kms.business.direct.product.sdk.dto.DirectProductDto;
import com.biz.crm.kms.business.direct.product.sdk.vo.DirectProductVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 直营上架产品管理表(DirectProduct)表数据库访问层
 *
 * @author xi.peng
 * @since 2022-09-23 10:47:57
 */
public interface DirectProductMapper extends BaseMapper<DirectProductEntity> {

  /**
   * 条件列表
   *
   * @param dto  分页参数dto
   * @return 分页列表
   */
  List<DirectProductVo> findByConditions(@Param("dto") DirectProductDto dto);

  /**
   * 查询产品编码集合
   *
   * @return
   */
    List<String> findProductCodes();
}

