package com.biz.crm.kms.business.direct.product.local.repository;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.kms.business.direct.product.local.entity.DirectProductUnitEntity;
import com.biz.crm.kms.business.direct.product.local.mapper.DirectProductUnitMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.List;

/**
 * 直营上架产品单位管理表(repository)
 *
 * @author xi.peng
 * @since 2022-09-23 10:47:58
 */
@Component
public class DirectProductUnitRepository extends ServiceImpl<DirectProductUnitMapper, DirectProductUnitEntity> {

  /**
   * 根据企业产品与客户产品关系ID集合获取直营上架产品单位管理集合
   *
   * @param directProductIds 企业产品与客户产品关系ID集合
   * @param orderType
   * @return
   */
  public List<DirectProductUnitEntity> findByDirectProductIds(List<String> directProductIds, String orderType) {
    if (CollectionUtil.isEmpty(directProductIds)){
      return Collections.emptyList();
    }
    return this.lambdaQuery()
        .in(DirectProductUnitEntity::getDirectProductId, directProductIds)
        .eq(StringUtils.isNotBlank(orderType),DirectProductUnitEntity::getOrderType, orderType)
        .list();
  }
  
  /**
   * 根据企业产品与客户产品关系ID删除
   *
   * @param directProductId
   */
  public void deleteByDirectProductId(String directProductId) {
    this.lambdaUpdate()
        .eq(DirectProductUnitEntity::getDirectProductId, directProductId)
        .remove();
  }

  /**
   * 根据企业产品与客户产品关系ID集合删除
   * @param directProductIds
   */
  public void deleteByDirectProductIds(List<String> directProductIds){
    this.lambdaUpdate()
            .in(DirectProductUnitEntity::getDirectProductId, directProductIds)
            .remove();
  }
}
