package com.biz.crm.kms.business.direct.product.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.kms.business.direct.product.sdk.service.DirectProductUnitVoService;
import com.biz.crm.kms.business.direct.product.local.entity.DirectProductUnitEntity;
import com.biz.crm.kms.business.direct.product.local.repository.DirectProductUnitRepository;
import com.biz.crm.kms.business.direct.product.sdk.dto.DirectProductUnitDto;
import com.biz.crm.kms.business.direct.product.sdk.vo.DirectProductUnitVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

/**
 * 直营上架产品单位管理表表(DirectProductUnit)表服务实现类
 *
 * @author xi.peng
 * @since 2022-09-23 10:49:13
 */
@Slf4j
@Service
public class DirectProductUnitVoServiceServiceImpl implements DirectProductUnitVoService {

  @Autowired(required = false)
  private DirectProductUnitRepository directProductUnitRepository;

  @Autowired(required = false)
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public List<DirectProductUnitVo> findDirectProductIds(List<String> directProductIds, String orderType) {
    if (CollectionUtils.isEmpty(directProductIds)) {
      return null;
    }
    List<DirectProductUnitEntity> labelEntities = this.directProductUnitRepository.findByDirectProductIds(directProductIds,orderType);
    if (CollectionUtils.isEmpty(labelEntities)) {
      return null;
    }
    return  (List<DirectProductUnitVo>) this.nebulaToolkitService.copyCollectionByWhiteList(labelEntities, DirectProductUnitEntity.class, DirectProductUnitVo.class, HashSet.class, ArrayList.class);
  }

  @Override
  @Transactional
  public void createBatch(List<DirectProductUnitDto> dtoList) {
    this.validation(dtoList);
    List<DirectProductUnitEntity> optionEntities = (List<DirectProductUnitEntity>) this.nebulaToolkitService.copyCollectionByWhiteList(dtoList, DirectProductUnitDto.class, DirectProductUnitEntity.class, HashSet.class, ArrayList.class);
    this.directProductUnitRepository.saveBatch(optionEntities);
  }

  @Override
  @Transactional
  public void deleteByDirectProductId(String directProductId) {
    Validate.notBlank(directProductId, "企业产品与客户产品关系ID不能为空！");
    List<DirectProductUnitEntity> optionEntities = this.directProductUnitRepository.findByDirectProductIds(Collections.singletonList(directProductId),null);
    if (CollectionUtils.isEmpty(optionEntities)) {
      // 如果已删除或不存在就不继续向下执行
      return;
    }
    this.directProductUnitRepository.deleteByDirectProductId(directProductId);
  }

  @Override
  public void deleteByProductIdList(List<String> productIdList) {
    if(CollectionUtils.isEmpty(productIdList)){
      return;
    }
    LambdaUpdateWrapper<DirectProductUnitEntity> wrapper = Wrappers.<DirectProductUnitEntity>lambdaUpdate();
    wrapper.in(DirectProductUnitEntity::getDirectProductId,productIdList);
    this.directProductUnitRepository.remove(wrapper);
  }

  private void validation(List<DirectProductUnitDto> dtoList) {
    Validate.notEmpty(dtoList, "商品单位集合对象不能为空！");
    dtoList.forEach(dto->{
      Validate.notBlank(dto.getDirectProductId(), "企业产品与客户产品关系ID不能为空！");
      Validate.notBlank(dto.getOrderType(), "单据类型不能为空！");
      Validate.notBlank(dto.getUnitCode(), "企业产品单位编码不能为空！");
      Validate.notBlank(dto.getUnitName(), "企业产品单位名称不能为空！");
      Validate.notNull(dto.getUnitQuantity(), "企业单位数量不能为空！");
      Validate.notNull(dto.getKaUnitQuantity(), "客户产品单位数量不能为空！");
      //长度校验
      Validate.isTrue(dto.getUnitQuantity().toString().length()<=11, "企业单位数量最多11位数字");
      Validate.isTrue(dto.getKaUnitQuantity().toString().length()<=11, "客户产品单位数量最多11位数字");
//      Validate.isTrue(dto.getKaUnitCode().length()<=64, "客户产品单位编码最多64位字符串");
    });
  }
}
