package com.biz.crm.kms.business.direct.product.sdk.constant;

import lombok.AccessLevel;
import lombok.NoArgsConstructor;

/**
 * 产品数据常量类
 *
 * @author cyj
 * @date 2022/11/29
 */
@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class ProductConstant {

  /**
   * redis锁定时间
   * */
  public static final Integer STORE_REDIS_TIME = 1800;

  /**
   * 分页默认开始页数
   * */
  public static final Integer STORE_PAGE_NUM = 1;

  /**
   * 分页size
   */
  public static final Integer STORE_PAGE_SIZE = 1000;

  /**
   * 门店redis锁前缀
   * */
  public static final String STORE_PULL_LOCK = "KMS:STORE:PULL:LOCK";
  /**
   * 缓存过期时间
   */
  public static final long CACHE_EXPIRE_TIME = 24*60*60;
  /**
   * 缓存过期时间
   */
  public static final String CACHE_PRODUCT_TAX_RATE = "KMS:CACHE:PRODUCT_TAX_RATE";
}
