package com.biz.crm.kms.business.direct.product.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 直营上架产品管理表dto
 *
 * @author xi.peng
 * @since 2022-09-23 10:45:21
 */
@Data
@ApiModel(value = "DirectProductDto", description = "直营上架产品管理表dto")
public class DirectProductDto extends TenantFlagOpDto {

  /**
   * 业态[数据字典:mdm_business_format]
   */
  @ApiModelProperty(value = "业态[数据字典:mdm_business_format]", notes = "")
  private String businessFormatCode;

  /**
   * 业务单元[数据字典:mdm_business_unit]
   */
  @ApiModelProperty(value = "业务单元[数据字典:mdm_business_unit]", notes = "")
  private String businessUnitCode;

  /**
   * 系统编码
   */
  @ApiModelProperty("系统编码")
  private String directCode;
  /**
   * 单据类型
   */
  @ApiModelProperty("单据类型")
  private String orderType;

  /**
   * 售达方编码
   */
  @ApiModelProperty("售达方编码")
  private String sellPartyCode;

  /**
   * 售达方名称
   */
  @ApiModelProperty("售达方名称")
  private String sellPartyName;

  /**
   * 送达方编码
   */
  @ApiModelProperty("送达方编码")
  private String deliveryPartyCode;

  /**
   * 送达方名称
   */
  @ApiModelProperty("送达方名称")
  private String deliveryPartyName;

  /**
   * 企业产品编码
   */
  @ApiModelProperty("产品编码")
  private String productCode;

  /**
   * 企业产品名称
   */
  @ApiModelProperty("产品名称")
  private String productName;

  /**
   * 客户产品编码
   */
  @ApiModelProperty("商超产品编码")
  private String kaProductCode;

  /**
   * 客户产品名称
   */
  @ApiModelProperty("商超产品名称")
  private String kaProductName;

  /**
   * 是否默认物料（0：否，1：是）
   */
  @ApiModelProperty("是否默认物料（0：否，1：是）")
  private String isDefault;

  /**
   * 上下架（0：下架，1：上架）
   */
  @ApiModelProperty("上下架（0：下架，1：上架）")
  private String onShelfStatus;

  /**
   * 数据来源
   */
  @ApiModelProperty("数据来源")
  private String sourceType;

  /**
   * 商品单位列表
   */
  @ApiModelProperty("商品单位列表")
  List<DirectProductUnitDto> unitList;

  /**
   * 系统编码集合
   */
  @ApiModelProperty("系统编码集合")
  private List<String> directCodes;
  /**
   * 送达方编码集合
   */
  @ApiModelProperty("送达方编码集合")
  private List<String> deliveryPartyCodes;

  /**
   * 企业产品编码集合
   */
  @ApiModelProperty("企业产品编码集合")
  private List<String> productCodes;

  /**
   * 客户产品编码集合
   */
  @ApiModelProperty("客户产品编码集合")
  private List<String> kaProductCodes;

  @ApiModelProperty("售达方编码集合")
  private List<String> sellPartyCodes;

  /**
   * 产品搜索关键字
   */
  @ApiModelProperty("产品搜索关键字")
  private String productKeyword;
}

