package com.biz.crm.kms.business.direct.product.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 直营上架产品管理表分页查询dto
 *
 * @author xi.peng
 * @since 2022-09-23 10:45:20
 */
@Data
@ApiModel(value = "DirectProductPageDto", description = "直营上架产品管理表分页查询dto")
public class DirectProductPageDto extends TenantFlagOpDto {

  /**
   * 系统编码
   */
  @ApiModelProperty("系统编码")
  private String directCode;

  /**
   * 系统编码集合
   */
  @ApiModelProperty("系统编码集合")
  private List<String> directCodes;

  /**
   * 产品搜索关键字
   */
  @ApiModelProperty("产品搜索关键字")
  private String productKeyword;

}

