package com.biz.crm.kms.business.direct.product.sdk.dto;

import com.biz.crm.business.common.sdk.dto.UuidDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 直营上架产品单位管理表dto
 *
 * @author xi.peng
 * @since 2022-09-23 10:45:21
 */
@Data
@ApiModel(value = "DirectProductUnitDto", description = "直营上架产品单位管理表dto")
public class DirectProductUnitDto extends UuidDto {

  /**
   * 企业产品与客户产品关系ID
   */
  @ApiModelProperty("企业产品与客户产品关系ID")
  private String directProductId;

  /**
   * 单据类型
   */
  @ApiModelProperty("单据类型")
  private String orderType;

  /**
   * 企业产品单位编码
   */
  @ApiModelProperty("企业产品单位编码")
  private String unitCode;

  /**
   * 企业产品单位名称
   */
  @ApiModelProperty("企业产品单位名称")
  private String unitName;

  /**
   * 企业单位数量
   */
  @ApiModelProperty("企业单位数量")
  private BigDecimal unitQuantity;

  /**
   * 客户产品单位编码
   */
  @ApiModelProperty("客户产品单位编码")
  private String kaUnitCode;

  /**
   * 商超单位数量
   */
  @ApiModelProperty("商超单位数量")
  private BigDecimal kaUnitQuantity;
}

