package com.biz.crm.kms.business.direct.product.sdk.event;

import com.biz.crm.kms.business.direct.product.sdk.dto.DirectProductLogEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

public interface DirectProductVoLogEventListener extends NebulaEvent {

    /**
     * 创建预算项目事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onCreate(DirectProductLogEventDto dto);

    /**
     * 删除预算项目事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onDelete(DirectProductLogEventDto dto);

    /**
     * 修改预算项目事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onUpdate(DirectProductLogEventDto dto);

    /**
     * 启用预算项目事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onEnable(DirectProductLogEventDto dto);

    /**
     * 禁用预算项目事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onDisable(DirectProductLogEventDto dto);
}
